/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile.settings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profile.settings.IMType;
import org.exoplatform.social.core.profile.settings.UserProfileSettingsService;
import org.exoplatform.social.webui.profile.settings.UIIMControlRenderer;
import org.exoplatform.social.webui.profile.settings.UIValueControl;
import org.exoplatform.webui.application.WebuiRequestContext;

public class UserProfileRenderingService {
    private static final Log LOG = ExoLogger.getLogger(UserProfileRenderingService.class);
    protected final UserProfileSettingsService settingsService;
    protected final Map<String, UIIMControlRenderer> imControls = new HashMap<String, UIIMControlRenderer>();

    public UserProfileRenderingService(UserProfileSettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void addIMControl(UIIMControlRenderer plugin) {
        IMType imt = plugin.getType();
        UIIMControlRenderer prev = this.imControls.put(imt.getId(), plugin);
        if (prev != null) {
            LOG.info((Object)("IM type '" + imt.getId() + "' UI control redefined from '" + prev.getType() + "' to '" + imt + "'"));
        }
    }

    public UIValueControl getIMControl() {
        return new UIIMValueControl();
    }

    class UIIMValueControl
    implements UIValueControl {
        UIIMValueControl() {
        }

        @Override
        public void render(String imtId, String imId, WebuiRequestContext context) throws IOException, Exception {
            UIIMControlRenderer renderer = UserProfileRenderingService.this.imControls.get(imtId);
            if (renderer != null) {
                renderer.render(imId, context);
            }
        }
    }
}

