/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/space/UISpaceUserSearch.gtmpl", events={@EventConfig(listeners={SearchActionListener.class})})
public class UISpaceUserSearch
extends UIForm {
    private List<User> userList;
    private String groupId;
    private static final String FIELD_KEYWORD = "fieldKeyword";
    private static final String FIELD_FILTER = "fieldFilter";
    private static final String USER_NAME = "userName";
    private static final String LAST_NAME = "lastName";
    private static final String FIRST_NAME = "firstName";
    private static final String EMAIL = "email";

    public UISpaceUserSearch() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_FILTER, FIELD_FILTER, this.getFilters()));
        this.groupId = this.getGroupId();
    }

    public void setUserList(List<User> userList) {
        this.userList = userList;
    }

    public List<User> getUserList() {
        return this.userList;
    }

    private String getGroupId() throws Exception {
        if (this.groupId == null) {
            String spaceUrl = Utils.getSpaceUrlByContext();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            return spaceService.getSpaceByUrl(spaceUrl).getGroupId();
        }
        return this.groupId;
    }

    private List<SelectItemOption<String>> getFilters() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(USER_NAME, (Object)USER_NAME));
        options.add(new SelectItemOption(FIRST_NAME, (Object)FIRST_NAME));
        options.add(new SelectItemOption(LAST_NAME, (Object)LAST_NAME));
        options.add(new SelectItemOption(EMAIL, (Object)EMAIL));
        return options;
    }

    protected List<User> search(String keyword, String filter, String groupId) throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        Query q = new Query();
        if (keyword != null && keyword.trim().length() != 0) {
            if (keyword.indexOf("*") < 0) {
                if (keyword.charAt(0) != '*') {
                    keyword = "*" + keyword;
                }
                if (keyword.charAt(keyword.length() - 1) != '*') {
                    keyword = keyword + "*";
                }
            }
            keyword = keyword.replace('?', '_');
            if (USER_NAME.equals(filter)) {
                q.setUserName(keyword);
            }
            if (LAST_NAME.equals(filter)) {
                q.setLastName(keyword);
            }
            if (FIRST_NAME.equals(filter)) {
                q.setFirstName(keyword);
            }
            if (EMAIL.equals(filter)) {
                q.setEmail(keyword);
            }
        }
        CopyOnWriteArrayList<User> results = new CopyOnWriteArrayList<User>();
        results.addAll(service.getUserHandler().findUsers(q).getAll());
        MembershipHandler memberShipHandler = service.getMembershipHandler();
        if (groupId != null && groupId.trim().length() != 0) {
            for (Object e : results) {
                if (memberShipHandler.findMembershipsByUserAndGroup(((User)e).getUserName(), groupId).size() != 0) continue;
                results.remove(e);
            }
        }
        return results;
    }

    public static class SearchActionListener
    extends EventListener<UISpaceUserSearch> {
        public void execute(Event<UISpaceUserSearch> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UISpaceUserSearch uiSearch = (UISpaceUserSearch)((Object)event.getSource());
            String keyword = (String)uiSearch.getUIStringInput(UISpaceUserSearch.FIELD_KEYWORD).getValue();
            String filter = (String)uiSearch.getUIFormSelectBox(UISpaceUserSearch.FIELD_FILTER).getValue();
            uiSearch.setUserList(uiSearch.search(keyword, filter, uiSearch.getGroupId()));
            uiSearch.getParent().createEvent("Search", Event.Phase.DECODE, ctx).broadcast();
        }
    }
}

