/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection;

import java.util.HashMap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.extras.injection.AbstractSocialInjector;
import org.exoplatform.social.extras.injection.PatternInjectorConfig;

public class MembershipInjector
extends AbstractSocialInjector {
    private final int FLUSH_LIMIT = 5;
    private static final String MEMBERSHIP_TYPE = "type";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private static final String FROM_SPACE = "fromSpace";
    private static final String TO_SPACE = "toSpace";
    private static final String SPACE_PREFIX = "spacePrefix";
    private String identitiesInfo = "";

    public MembershipInjector(PatternInjectorConfig pattern) {
        super(pattern);
    }

    public void inject(HashMap<String, String> params) throws Exception {
        int floor;
        String type = params.get(MEMBERSHIP_TYPE);
        int fromUser = this.param(params, FROM_USER);
        int toUser = this.param(params, TO_USER);
        String userPrefix = params.get(USER_PREFIX);
        int fromSpace = this.param(params, FROM_SPACE);
        int toSpace = this.param(params, TO_SPACE);
        String spacePrefix = params.get(SPACE_PREFIX);
        if (!"manager".equals(type) && !"member".equals(type)) {
            this.getLog().info((Object)("'" + type + "' is a wrong value for membership type parameter. Please set it to 'member' or 'manager'. Aborting injection ..."));
            return;
        }
        this.init(userPrefix, spacePrefix, userSuffixValue, spaceSuffixValue);
        this.getLog().info((Object)"About to inject Space Members :");
        this.getLog().info((Object)("" + (toSpace - fromSpace + 1) + " space(s) has prefix '" + spacePrefix + " ' with " + (toUser - fromUser + 1) + " member(s) has prefix '" + userPrefix + "'"));
        for (int i = floor = fromSpace; i <= toSpace; ++i) {
            this.generate(i, type, fromUser, toUser);
        }
        this.getLog().info((Object)"completed to inject Space Members");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(int spaceIdx, String type, int from, int to) {
        String spaceName = this.spaceNameSuffixPattern(spaceIdx);
        String spacePrettyBaseName = SpaceUtils.cleanString((String)spaceName);
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyBaseName);
        if (space == null) {
            this.getLog().info((Object)("space with display name: " + spaceName + "is not existing"));
            return;
        }
        int counter = 0;
        try {
            Identity identity = null;
            for (int i = from; i <= to; ++i) {
                String username = this.userNameSuffixPattern(i);
                identity = this.identityManager.getOrCreateIdentity("organization", username, false);
                space.setEditor(username);
                this.getLog().info((Object)("added user(s) " + identity.getRemoteId() + " to " + type + " of '" + spaceName + "' space."));
                if ("member".endsWith(type)) {
                    this.spaceService.addMember(space, identity.getRemoteId());
                } else if ("manager".endsWith(type)) {
                    this.spaceService.setManager(space, identity.getRemoteId(), true);
                }
                if (++counter != 5) continue;
                counter = 0;
                StorageUtils.persist();
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                this.getLog().info((Object)"Flush session...");
            }
        }
        finally {
            if (counter > 0) {
                StorageUtils.persist();
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            }
        }
    }
}

