/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.link;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.plugin.link.UILinkActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class UILinkActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(UILinkActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        UILinkActivity uiLinkActivity = (UILinkActivity)uiActivity;
        if (activity.getTemplateParams() == null) {
            this.saveToNewDataFormat(activity);
        }
        Map templateParams = activity.getTemplateParams();
        uiLinkActivity.setLinkSource((String)templateParams.get("link"));
        uiLinkActivity.setLinkTitle((String)templateParams.get("title"));
        uiLinkActivity.setLinkImage((String)templateParams.get("image"));
        uiLinkActivity.setLinkDescription((String)templateParams.get("description"));
        uiLinkActivity.setLinkComment((String)templateParams.get("comment"));
        uiLinkActivity.setEmbedHtml((String)templateParams.get("html"));
    }

    private void saveToNewDataFormat(ExoSocialActivity activity) {
        try {
            JSONObject jsonObj = new JSONObject(activity.getTitle());
            StringBuilder linkTitle = new StringBuilder("Shared a link:");
            linkTitle.append(" <a href=\"${").append("link").append("}\">${").append("title").append("} </a>");
            activity.setTitle(linkTitle.toString());
            HashMap<String, String> templateParams = new HashMap<String, String>();
            templateParams.put("link", jsonObj.getString("link"));
            templateParams.put("title", jsonObj.getString("title"));
            templateParams.put("image", jsonObj.getString("image"));
            templateParams.put("description", jsonObj.getString("description"));
            templateParams.put("comment", jsonObj.getString("comment"));
            activity.setTemplateParams(templateParams);
            ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).saveActivityNoReturn(activity);
        }
        catch (JSONException je) {
            LOG.error((Object)"Error with activity's title data");
        }
        catch (ActivityStorageException ase) {
            LOG.warn((Object)"Could not save new data format for document activity.", (Throwable)ase);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error  to save document activity.", (Throwable)e);
        }
    }
}

