/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration.io;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.social.extras.migration.MigrationException;

public class WriterContext {
    private final String CONTEXT_FROM_VERSION = "from";
    private final String CONTEXT_TO_VERSION = "to";
    private final String CONTEXT_NODE_NAME = "migration_context";
    private final String CONTEXT_VALUE_NAME = "value";
    private final String CONTEXT_COMPLETION_NAME = "completion";
    private final String CONTEXT_DONE_NAME = "done";
    private final Session session;

    public WriterContext(Session session, String from, String to) {
        this.session = session;
        if (this.exists()) {
            throw new MigrationException("Unable to init context because it already exists. Please use rollback command.");
        }
        this.set("from", from);
        this.set("to", to);
    }

    public WriterContext(Session session) {
        this.session = session;
        if (!this.exists()) {
            throw new MigrationException("Unable to restore context because it doesn't exists.");
        }
    }

    public String get(String key) {
        try {
            return this.getContextNode().getNode(key).getProperty("value").getString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public void put(String key, String value) {
        Node keyNode;
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            keyNode = this.getContextNode().getNode(key);
        }
        catch (RepositoryException e) {
            try {
                keyNode = this.getContextNode().addNode(key);
            }
            catch (RepositoryException e1) {
                throw new RuntimeException(e1);
            }
        }
        try {
            keyNode.setProperty("value", value);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFrom() {
        return this.getString("from");
    }

    public String getTo() {
        return this.getString("to");
    }

    public boolean isCompleted(DataType type) {
        return this.getBoolean("completion_" + type.nodeName());
    }

    public void setCompleted(DataType type) {
        this.set("completion_" + type.nodeName(), true);
    }

    public Long getDone(DataType type) {
        return this.getLong("done_" + type.nodeName());
    }

    public void incDone(DataType type) {
        Long current = this.getDone(type);
        current = current + 1L;
        this.set("done_" + type.nodeName(), current);
    }

    public void cleanup() {
        try {
            NodeIterator it = this.getContextNode().getNodes();
            while (it.hasNext()) {
                it.nextNode().remove();
                this.session.save();
            }
            this.getContextNode().remove();
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private Node getContextNode() {
        try {
            return this.session.getRootNode().getNode("migration_context");
        }
        catch (RepositoryException e) {
            try {
                return this.session.getRootNode().addNode("migration_context");
            }
            catch (RepositoryException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private boolean exists() {
        try {
            this.session.getRootNode().getNode("migration_context");
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private void set(String key, String value) {
        try {
            this.getContextNode().setProperty(key, value);
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private void set(String key, boolean value) {
        try {
            this.getContextNode().setProperty(key, value);
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private void set(String key, Long value) {
        try {
            this.getContextNode().setProperty(key, value.longValue());
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private String getString(String key) {
        try {
            return this.getContextNode().getProperty(key).getString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    private Boolean getBoolean(String key) {
        try {
            return this.getContextNode().getProperty(key).getBoolean();
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private Long getLong(String key) {
        try {
            return this.getContextNode().getProperty(key).getLong();
        }
        catch (RepositoryException e) {
            return 0L;
        }
    }

    public static enum DataType {
        IDENTITIES,
        SPACES,
        PROFILES,
        RELATIONSHIPS,
        ACTIVITIES;


        public String nodeName() {
            return this.toString().toLowerCase();
        }
    }
}

