/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UIUserActivityStreamPortlet.gtmpl")
public class UIUserActivityStreamPortlet
extends UIPortletApplication {
    private String ownerName;
    private String viewerName = Utils.getViewerRemoteId();
    private UIComposer uiComposer;
    private boolean composerDisplayed = false;
    UIUserActivitiesDisplay uiUserActivitiesDisplay;
    private String activityId;
    private static final String SINGLE_ACTIVITY_NODE = "activity";
    private static final String SINGLE_ACTIVITY_REDIRECT_LINK_PREFIX = "activity/redirect";
    private static final String NOTIFICATION_REST_PREFIX = "/social/notifications/redirectUrl";
    private static final Log LOG = ExoLogger.getLogger((String)UIUserActivityStreamPortlet.class.getName());

    public UIUserActivityStreamPortlet() throws Exception {
        this.ownerName = Utils.getOwnerRemoteId();
        this.uiComposer = (UIComposer)this.addChild(UIComposer.class, null, null);
        this.activityId = Utils.getActivityID();
        if (this.activityId != null) {
            this.uiComposer.setPostContext(UIComposer.PostContext.SINGLE);
            this.uiComposer.setRendered(false);
            this.composerDisplayed = false;
        } else {
            this.uiComposer.setPostContext(UIComposer.PostContext.USER);
            this.composerDisplayed = true;
        }
        this.uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.addChild(UIUserActivitiesDisplay.class, null, "UIUserActivitiesDisplay");
        this.uiComposer.setActivityDisplay((UIContainer)this.uiUserActivitiesDisplay);
        this.addChild(PopupContainer.class, null, "HiddenContainer");
    }

    public boolean isComposerDisplayed() {
        if (Utils.getActivityID() != null) {
            return false;
        }
        return this.composerDisplayed;
    }

    public String getActivityId() {
        this.activityId = Utils.getActivityID();
        return this.activityId;
    }

    private boolean hasPermissionToViewActivity(ExoSocialActivity activity) {
        Space space = Utils.getSpaceService().getSpaceByPrettyName(activity.getStreamOwner());
        if (space == null) {
            return true;
        }
        return space != null && Utils.getSpaceService().isMember(space, Utils.getViewerRemoteId());
    }

    public void refresh() throws Exception {
        this.redirectActivity();
        this.viewerName = Utils.getViewerRemoteId();
        this.ownerName = Utils.getOwnerRemoteId();
        if (this.viewerName.equals(this.ownerName)) {
            this.uiComposer.isActivityStreamOwner(true);
            this.uiComposer.setRendered(true);
        } else {
            this.uiComposer.isActivityStreamOwner(false);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getViewerIdentity(), Utils.getOwnerIdentity());
            if (relationship != null && relationship.getStatus() == Relationship.Type.CONFIRMED) {
                this.uiComposer.setRendered(true);
            } else {
                this.uiComposer.setRendered(false);
            }
        }
        this.uiUserActivitiesDisplay.setOwnerName(this.ownerName);
    }

    public final boolean isTitleDisplayed() {
        String activities = "/activities";
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest request = portalRequestContext.getRequest();
        String str = request.getRequestURL().toString();
        return str.contains("/activities");
    }

    public boolean isSingleActivity() {
        return SINGLE_ACTIVITY_NODE.equals(Utils.getSelectedNode());
    }

    public void redirectActivity() throws Exception {
        String path = Utils.getSelectedNode();
        if (path.contains(SINGLE_ACTIVITY_REDIRECT_LINK_PREFIX)) {
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            HttpServletResponse response = portalRequestContext.getResponse();
            ExoContainerContext context = (ExoContainerContext)CommonsUtils.getService(ExoContainerContext.class);
            String link = new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(context.getRestContextName()).append(NOTIFICATION_REST_PREFIX).append(path.replace(SINGLE_ACTIVITY_REDIRECT_LINK_PREFIX, "")).toString();
            response.sendRedirect(link);
        }
    }

    public String getSingleActivityTitle() {
        ExoSocialActivity activity;
        String gotId = Utils.getValueFromRequestParam((String)"id");
        if (gotId == null) {
            gotId = Utils.getValueFromRefererURI((String)"id");
            LOG.debug((Object)("got id from referer uri::activityId = " + gotId));
        }
        LOG.debug((Object)("got id from parameter::activityId = " + gotId));
        if (gotId != null && (activity = Utils.getActivityManager().getActivity(gotId)) != null && this.hasPermissionToViewActivity(activity)) {
            LOG.debug((Object)("got the activity = " + activity.toString()));
            return activity.getTitle();
        }
        LOG.debug((Object)"Activity title is NULL");
        return null;
    }
}

