/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.form;

import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.user.form.UIMultiValueSelection;
import org.exoplatform.social.user.portlet.UserProfileHelper;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;
import org.exoplatform.webui.form.validator.Validator;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={AddValueActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveValueActionListener.class}, phase=Event.Phase.DECODE)})
public class UIMultiValueSelection
extends UIFormInputSet {
    private static final Log LOG = ExoLogger.getExoLogger(UIMultiValueSelection.class);
    protected List<Validator> validators;
    public static final String FIELD_SELECT_KEY = "selectKey_";
    public static final String FIELD_INPUT_KEY = "inputKey_";
    private List<Map<String, String>> values;
    private List<Integer> indexs = new LinkedList();
    private List<String> optionValues = new ArrayList();

    public UIMultiValueSelection() {
    }

    public UIMultiValueSelection(String name) {
        super(name);
    }

    public UIMultiValueSelection(String name, String uiFormId, List<String> options) {
        super(name);
        this.setComponentConfig(this.getClass(), null);
        this.optionValues = options;
    }

    public <E extends Validator> UIMultiValueSelection addValidator(Class<E> clazz, Object ... params) throws Exception {
        if (this.validators == null) {
            this.validators = new ArrayList(3);
        }
        if (params.length > 0) {
            Class[] classes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classes[i] = params[i].getClass();
            }
            Constructor<E> constructor = clazz.getConstructor(classes);
            this.validators.add(constructor.newInstance(params));
            return this;
        }
        this.validators.add(clazz.newInstance());
        return this;
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    private List<SelectItemOption<String>> getOptions() {
        String uiFormId = ((UIForm)this.getAncestorOfType(UIForm.class)).getId();
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        if (this.optionValues != null) {
            for (String option : this.optionValues) {
                options.add((SelectItemOption<String>)new SelectItemOption(UserProfileHelper.getLabel(null, (String)(uiFormId + ".label." + option)), (Object)option));
            }
        }
        return options;
    }

    private String getSelected(String key) {
        if (this.optionValues == null) {
            this.optionValues = new ArrayList();
        }
        if (this.optionValues.contains(key)) {
            return key;
        }
        this.optionValues.add(key);
        return "";
    }

    public UIMultiValueSelection setValues(List<Map<String, String>> values) {
        this.values = values;
        try {
            this.removeChildren();
            int index = 0;
            if (values != null && !values.isEmpty()) {
                for (Map<String, String> map : values) {
                    String key = map.get("key");
                    String value = UserProfileHelper.decodeHTML((String)map.get("value"));
                    this.addInput(index, this.getSelected(key), value);
                    ++index;
                }
            } else {
                this.addInput(index, "", "");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to set values for " + this.getId()), (Throwable)e);
        }
        return this;
    }

    private String getInputValue(int indexId) {
        return (String)this.getUIStringInput(this.getInputId(indexId)).getValue();
    }

    private String getInputKey(int indexId) {
        return (String)this.getUIFormSelectBox(this.getSelectId(indexId)).getValue();
    }

    public List<Map<String, String>> getValues() {
        this.values = new ArrayList();
        for (Integer indexId : this.indexs) {
            String value = this.getInputValue(indexId.intValue());
            if (UserProfileHelper.isEmpty((String)value)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", this.getInputKey(indexId.intValue()));
            map.put("value", UserProfileHelper.encodeHTML((String)value));
            this.values.add(map);
        }
        return this.values;
    }

    private String getSelectId(int index) {
        return FIELD_SELECT_KEY + this.getId() + index;
    }

    private String getInputId(int index) {
        return FIELD_INPUT_KEY + this.getId() + index;
    }

    private void addInput(int indexId, String selected, String value) throws Exception {
        int index = indexId;
        if (this.indexs.contains(indexId)) {
            index = this.indexs.indexOf(indexId) + 1;
            indexId = index * 10;
        }
        ((LinkedList)this.indexs).add(index, indexId);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(this.getSelectId(indexId), this.getSelectId(indexId), this.getOptions()).setValue(selected));
        UIFormStringInput stringInput = new UIFormStringInput(this.getInputId(indexId), this.getInputId(indexId), value);
        stringInput.setHTMLAttribute("class", "selectInput");
        if (this.validators != null && !this.validators.isEmpty()) {
            stringInput.addValidator(SpecialCharacterValidator.class, new Object[0]);
            List validators_ = stringInput.getValidators();
            validators_.clear();
            validators_.addAll(this.validators);
        }
        stringInput.setLabel(this.getId());
        this.addUIFormInput((UIFormInput)stringInput);
    }

    private void removeChildren() {
        this.getChildren().clear();
        this.indexs.clear();
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String indexId = context.getRequestParameter("objectId");
        if (indexId == null || !indexId.contains(this.getId())) {
            return;
        }
        String action = uiForm.getSubmitAction();
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event == null) {
            return;
        }
        event.broadcast();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.indexs.isEmpty()) {
            this.setValues(null);
        }
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String addItem = UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIFormMultiValueInputSet.label.add");
        String removeItem = UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIFormMultiValueInputSet.label.remove");
        context.getJavascriptManager().require("SHARED/jquery", "jq").require("SHARED/bts_tooltip").addScripts("jq('.uiMulti-select').find('a[rel=\"tooltip\"]').tooltip();");
        Writer w = context.getWriter();
        w.append("<div class=\"uiMulti-select\" id=\"").append(this.getId()).append("\">");
        int i = 0;
        for (Integer indexId : this.indexs) {
            w.append("<div class=\"controls-row\">");
            this.renderUIComponent((UIComponent)this.getUIFormSelectBox(this.getSelectId(indexId.intValue())));
            this.renderUIComponent((UIComponent)this.getUIStringInput(this.getInputId(indexId.intValue())));
            if (this.indexs.size() > 1) {
                w.append("<a class=\"actionIcon\" data-placement=\"bottom\" rel=\"tooltip\" title=\"\" data-original-title=\"").append(removeItem).append("\" href=\"javascript:void(0)\" onclick=\"").append(uiForm.event("RemoveValue", this.getId() + String.valueOf(indexId))).append("\"><i class=\"uiIconClose uiIconLightGray\"></i></a>");
            }
            if (i == this.indexs.size() - 1) {
                w.append("<a class=\"actionIcon\" data-placement=\"bottom\" rel=\"tooltip\" title=\"\" data-original-title=\"").append(addItem).append("\" href=\"javascript:void(0)\" onclick=\"").append(uiForm.event("AddValue", this.getId() + String.valueOf(indexId))).append("\"><i class=\"uiIconPlus uiIconLightGray\"></i></a>");
            }
            w.append("</div>");
            ++i;
        }
        if (this.isMandatory()) {
            w.write(" *");
        }
        w.write("</div>");
    }

    private boolean isMandatory() {
        return false;
    }

    static /* synthetic */ void access$000(UIMultiValueSelection x0, int x1, String x2, String x3) throws Exception {
        x0.addInput(x1, x2, x3);
    }

    static /* synthetic */ List access$100(UIMultiValueSelection x0) {
        return x0.indexs;
    }

    static /* synthetic */ String access$200(UIMultiValueSelection x0, int x1) {
        return x0.getSelectId(x1);
    }

    static /* synthetic */ String access$300(UIMultiValueSelection x0, int x1) {
        return x0.getInputId(x1);
    }
}

