/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.form;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.settings.IMType;
import org.exoplatform.social.core.profile.settings.UserProfileSettingsService;
import org.exoplatform.social.user.form.UIChangeAvatarContainer;
import org.exoplatform.social.user.form.UIEditUserProfileForm;
import org.exoplatform.social.user.form.UIInputSection;
import org.exoplatform.social.user.form.UIMultiValueSelection;
import org.exoplatform.social.user.portlet.UserProfileHelper;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.settings.UserProfileRenderingService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormHiddenInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PersonalNameValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.utils.TimeConvertUtils;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/social/portlet/user/UIEditUserProfileForm.gtmpl", events={@EventConfig(listeners={AddExperienceActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveExperienceActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}, csrfCheck=true)})
public class UIEditUserProfileForm
extends UIForm {
    public static final String PLACEHOLDER_KEY = "placeholder";
    public static final String FIELD_ABOUT_SECTION = "AboutSection";
    public static final String FIELD_BASE_SECTION = "BaseSection";
    public static final String FIELD_EXPERIENCE_SECTION = "ExperienceSection";
    public static final String OPTION_MALE = "Male";
    public static final String OPTION_FEMALE = "Female";
    public static final String FIELD_EMPTY_EXPERIENCE_SECTION = "emprySelection";
    public static final String FIELD_INFO_EMPTY_EXPERIENCE = "infoExperien";
    public static final String DATE_FORMAT_MMDDYYYY = "MM/dd/yyyy";
    public static final String[] PHONE_TYPES = new String[]{"work", "home", "other"};
    public static final String PHONE_REGEX_EXPRESSION = "^[\\d\\s ().+-]{3,25}+$";
    public static final String URL_REGEX_EXPRESSION = "^(?i)(((?:(?:ht)tp(?:s?)\\:\\/\\/)?(?:\\w+:\\w+@)?(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))|(?:(?:[-\\p{L}\\p{Digit}\\+\\$\\-\\*\\=]+\\.)+(?:[a-z]{2,}))))|(?:(?:(?:ht)tp(?:s?)\\:\\/\\/)(?:\\w+:\\w+@)?(?:[-\\p{L}\\p{Digit}\\+\\$\\-\\*\\=]+)))(?::[\\d]{1,5})?(?:[\\/|\\?|\\#].*)?$";
    private Profile currentProfile;
    private List<String> experiens = new LinkedList();
    private int index = 0;

    public UIEditUserProfileForm() throws Exception {
        if (this.getId() == null) {
            this.setId("UIEditUserProfileForm");
        }
        UIInputSection aboutSection = new UIInputSection(FIELD_ABOUT_SECTION, "aboutMe");
        aboutSection.useGroupControl(false).addUIFormInput((UIFormInput)new UIFormTextAreaInput("aboutMe", "aboutMe", "").addValidator(StringLengthValidator.class, new Object[]{1500}));
        UIInputSection baseSection = new UIInputSection(FIELD_BASE_SECTION, "ContactInfomation");
        baseSection.addUIFormInput((UIFormInput)this.createUIFormStringInput("firstName", true).addValidator(PersonalNameValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 45}));
        baseSection.addUIFormInput((UIFormInput)this.createUIFormStringInput("lastName", true).addValidator(PersonalNameValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 45}));
        baseSection.addUIFormInput((UIFormInput)this.createUIFormStringInput("email", true).addValidator(EmailAddressValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{5, 100}));
        UIChangeAvatarContainer avatarContainer = (UIChangeAvatarContainer)this.createUIComponent(UIChangeAvatarContainer.class, null, "Avatar");
        baseSection.addUIFormInput((UIFormInputSet)avatarContainer);
        baseSection.addUIFormInput((UIFormInput)this.createUIFormStringInput("position", false).addValidator(StringLengthValidator.class, new Object[]{100}));
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption("", (Object)""));
        options.add(new SelectItemOption(this.getLabel(OPTION_MALE), (Object)"male"));
        options.add(new SelectItemOption(this.getLabel(OPTION_FEMALE), (Object)"female"));
        UIFormSelectBox genderSelectBox = new UIFormSelectBox("gender", "gender", options);
        genderSelectBox.setLabel("gender");
        baseSection.addUIFormInput((UIFormInput)genderSelectBox);
        UIMultiValueSelection phoneSelection = new UIMultiValueSelection("phones", this.getId(), Arrays.asList(PHONE_TYPES));
        baseSection.addUIFormInput((UIFormInputSet)phoneSelection.addValidator(ExpressionValidator.class, new Object[]{PHONE_REGEX_EXPRESSION, "UIEditUserProfileForm.msg.Invalid-phone"}));
        UserProfileSettingsService profileSettings = (UserProfileSettingsService)CommonsUtils.getService(UserProfileSettingsService.class);
        Collection imTypes = profileSettings.getIMTypes();
        ArrayList<String> imTypesValues = new ArrayList<String>(imTypes.size());
        for (IMType imt : imTypes) {
            imTypesValues.add(imt.getId());
        }
        UIMultiValueSelection imsSelection = new UIMultiValueSelection("ims", this.getId(), imTypesValues);
        UserProfileRenderingService settingsRenderers = (UserProfileRenderingService)CommonsUtils.getService(UserProfileRenderingService.class);
        imsSelection.withValueControl(settingsRenderers.getIMControl());
        baseSection.addUIFormInput((UIFormInputSet)imsSelection.addValidator(StringLengthValidator.class, new Object[]{100}));
        UIFormMultiValueInputSet urlMultiValueInput = new UIFormMultiValueInputSet("urls", "urls");
        urlMultiValueInput.addValidator(ExpressionValidator.class, new Object[]{URL_REGEX_EXPRESSION, "UIEditUserProfileForm.msg.Invalid-url"});
        urlMultiValueInput.addValidator(StringLengthValidator.class, new Object[]{5, 100});
        urlMultiValueInput.setType(UIFormStringInput.class);
        urlMultiValueInput.setValue(Arrays.asList(""));
        urlMultiValueInput.setLabel("urls");
        baseSection.addUIFormInput((UIFormInput)urlMultiValueInput);
        this.addUIFormInput((UIFormInputSet)aboutSection);
        this.addUIFormInput((UIFormInputSet)baseSection);
    }

    private List<UIInputSection.ActionData> createExperienceActions(String experienId, boolean hasAdd) {
        ArrayList<UIInputSection.ActionData> actions = new ArrayList<UIInputSection.ActionData>();
        UIInputSection.ActionData removeAction = new UIInputSection.ActionData();
        removeAction.setAction("RemoveExperience").setIcon("uiIconClose").setTooltip(UserProfileHelper.getLabel(null, (String)"UIEditUserProfileForm.title.RemoveExperience")).setObjectId(experienId);
        actions.add(removeAction);
        if (hasAdd) {
            UIInputSection.ActionData addAction = new UIInputSection.ActionData();
            addAction.setAction("AddExperience").setIcon("uiIconPlus").setTooltip(UserProfileHelper.getLabel(null, (String)"UIEditUserProfileForm.title.AddExperience")).setObjectId(experienId);
            actions.add(addAction);
        }
        return actions;
    }

    private UIInputSection getOrCreateExperienceSection(String id) throws Exception {
        UIInputSection experienceSection = (UIInputSection)this.getChildById(id);
        if (experienceSection != null) {
            return experienceSection;
        }
        String label = this.experiens.size() == 0 ? "Experience" : "";
        experienceSection = new UIInputSection(id, label, "uiExperien");
        UIFormStringInput company = this.createUIFormStringInput("company" + id, true);
        company.addValidator(StringLengthValidator.class, new Object[]{100});
        company.setLabel("company");
        experienceSection.addUIFormInput((UIFormInput)company);
        experienceSection.addUIFormInput((UIFormInput)new UIFormHiddenInput("id" + id, ""));
        experienceSection.addUIFormInput(this.createUIFormStringInput("position" + id, true).addValidator(StringLengthValidator.class, new Object[]{100}), "position");
        experienceSection.addUIFormInput(new UIFormTextAreaInput("description" + id, "description" + id, "").addValidator(StringLengthValidator.class, new Object[]{1500}), "description");
        experienceSection.addUIFormInput(new UIFormTextAreaInput("skills" + id, "skills" + id, "").addValidator(StringLengthValidator.class, new Object[]{1500}), "skills");
        experienceSection.addUIFormInput((UIFormInputBase)new UIFormDateTimeInput("startDate" + id, "startDate" + id, null, false), "startDate");
        experienceSection.addUIFormInput((UIFormInputBase)new UIFormDateTimeInput("endDate" + id, "endDate" + id, null, false), "endDate");
        experienceSection.addUIFormInput((UIFormInputBase)new UICheckBoxInput("isCurrent" + id, "isCurrent" + id, Boolean.valueOf(false)), "CurrentPosition");
        this.addUIFormInput((UIFormInputSet)experienceSection);
        ++this.index;
        this.experiens.add(id);
        return experienceSection;
    }

    protected UIInputSection setValueExperienceSection(String id, Map<String, String> experience) throws Exception {
        UIInputSection experienceSection = this.getOrCreateExperienceSection(id);
        experienceSection.getUIInput("id" + id).setValue((Object)experience.get("id"));
        experienceSection.getUIStringInput("company" + id).setValue((Object)this.getValueExperience(experience, "company"));
        experienceSection.getUIStringInput("position" + id).setValue((Object)this.getValueExperience(experience, "position"));
        experienceSection.getUIFormTextAreaInput("description" + id).setValue((Object)this.getValueExperience(experience, "description"));
        experienceSection.getUIFormTextAreaInput("skills" + id).setValue((Object)this.getValueExperience(experience, "skills"));
        experienceSection.getUIFormDateTimeInput("startDate" + id).setCalendar(this.stringToCalendar(experience.get("startDate")));
        experienceSection.getUIFormDateTimeInput("endDate" + id).setCalendar(this.stringToCalendar(experience.get("endDate")));
        experienceSection.getUICheckBoxInput("isCurrent" + id).setChecked(Boolean.valueOf(experience.get("isCurrent")).booleanValue());
        return experienceSection;
    }

    private String getValueExperience(Map<String, String> experience, String key) {
        return UserProfileHelper.decodeHTML((String)experience.get(key));
    }

    private String getStringValueProfile(String key) {
        return UserProfileHelper.decodeHTML((String)((String)this.currentProfile.getProperty(key)));
    }

    protected void setValueBasicInfo() throws Exception {
        this.getUIInputSection(FIELD_ABOUT_SECTION).getUIFormTextAreaInput("aboutMe").setValue((Object)this.getStringValueProfile("aboutMe"));
        UIInputSection baseSection = this.getUIInputSection(FIELD_BASE_SECTION);
        baseSection.getUIStringInput("firstName").setValue((Object)this.getStringValueProfile("firstName"));
        baseSection.getUIStringInput("lastName").setValue((Object)this.getStringValueProfile("lastName"));
        baseSection.getUIStringInput("email").setValue((Object)this.getStringValueProfile("email"));
        baseSection.getUIStringInput("position").setValue((Object)this.getStringValueProfile("position"));
        baseSection.getUIFormSelectBox("gender").setValue(this.getStringValueProfile("gender"));
        if (this.getStringValueProfile("gender") != null) {
            baseSection.getUIFormSelectBox("gender").setSelectedValues(new String[]{this.getStringValueProfile("gender")});
        }
        List phones = UserProfileHelper.getMultiValues((Profile)this.currentProfile, (String)"phones");
        baseSection.getUIMultiValueSelection("phones").setValues(phones);
        List ims = UserProfileHelper.getMultiValues((Profile)this.currentProfile, (String)"ims");
        baseSection.getUIMultiValueSelection("ims").setValues(ims);
        baseSection.getUIFormMultiValueInputSet("urls").setValue(UserProfileHelper.getURLValues((Profile)this.currentProfile));
        List experiences = UserProfileHelper.getDisplayExperience((Profile)this.currentProfile);
        if (!experiences.isEmpty()) {
            int i = 0;
            this.removeChildById(FIELD_EMPTY_EXPERIENCE_SECTION);
            int experienCurrentSize = this.experiens.size();
            for (Map experience : experiences) {
                String experienId;
                if (i < experienCurrentSize) {
                    experienId = (String)this.experiens.get(i);
                    ++i;
                } else {
                    experienId = FIELD_EXPERIENCE_SECTION + this.index;
                }
                this.setValueExperienceSection(experienId, experience);
            }
            this.resetActionFileds();
        } else if (this.experiens.isEmpty()) {
            this.addEmpryExperienceSection();
        }
    }

    private void addEmpryExperienceSection() throws Exception {
        UIInputSection emprySelection = (UIInputSection)this.getChildById(FIELD_EMPTY_EXPERIENCE_SECTION);
        if (emprySelection == null) {
            emprySelection = new UIInputSection(FIELD_EMPTY_EXPERIENCE_SECTION, "Experience", "uiExperien").useGroupControl(false);
            UIInputSection.ActionData addAction = new UIInputSection.ActionData();
            addAction.setAction("AddExperience").setIcon("uiIconPlus").setTooltip(UserProfileHelper.getLabel(null, (String)"UIEditUserProfileForm.title.AddExperience")).setObjectId("ExperienceSectionempty");
            emprySelection.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_INFO_EMPTY_EXPERIENCE, FIELD_INFO_EMPTY_EXPERIENCE, this.getLabel("AddExperience")), Arrays.asList(addAction));
            this.addUIFormInput((UIFormInputSet)emprySelection);
        }
    }

    protected Calendar stringToCalendar(String sDate) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY, Locale.ENGLISH);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(sd.parse(sDate));
            return calendar;
        }
        catch (Exception e) {
            return null;
        }
    }

    private UIFormStringInput createUIFormStringInput(String name, boolean isMandatory) throws Exception {
        UIFormStringInput firstName = new UIFormStringInput(name, name, "");
        if (isMandatory) {
            firstName.addValidator(MandatoryValidator.class, new Object[0]);
        }
        firstName.setLabel(name);
        return firstName;
    }

    private void initPlaceholder() throws Exception {
        this.getUIInputSection(FIELD_ABOUT_SECTION).getUIFormTextAreaInput("aboutMe").setHTMLAttribute(PLACEHOLDER_KEY, this.getLabel("aboutMePlaceholder"));
        UIInputSection baseSection = this.getUIInputSection(FIELD_BASE_SECTION);
        UIFormMultiValueInputSet urlMulti = (UIFormMultiValueInputSet)baseSection.getChildById("urls");
        List children = urlMulti.getChildren();
        for (UIComponent uiComponent : children) {
            if (!(uiComponent instanceof UIFormInputBase)) continue;
            ((UIFormInputBase)uiComponent).setHTMLAttribute(PLACEHOLDER_KEY, this.getLabel("sampleUrl"));
        }
        List experienceSections = this.getExperienceSections();
        for (UIInputSection uiInputSection : experienceSections) {
            ArrayList dateInputs = new ArrayList();
            uiInputSection.findComponentOfType(dateInputs, UIFormDateTimeInput.class);
            for (UIFormDateTimeInput uiFormDateTimeInput : dateInputs) {
                uiFormDateTimeInput.setHTMLAttribute(PLACEHOLDER_KEY, DATE_FORMAT_MMDDYYYY);
            }
        }
    }

    private List<UIInputSection> getExperienceSections() {
        ArrayList<UIInputSection> experienceSections = new ArrayList<UIInputSection>();
        List children = this.getChildren();
        for (UIComponent uiComponent : children) {
            if (!uiComponent.getId().startsWith(FIELD_EXPERIENCE_SECTION)) continue;
            experienceSections.add((UIInputSection)uiComponent);
        }
        return experienceSections;
    }

    private void clearExperiences() {
        for (String string : this.experiens) {
            this.removeChildById(string);
        }
        this.experiens.clear();
        this.index = 0;
    }

    private UIInputSection getUIInputSection(String id) {
        return (UIInputSection)this.getChildById(id);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (!Util.getPortalRequestContext().useAjax()) {
            this.resetForm();
            this.initPlaceholder();
        }
        if (this.currentProfile == null) {
            this.currentProfile = Utils.getViewerIdentity((boolean)true).getProfile();
            this.setValueBasicInfo();
        }
        super.processRender(context);
    }

    private void resetActionFileds() {
        List experienceSections = this.getExperienceSections();
        int i = 1;
        int experienceSize = experienceSections.size();
        for (UIInputSection uiInputSection : experienceSections) {
            boolean hasAdd = i == experienceSize;
            String experienId = uiInputSection.getName();
            uiInputSection.setActionField("company" + experienId, this.createExperienceActions(uiInputSection.getName(), hasAdd));
            ++i;
        }
    }

    private void resetForm() {
        this.currentProfile = null;
        this.clearExperiences();
    }

    private void warning(String messageKey, String ... args) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        context.getUIApplication().addMessage(new ApplicationMessage(messageKey, (Object[])args, 1));
        ((PortalRequestContext)context.getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
    }

    private void putData(Map<String, String> map, String key, String value) {
        map.put(key, UserProfileHelper.encodeHTML((String)value));
    }

    private Map<String, String> getValueExperience(UIInputSection experienceSection) throws Exception {
        String id = experienceSection.getId();
        HashMap<String, String> map = new HashMap<String, String>();
        this.putData(map, "id", (String)experienceSection.getUIInput("id" + id).getValue());
        this.putData(map, "company", (String)experienceSection.getUIStringInput("company" + id).getValue());
        this.putData(map, "position", (String)experienceSection.getUIStringInput("position" + id).getValue());
        this.putData(map, "description", (String)experienceSection.getUIFormTextAreaInput("description" + id).getValue());
        this.putData(map, "skills", (String)experienceSection.getUIFormTextAreaInput("skills" + id).getValue());
        UIFormDateTimeInput startDate = experienceSection.getUIFormDateTimeInput("startDate" + id);
        UIFormDateTimeInput endDate = experienceSection.getUIFormDateTimeInput("endDate" + id);
        boolean isCurrent = experienceSection.getUICheckBoxInput("isCurrent" + id).isChecked();
        if (startDate.getValue() == null || ((String)startDate.getValue()).isEmpty()) {
            if (isCurrent || endDate.getValue() != null && !((String)endDate.getValue()).isEmpty()) {
                this.warning("EmptyFieldValidator.msg.empty-input", new String[]{this.getLabel("startDate")});
                return null;
            }
        } else {
            if (startDate.getCalendar() == null || ((String)startDate.getValue()).indexOf("-") >= 0) {
                this.warning("UIEditUserProfileForm.msg.Invalid-format-date", new String[]{this.getLabel("startDate"), DATE_FORMAT_MMDDYYYY});
                return null;
            }
            this.putData(map, "startDate", TimeConvertUtils.getFormatDate((Date)startDate.getCalendar().getTime(), (String)DATE_FORMAT_MMDDYYYY, (Locale)Locale.ENGLISH));
            if (startDate.getCalendar().after(Calendar.getInstance())) {
                this.warning("UIEditUserProfileForm.msg.TheDateBeforeToday", new String[]{this.getLabel("startDate")});
                return null;
            }
            if (!isCurrent) {
                if (endDate.getValue() == null || ((String)endDate.getValue()).isEmpty()) {
                    this.warning("EmptyFieldValidator.msg.empty-input", new String[]{this.getLabel("endDate")});
                    return null;
                }
                if (endDate.getCalendar() == null || ((String)endDate.getValue()).indexOf("-") >= 0) {
                    this.warning("UIEditUserProfileForm.msg.Invalid-format-date", new String[]{this.getLabel("endDate"), DATE_FORMAT_MMDDYYYY});
                    return null;
                }
                if (endDate.getCalendar().after(Calendar.getInstance())) {
                    this.warning("UIEditUserProfileForm.msg.TheDateBeforeToday", new String[]{this.getLabel("endDate")});
                    return null;
                }
                if (endDate.getCalendar().before(startDate.getCalendar())) {
                    this.warning("UIEditUserProfileForm.msg.FromDateBeforeToDate", new String[]{this.getLabel("startDate"), this.getLabel("endDate")});
                    return null;
                }
                this.putData(map, "endDate", TimeConvertUtils.getFormatDate((Date)endDate.getCalendar().getTime(), (String)DATE_FORMAT_MMDDYYYY, (Locale)Locale.ENGLISH));
                map.put("isCurrent", "false");
            } else {
                map.put("isCurrent", "true");
                map.put("endDate", null);
            }
        }
        return map;
    }

    protected String getViewProfileURL() {
        return this.currentProfile.getUrl();
    }

    private void initAboutMeTextArea(WebuiRequestContext context) throws Exception {
        String aboutMe = (String)this.getUIInputSection(FIELD_ABOUT_SECTION).getUIFormTextAreaInput("aboutMe").getValue();
        if (aboutMe == null || this.getLabel("aboutMePlaceholder").equals(aboutMe) || aboutMe.length() == 0) {
            String scripts = "(function(jq){jq(\"textarea#" + "aboutMe" + "\").val('')" + ".attr(\"placeholder\", \"" + this.getLabel("aboutMePlaceholder") + "\");})(jq);";
            context.getJavascriptManager().getRequireJS().require("SHARED/jquery", "jq").addScripts(scripts);
        }
    }

    static /* synthetic */ Profile access$000(UIEditUserProfileForm x0) {
        return x0.currentProfile;
    }

    static /* synthetic */ UIInputSection access$100(UIEditUserProfileForm x0, String x1) {
        return x0.getUIInputSection(x1);
    }

    static /* synthetic */ void access$200(UIEditUserProfileForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ List access$300(UIEditUserProfileForm x0) {
        return x0.getExperienceSections();
    }

    static /* synthetic */ Map access$400(UIEditUserProfileForm x0, UIInputSection x1) throws Exception {
        return x0.getValueExperience(x1);
    }

    static /* synthetic */ void access$500(UIEditUserProfileForm x0) {
        x0.resetForm();
    }

    static /* synthetic */ int access$600(UIEditUserProfileForm x0) {
        return x0.index;
    }

    static /* synthetic */ UIInputSection access$700(UIEditUserProfileForm x0, String x1) throws Exception {
        return x0.getOrCreateExperienceSection(x1);
    }

    static /* synthetic */ void access$800(UIEditUserProfileForm x0) {
        x0.resetActionFileds();
    }

    static /* synthetic */ void access$900(UIEditUserProfileForm x0, WebuiRequestContext x1) throws Exception {
        x0.initAboutMeTextArea(x1);
    }

    static /* synthetic */ List access$1000(UIEditUserProfileForm x0) {
        return x0.experiens;
    }

    static /* synthetic */ void access$1100(UIEditUserProfileForm x0) throws Exception {
        x0.addEmpryExperienceSection();
    }
}

