/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.user.portlet.UIAbstractUserPortlet;
import org.exoplatform.social.user.portlet.UserProfileHelper;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.utils.TimeConvertUtils;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/user/UIExperienceProfilePortlet.gtmpl")
public class UIExperienceProfilePortlet
extends UIAbstractUserPortlet {
    private static final String DATE_FORMAT_MMDDYYYY = "MM/dd/yyyy";
    private static final String DATE_FORMAT_MMMMDDYYYY = "MMMM dd, yyyy";

    protected String getAboutMe() {
        String about = (String)this.currentProfile.getProperty("aboutMe");
        return UserProfileHelper.isEmpty((String)about) ? "" : about;
    }

    protected List<Map<String, String>> getExperience() throws Exception {
        List experiences = UserProfileHelper.getDisplayExperience((Profile)this.currentProfile);
        for (Map experience : experiences) {
            String endDate;
            String strartDate = (String)experience.get("startDate");
            if (!UserProfileHelper.isEmpty((String)strartDate)) {
                experience.put("startDate", this.convertDate(strartDate));
            }
            if (UserProfileHelper.isEmpty((String)(endDate = (String)experience.get("endDate")))) continue;
            experience.put("endDate", this.convertDate(endDate));
        }
        return experiences;
    }

    private String convertDate(String sDate) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY, Locale.ENGLISH);
            return TimeConvertUtils.getFormatDate((Date)sd.parse(sDate), (String)DATE_FORMAT_MMMMDDYYYY);
        }
        catch (Exception e) {
            return sDate;
        }
    }
}

