/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.portlet.UISpaceNavigationPortlet;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UISpaceNavigationPortlet.gtmpl", events={@EventConfig(listeners={IncrementActionListener.class})})
public class UISpaceNavigationPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UISpaceNavigationPortlet.class);
    private static final String MY_SPACE_REST_URL = "/space/user/searchSpace/";
    private SpaceService spaceService = null;
    private ListAccess<Space> spaceListAccess;
    private LinkedList<Space> spaceList = new LinkedList();
    private static final int MY_SPACES_MAX_NUMBER = 10;
    private int offset = 0;
    private boolean reload = false;
    private String oldNavigation = null;
    private String currentNavigation = null;
    private String selectedSpaceId = null;
    private String userId = null;

    public UISpaceNavigationPortlet() throws Exception {
        try {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            if (this.spaceService != null) {
                this.spaceListAccess = this.spaceService.getLastAccessedSpace(this.getUserId(), null);
                this.setReload(true);
            }
            this.setOldNavigation(Util.getPortalRequestContext().getRequest().getRequestURI());
        }
        catch (Exception exception) {
            LOG.error((Object)"SpaceService could be 'null' when the Social profile isn't activated ", (Throwable)exception);
        }
    }

    public List<Space> getSpaces() {
        Space space = Utils.getSpaceByContext();
        if (space != null) {
            this.putTop(space);
        }
        if (this.selectedSpaceId != null) {
            this.setSelectedSpaceId(null);
        }
        int from = 0;
        int to = this.offset + 10;
        if (to >= this.spaceList.size()) {
            return this.spaceList;
        }
        return this.spaceList.subList(from, to);
    }

    public void refresh() throws Exception {
        this.setCurrentNavigation(Util.getPortalRequestContext().getRequest().getRequestURI());
        boolean navChanged = this.getCurrentNavigation().equals(this.getOldNavigation());
        if (this.reload && this.selectedSpaceId == null || !navChanged) {
            this.spaceList.clear();
            this.offset = 0;
            this.loadSpaces();
        }
        this.setOldNavigation(this.getCurrentNavigation());
    }

    private void loadSpaces() throws Exception {
        if (this.spaceListAccess != null) {
            this.spaceList.addAll(Arrays.asList(this.spaceListAccess.load(this.offset, 10)));
        }
    }

    private Space putTop(Space space) {
        int idx = this.spaceList.indexOf(space);
        Space got = null;
        got = idx >= 0 ? (Space)this.spaceList.remove(idx) : Utils.getSpaceService().getSpaceById(space.getId());
        this.spaceList.addFirst(got);
        return got;
    }

    public int numberOfRemainSpaces() throws Exception {
        if (this.spaceListAccess != null) {
            int to = this.offset + 10;
            int newLimit = Math.min(to, this.spaceList.size());
            return this.spaceListAccess.getSize() - newLimit;
        }
        return 0;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public String buildSpaceURL(Space space) throws Exception {
        return Utils.getSpaceHomeURL((Space)space);
    }

    public Boolean isSelectedSpace(Space space) throws Exception {
        String groupId = Util.getPortalRequestContext().getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME);
        return space.getGroupId().equalsIgnoreCase(groupId);
    }

    protected String getRestUrl() {
        return UISpaceNavigationPortlet.getCurrentRestURL().concat("/space/user/searchSpace/");
    }

    public static String getCurrentRestURL() {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/");
        sb.append(PortalContainer.getCurrentRestContextName());
        return sb.toString();
    }

    public void loadMore(int capacity) throws Exception {
        this.offset += capacity;
        this.loadSpaces();
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public void setSelectedSpaceId(String selectedSpaceId) {
        this.selectedSpaceId = selectedSpaceId;
    }

    public String getCurrentNavigation() {
        return this.currentNavigation;
    }

    public void setCurrentNavigation(String currentNavigation) {
        this.currentNavigation = currentNavigation;
    }

    public String getOldNavigation() {
        return this.oldNavigation;
    }

    public void setOldNavigation(String oldNavigation) {
        this.oldNavigation = oldNavigation;
    }
}

