/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import java.util.ResourceBundle;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.user.portlet.UIAbstractUserPortlet;
import org.exoplatform.social.user.portlet.UIStatusProfilePortlet;
import org.exoplatform.social.user.portlet.UserProfileHelper;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="war:/groovy/social/portlet/user/UIStatusProfilePortlet.gtmpl")
public class UIStatusProfilePortlet
extends UIAbstractUserPortlet {
    public static final String OFFLINE_STATUS = "offline";
    public static final String OFFLINE_TITLE = "UIStatusProfile.title.offline";
    public static final String USER_STATUS_TITLE = "UIStatusProfile.title.";

    protected StatusInfo getStatusInfo() {
        StatusInfo si = new StatusInfo(this);
        ResourceBundle rb = PortalRequestContext.getCurrentInstance().getApplicationResourceBundle();
        UserStateService stateService = (UserStateService)this.getApplicationComponent(UserStateService.class);
        boolean isOnline = stateService.isOnline(this.currentProfile.getIdentity().getRemoteId());
        if (isOnline) {
            String status = stateService.getUserState(this.currentProfile.getIdentity().getRemoteId()).getStatus();
            si.setCssName(UserProfileHelper.StatusIconCss.getIconCss((String)status));
            si.setTitle(rb.getString(USER_STATUS_TITLE + status));
        } else {
            si.setCssName(UserProfileHelper.StatusIconCss.getIconCss((String)OFFLINE_STATUS));
            si.setTitle(rb.getString(OFFLINE_TITLE));
        }
        return si;
    }
}

