/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.NavigationURLUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.portlet.UIRelationshipAction;
import org.exoplatform.social.portlet.UIUserNavigationPortlet;
import org.exoplatform.social.webui.UIBannerAvatarUploader;
import org.exoplatform.social.webui.UIBannerUploader;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.exception.MessageException;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UIUserNavigationPortlet.gtmpl", events={@EventConfig(listeners={RemoveBannerActionListener.class})})
public class UIUserNavigationPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UIUserNavigationPortlet.class);
    public static final String ACTIVITIES_URI = "activities";
    public static final String PROFILE_URI = "profile";
    public static final String CONNEXIONS_URI = "connections";
    public static final String WIKI_URI = "wiki";
    public static final String WALLET_FEATURE_NAME = "wallet";
    public static final String WALLET_URI = "wallet";
    public static final String GAMIFICATION_FEATURE_NAME = "gamification";
    public static final String GAMIFICATION_URI = "achievements";
    private static final String INVISIBLE = "invisible";
    public static String DEFAULT_TAB_NAME = "Tab_Default";
    private static final String USER = "/user/";
    private static final String WIKI_HOME = "/WikiHome";
    private static final String WIKI_REF = "wiki";
    private static final String NOTIF_REF = "notifications";
    private static final String NOTIFICATION_SETTINGS = "NotificationSettingsPortlet";
    private static final String EDIT_PROFILE_NODE = "edit-profile";
    public static final String OFFLINE_STATUS = "offline";
    public static final String OFFLINE_TITLE = "UIUserNavigationPortlet.label.offline";
    public static final String USER_STATUS_TITLE = "UIUserNavigationPortlet.label.";
    private UserNodeFilterConfig toolbarFilterConfig;
    private UIBannerUploader uiBanner = null;
    private UIBannerAvatarUploader uiAvatarBanner = null;
    private Map<String, String> userNodes;

    public UIUserNavigationPortlet() throws Exception {
        UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
        builder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL}).withTemporalCheck();
        this.toolbarFilterConfig = builder.build();
        this.uiBanner = (UIBannerUploader)this.createUIComponent(UIBannerUploader.class, null, null);
        this.addChild((UIComponent)this.uiBanner);
        this.uiAvatarBanner = (UIBannerAvatarUploader)this.createUIComponent(UIBannerAvatarUploader.class, null, null);
        this.addChild((UIComponent)this.uiAvatarBanner);
        UIRelationshipAction uiAction = (UIRelationshipAction)this.createUIComponent(UIRelationshipAction.class, null, null);
        this.addChild((UIComponent)uiAction);
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        this.uiBanner.setRendered(this.isProfileOwner());
        this.uiAvatarBanner.setRenderUpload(this.isProfileOwner());
        super.processRender(app, context);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.uiBanner.setRendered(this.isProfileOwner());
        this.uiAvatarBanner.setRenderUpload(this.isProfileOwner());
        super.processRender(context);
    }

    public boolean isSelectedUserNavigation(String nav) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserNode selectedNode = uiPortal.getSelectedUserNode();
        if (selectedNode.getURI().contains(nav)) {
            return true;
        }
        if ("NotificationSettingsPortlet".equals(nav) && "notifications".equals(selectedNode.getURI())) {
            return true;
        }
        String requestUrl = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
        return requestUrl.contains("/u/");
    }

    public boolean isProfileOwner() {
        return Utils.isOwner();
    }

    public Profile getOwnerProfile() {
        return Utils.getOwnerIdentity((boolean)true).getProfile();
    }

    public String getAvatarURL(Profile profile) {
        String ownerAvatar = profile.getAvatarUrl();
        if (ownerAvatar == null || ownerAvatar.isEmpty()) {
            ownerAvatar = "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
        }
        return ownerAvatar;
    }

    protected UserNavigation getSelectedNode() throws Exception {
        UserNode node = Util.getUIPortal().getSelectedUserNode();
        UserNavigation nav = UIUserNavigationPortlet.getUserPortal().getNavigation(node.getNavigation().getKey());
        return nav;
    }

    private static UserPortal getUserPortal() {
        UserPortalConfig portalConfig = Util.getPortalRequestContext().getUserPortalConfig();
        return portalConfig.getUserPortal();
    }

    protected boolean isEditProfilePage() throws Exception {
        String uri = Util.getUIPortal().getSelectedUserNode().getURI();
        return uri.endsWith("edit-profile");
    }

    public Map<String, String> getUserNodes() throws Exception {
        if (this.userNodes == null) {
            this.userNodes = new LinkedHashMap();
            this.userNodes.put("profile", this.getProfileLink());
            this.userNodes.put("activities", this.getactivitesURL());
            this.userNodes.put("connections", this.getrelationURL());
            if (ExoContainer.hasProfile((String)"wiki")) {
                this.userNodes.put("wiki", this.getWikiURL());
            }
            if (CommonsUtils.isFeatureActive((String)"wallet", (String)Utils.getViewerRemoteId())) {
                this.userNodes.put("wallet", this.getWalletURL());
            }
            if (CommonsUtils.isFeatureActive((String)"gamification", (String)Utils.getViewerRemoteId())) {
                this.userNodes.put("achievements", this.getGamificationURL());
            }
            if (CommonsUtils.isFeatureActive((String)"notification")) {
                this.userNodes.put("NotificationSettingsPortlet", this.getNotificationsURL());
            }
        }
        return this.userNodes;
    }

    public String getNotificationsURL() {
        return LinkProvider.getUserNotificationSettingUri((String)Utils.getOwnerRemoteId());
    }

    public String getactivitesURL() {
        return LinkProvider.getUserActivityUri((String)Utils.getOwnerRemoteId());
    }

    public String getrelationURL() {
        return LinkProvider.getUserConnectionsYoursUri((String)Utils.getOwnerRemoteId());
    }

    public String getWalletURL() {
        return NavigationURLUtils.getURLInCurrentPortal((String)"wallet");
    }

    public String getGamificationURL() {
        return NavigationURLUtils.getURLInCurrentPortal((String)"achievements");
    }

    public String getWikiURL() {
        return NavigationURLUtils.getURLInCurrentPortal((String)"wiki") + "/user/" + Utils.getOwnerRemoteId() + "/WikiHome";
    }

    protected StatusInfo getStatusInfo() {
        String status;
        Profile currentProfile = this.getOwnerProfile();
        StatusInfo si = new StatusInfo(this);
        ResourceBundle rb = PortalRequestContext.getCurrentInstance().getApplicationResourceBundle();
        UserStateService stateService = (UserStateService)this.getApplicationComponent(UserStateService.class);
        boolean isOnline = stateService.isOnline(currentProfile.getIdentity().getRemoteId());
        if (isOnline && !"invisible".equals(status = stateService.getUserState(currentProfile.getIdentity().getRemoteId()).getStatus())) {
            si.setCssName(StatusIconCss.getIconCss((String)status));
            si.setTitle(rb.getString("UIUserNavigationPortlet.label." + status));
            return si;
        }
        si.setCssName(StatusIconCss.getIconCss((String)"offline"));
        si.setTitle(rb.getString("UIUserNavigationPortlet.label.offline"));
        return si;
    }

    public String getProfileLink() {
        return LinkProvider.getUserProfileUri((String)Utils.getOwnerRemoteId());
    }

    private void removeProfileBanner() throws MessageException {
        Profile p = Utils.getOwnerIdentity().getProfile();
        p.removeProperty("banner");
        p.setBannerUrl(null);
        p.setListUpdateTypes(Arrays.asList(Profile.UpdateType.BANNER));
        Utils.getIdentityManager().updateProfile(p);
    }

    static /* synthetic */ void access$000(UIUserNavigationPortlet x0) throws MessageException {
        x0.removeProfileBanner();
    }
}

