/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheResult<V> {
    private static final CacheResult INTERRUPTED = new CacheResult(State.INTERRUPTED);
    private static final CacheResult NOT_IN_CACHE = new CacheResult(State.NOT_IN_CACHE);
    private final State state;
    private final V res;

    static final <V> CacheResult<V> getNotInCache() {
        return NOT_IN_CACHE;
    }

    static final <V> CacheResult<V> getInterrupted() {
        return INTERRUPTED;
    }

    private CacheResult(State state, V v) {
        this.state = state;
        this.res = v;
    }

    CacheResult(V v) {
        this(State.VALID, v);
    }

    CacheResult(State state) {
        this(state, null);
    }

    public V getRes() {
        if (this.state == State.VALID) {
            return this.res;
        }
        throw new IllegalStateException(this + " is not valid : " + (Object)((Object)this.getState()));
    }

    public State getState() {
        return this.state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        VALID,
        NOT_IN_CACHE,
        INTERRUPTED;

    }
}

