package org.exoplatform.tcm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author Dimitri BAELI, CanhBX
 *
 */
public class TestCaseFunctionInfo {	
	//------------Properties
	String id = "";
	String relatedFunction = "";
	Set<String> priorityList = new HashSet<String>();
	String path = "";
	Integer highPriorityNumber = 0;
	Integer mediumPriorityNumber = 0;
	Integer lowPriorityNumber = 0;

	String comments = "";	
	
	Map<Integer, String> commentMap = new HashMap<Integer, String>();
	Map<String, RunResultAggregator> resultsPerBrowser = new HashMap<String, RunResultAggregator>();
	
	//------------Constructors
	public TestCaseFunctionInfo(String path, String relatedFunction) {
		super();
		this.path = path;
		this.id = relatedFunction;
	}	

	//----------Business methods for testResult
	public void addComment(Integer caseId, String comment){
		String commentData = commentMap.get(caseId);
		if(commentData != null && !"".equals(commentData)){
			commentData += comment;
			commentMap.put(caseId, commentData);
		}else{
			commentMap.put(caseId, comment);
		}
	}

	public boolean increaseTestResult(String browser, String id, String browserResult, String priorityType,TestCaseFunctionInfo functionInfo, String message) {
		RunResultAggregator runResultCount = resultsPerBrowser.get(browser);
		if (runResultCount == null) {
			runResultCount = new RunResultAggregator();
			resultsPerBrowser.put(browser, runResultCount);
		}
		return runResultCount.registerTesterResult(id, browserResult, priorityType, functionInfo, message, browser, browserResult);
	}

	public int getTestPassedCount(String browser, String priorityType) {
		return resultsPerBrowser.get(browser).getTestPassedCount(priorityType);
	}
	
	public int getTestFailedCount(String browser, String priorityType) {
		return resultsPerBrowser.get(browser).getTestFailedCount(priorityType);
	}

	public int getTestBlockedCount(String browser, String priorityType) {
		return resultsPerBrowser.get(browser).getTestBlockedCount(priorityType);
	}	
	
	public int getTestNACount(String browser, String priorityType) {
		return resultsPerBrowser.get(browser).getTestNACount(priorityType);
	}
	
	public int getTestNotRunCount(String browser, String priorityType) {
		return resultsPerBrowser.get(browser).getTestNotRunCount(priorityType);
	}
	
	//Override equal and hashcode method to compare obj
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TestCaseFunctionInfo other = (TestCaseFunctionInfo) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}
	
	//--------------Getters & Setters
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	public String getRelatedFunction() {
		return relatedFunction;
	}

	public void setRelatedFunction(String relatedFunction) {
		this.relatedFunction = relatedFunction;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}	
	
	public void setComments(String comment){
		this.comments = comment;
	}
	
	public String getComments(){
		return comments;
	}
	
	public Integer getHighPriorityNumber() {
		return highPriorityNumber;
	}

	public void increaseHighPriorityNumber() {
		this.highPriorityNumber++;
	}

	public Integer getMediumPriorityNumber() {
		return mediumPriorityNumber;
	}

	public void increaseMediumPriorityNumber() {
		this.mediumPriorityNumber++;
	}

	public Integer getLowPriorityNumber() {
		return lowPriorityNumber;
	}

	public void increaseLowPriorityNumber() {
		this.lowPriorityNumber++;
	}
	
	public Set<String> getPriorityList() {
		return priorityList;
	}

	public Map<Integer, String> getCommentMap() {
		return commentMap;
	}
}