/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import microsoft.exchange.webservices.data.Base64EncoderStream;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XMLNodeType;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EwsXmlReader {
    private static final int ReadWriteBufferSize = 4096;
    private XMLEventReader xmlReader = null;
    private XMLEvent presentEvent;
    private XMLEvent prevEvent;

    public EwsXmlReader(InputStream stream) throws Exception {
        this.xmlReader = this.initializeXmlReader(stream);
    }

    protected XMLEventReader initializeXmlReader(InputStream stream) throws XMLStreamException, Exception {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        return inputFactory.createXMLEventReader(stream);
    }

    private static String formatElementName(String namespacePrefix, String localElementName) {
        return EwsXmlReader.isNullOrEmpty(namespacePrefix) ? localElementName : namespacePrefix + ":" + localElementName;
    }

    private void internalReadElement(XmlNamespace xmlNamespace, String localName, XMLNodeType nodeType) throws Exception {
        if (xmlNamespace == XmlNamespace.NotSpecified) {
            this.internalReadElement("", localName, nodeType);
        } else {
            this.read(nodeType);
            if (!this.getLocalName().equals(localName) || this.getNamespaceUri() != EwsUtilities.getNamespaceUri(xmlNamespace)) {
                throw new ServiceXmlDeserializationException(String.format(Strings.UnexpectedElement, EwsUtilities.getNamespacePrefix(xmlNamespace), localName, nodeType.toString(), this.getName(), this.getNodeType().toString()));
            }
        }
    }

    private void internalReadElement(String namespacePrefix, String localName, XMLNodeType nodeType) throws Exception {
        this.read(nodeType);
        if (!this.getLocalName().equals(localName) || !this.getNamespacePrefix().equals(namespacePrefix)) {
            throw new ServiceXmlDeserializationException(String.format(Strings.UnexpectedElement, namespacePrefix, localName, nodeType.toString(), this.getName(), this.getNodeType().toString()));
        }
    }

    public void read() throws ServiceXmlDeserializationException, XMLStreamException {
        Characters characters;
        XMLEvent event;
        do {
            if (this.xmlReader.hasNext()) continue;
            throw new ServiceXmlDeserializationException(Strings.UnexpectedEndOfXmlDocument);
        } while ((event = this.xmlReader.nextEvent()).getEventType() == 4 && ((characters = (Characters)event).isIgnorableWhiteSpace() || characters.isWhiteSpace()));
        this.prevEvent = this.presentEvent;
        this.presentEvent = event;
    }

    public void read(XMLNodeType nodeType) throws Exception {
        this.read();
        if (!this.getNodeType().equals(nodeType)) {
            throw new ServiceXmlDeserializationException(String.format(Strings.UnexpectedElementType, nodeType, this.getNodeType()));
        }
    }

    private String readAttributeValue(QName qName) throws Exception {
        if (this.presentEvent.isStartElement()) {
            StartElement startElement = this.presentEvent.asStartElement();
            Attribute attr = startElement.getAttributeByName(qName);
            if (null != attr) {
                return attr.getValue();
            }
            return null;
        }
        String errMsg = String.format("Could not fetch attribute %s", qName.toString());
        throw new Exception(errMsg);
    }

    public String readAttributeValue(XmlNamespace xmlNamespace, String attributeName) throws Exception {
        if (xmlNamespace == XmlNamespace.NotSpecified) {
            return this.readAttributeValue(attributeName);
        }
        QName qName = new QName(EwsUtilities.getNamespaceUri(xmlNamespace), attributeName);
        return this.readAttributeValue(qName);
    }

    public String readAttributeValue(String attributeName) throws Exception {
        QName qName = new QName(attributeName);
        return this.readAttributeValue(qName);
    }

    public <T> T readAttributeValue(Class<T> cls, String attributeName) throws Exception {
        return EwsUtilities.parse(cls, this.readAttributeValue(attributeName));
    }

    public <T> T readNullableAttributeValue(Class<T> cls, String attributeName) throws Exception {
        String attributeValue = this.readAttributeValue(attributeName);
        if (attributeValue == null) {
            return null;
        }
        return EwsUtilities.parse(cls, attributeValue);
    }

    public String readElementValue(String namespacePrefix, String localName) throws Exception {
        if (!this.isStartElement(namespacePrefix, localName)) {
            this.readStartElement(namespacePrefix, localName);
        }
        String value = null;
        if (!this.isEmptyElement()) {
            value = this.readValue();
        }
        return value;
    }

    public String readElementValue(XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!this.isStartElement(xmlNamespace, localName)) {
            this.readStartElement(xmlNamespace, localName);
        }
        String value = null;
        if (!this.isEmptyElement()) {
            value = this.readValue();
        } else {
            this.read();
        }
        return value;
    }

    public String readElementValue() throws Exception {
        this.ensureCurrentNodeIsStartElement();
        return this.readElementValue(this.getNamespacePrefix(), this.getLocalName());
    }

    public <T> T readElementValue(Class<T> cls, XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!this.isStartElement(xmlNamespace, localName)) {
            this.readStartElement(xmlNamespace, localName);
        }
        T value = null;
        if (!this.isEmptyElement()) {
            value = this.readValue(cls);
        }
        return value;
    }

    public <T> T readElementValue(Class<T> cls) throws Exception {
        this.ensureCurrentNodeIsStartElement();
        T value = null;
        if (!this.isEmptyElement()) {
            value = this.readValue(cls);
        }
        return value;
    }

    public String readValue() throws XMLStreamException, ServiceXmlDeserializationException {
        String errMsg = String.format("Could not read value from %s.", XMLNodeType.getString(this.presentEvent.getEventType()));
        if (this.presentEvent.isStartElement()) {
            this.read();
            if (this.presentEvent.isCharacters()) {
                StringBuffer elementValue = new StringBuffer();
                do {
                    Characters characters;
                    if (this.getNodeType().nodeType == 4 && !(characters = (Characters)this.presentEvent).isIgnorableWhiteSpace() && !characters.isWhiteSpace() && characters.getData().length() != 0) {
                        elementValue.append(characters.getData());
                    }
                    this.read();
                } while (!this.presentEvent.isEndElement());
                return elementValue.toString();
            }
            errMsg = errMsg + "Could not find " + XMLNodeType.getString(4);
            throw new ServiceXmlDeserializationException(errMsg);
        }
        if (this.presentEvent.getEventType() == 4 && this.presentEvent.isCharacters()) {
            StringBuffer data = new StringBuffer(this.presentEvent.asCharacters().getData());
            do {
                Characters characters;
                this.read();
                if (this.getNodeType().nodeType != 4 || (characters = (Characters)this.presentEvent).isIgnorableWhiteSpace() || characters.isWhiteSpace() || characters.getData().length() == 0) continue;
                data.append(characters.getData());
            } while (!this.presentEvent.isEndElement());
            return data.toString();
        }
        errMsg = errMsg + "Expected is " + XMLNodeType.getString(1);
        throw new ServiceXmlDeserializationException(errMsg);
    }

    public boolean tryReadValue(OutParam<String> value) throws XMLStreamException, ServiceXmlDeserializationException {
        if (!this.isEmptyElement()) {
            this.read();
            if (this.presentEvent.isCharacters()) {
                value.setParam((Object)this.readValue());
                return true;
            }
            return false;
        }
        return false;
    }

    public <T> T readValue(Class<T> cls) throws Exception {
        return EwsUtilities.parse(cls, this.readValue());
    }

    public byte[] readBase64ElementValue() throws ServiceXmlDeserializationException, XMLStreamException, IOException {
        this.ensureCurrentNodeIsStartElement();
        byte[] buffer = null;
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        buffer = Base64EncoderStream.decode(this.xmlReader.getElementText().toString());
        byteArrayStream.write(buffer);
        return byteArrayStream.toByteArray();
    }

    public void readBase64ElementValue(OutputStream outputStream) throws Exception {
        this.ensureCurrentNodeIsStartElement();
        byte[] buffer = null;
        buffer = Base64EncoderStream.decode(this.xmlReader.getElementText().toString());
        outputStream.write(buffer);
        outputStream.flush();
    }

    public void readStartElement(String namespacePrefix, String localName) throws Exception {
        this.internalReadElement(namespacePrefix, localName, new XMLNodeType(1));
    }

    public void readStartElement(XmlNamespace xmlNamespace, String localName) throws Exception {
        this.internalReadElement(xmlNamespace, localName, new XMLNodeType(1));
    }

    public void readEndElement(String namespacePrefix, String elementName) throws Exception {
        this.internalReadElement(namespacePrefix, elementName, new XMLNodeType(2));
    }

    public void readEndElement(XmlNamespace xmlNamespace, String localName) throws Exception {
        this.internalReadElement(xmlNamespace, localName, new XMLNodeType(2));
    }

    public void readEndElementIfNecessary(XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!(this.isStartElement(xmlNamespace, localName) && this.isEmptyElement() || this.isEndElement(xmlNamespace, localName))) {
            this.readEndElement(xmlNamespace, localName);
        }
    }

    public boolean isStartElement() {
        return this.presentEvent.isStartElement();
    }

    public boolean isStartElement(String namespacePrefix, String localName) {
        boolean isStart = false;
        if (this.presentEvent.isStartElement()) {
            StartElement startElement = this.presentEvent.asStartElement();
            QName qName = startElement.getName();
            isStart = qName.getLocalPart().equals(localName) && qName.getPrefix().equals(namespacePrefix);
        }
        return isStart;
    }

    public boolean isStartElement(XmlNamespace xmlNamespace, String localName) {
        return this.isStartElement() && this.getLocalName().equals(localName) && (this.getNamespacePrefix() == EwsUtilities.getNamespacePrefix(xmlNamespace) || this.getNamespaceUri() == EwsUtilities.getNamespaceUri(xmlNamespace));
    }

    public boolean isEndElement(String namespacePrefix, String localName) {
        boolean isEndElement = false;
        if (this.presentEvent.isEndElement()) {
            EndElement endElement = this.presentEvent.asEndElement();
            QName qName = endElement.getName();
            isEndElement = qName.getLocalPart().equals(localName) && qName.getPrefix().equals(namespacePrefix);
        }
        return isEndElement;
    }

    public boolean isEndElement(XmlNamespace xmlNamespace, String localName) {
        boolean isEndElement = false;
        if (this.presentEvent.isEndElement()) {
            EndElement endElement = this.presentEvent.asEndElement();
            QName qName = endElement.getName();
            isEndElement = qName.getLocalPart().equals(localName) && (qName.getPrefix().equals(EwsUtilities.getNamespacePrefix(xmlNamespace)) || qName.getNamespaceURI().equals(EwsUtilities.getNamespaceUri(xmlNamespace)));
        }
        return isEndElement;
    }

    public void skipElement(String namespacePrefix, String localName) throws Exception {
        if (!this.isEndElement(namespacePrefix, localName)) {
            if (!this.isStartElement(namespacePrefix, localName)) {
                this.readStartElement(namespacePrefix, localName);
            }
            if (!this.isEmptyElement()) {
                do {
                    this.read();
                } while (!this.isEndElement(namespacePrefix, localName));
            }
        }
    }

    public void skipElement(XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!this.isEndElement(xmlNamespace, localName)) {
            if (!this.isStartElement(xmlNamespace, localName)) {
                this.readStartElement(xmlNamespace, localName);
            }
            if (!this.isEmptyElement()) {
                do {
                    this.read();
                } while (!this.isEndElement(xmlNamespace, localName));
            }
        }
    }

    public void skipCurrentElement() throws Exception {
        this.skipElement(this.getNamespacePrefix(), this.getLocalName());
    }

    public void ensureCurrentNodeIsStartElement(XmlNamespace xmlNamespace, String localName) throws ServiceXmlDeserializationException {
        if (!this.isStartElement(xmlNamespace, localName)) {
            throw new ServiceXmlDeserializationException(String.format(Strings.ElementNotFound, new Object[]{localName, xmlNamespace}));
        }
    }

    public void ensureCurrentNodeIsStartElement() throws ServiceXmlDeserializationException {
        XMLNodeType presentNodeType = new XMLNodeType(this.presentEvent.getEventType());
        if (!this.presentEvent.isStartElement()) {
            throw new ServiceXmlDeserializationException(String.format(Strings.ExpectedStartElement, this.presentEvent.toString(), presentNodeType.toString()));
        }
    }

    public void ensureCurrentNodeIsEndElement(XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!(this.isEndElement(xmlNamespace, localName) || this.isStartElement(xmlNamespace, localName) && this.isEmptyElement())) {
            throw new ServiceXmlDeserializationException(String.format(Strings.ElementNotFound, new Object[]{xmlNamespace, localName}));
        }
    }

    public String readOuterXml() throws ServiceXmlDeserializationException, XMLStreamException {
        XMLEvent event;
        if (!this.isStartElement()) {
            throw new ServiceXmlDeserializationException(Strings.CurrentPositionNotElementStart);
        }
        XMLEvent startEvent = this.presentEvent;
        StringBuilder str = new StringBuilder();
        str.append(startEvent);
        do {
            event = this.xmlReader.nextEvent();
            str.append(event);
        } while (!EwsXmlReader.checkEndElement(startEvent, event));
        return str.toString();
    }

    public String readInnerXml() throws ServiceXmlDeserializationException, XMLStreamException {
        XMLEvent event;
        if (!this.isStartElement()) {
            throw new ServiceXmlDeserializationException(Strings.CurrentPositionNotElementStart);
        }
        XMLEvent startEvent = this.presentEvent;
        StringBuilder str = new StringBuilder();
        while (!EwsXmlReader.checkEndElement(startEvent, event = this.xmlReader.nextEvent())) {
            str.append(event);
        }
        return str.toString();
    }

    public static boolean checkEndElement(XMLEvent startEvent, XMLEvent endEvent) {
        boolean isEndElement = false;
        if (endEvent.isEndElement()) {
            QName qEName = endEvent.asEndElement().getName();
            QName qSName = startEvent.asStartElement().getName();
            isEndElement = qEName.getLocalPart().equals(qSName.getLocalPart()) && (qEName.getPrefix().equals(qSName.getPrefix()) || qEName.getNamespaceURI().equals(qSName.getNamespaceURI()));
        }
        return isEndElement;
    }

    protected XMLEventReader getXmlReaderForNode() throws FileNotFoundException, ServiceXmlDeserializationException, XMLStreamException {
        return this.readSubtree();
    }

    public XMLEventReader readSubtree() throws XMLStreamException, FileNotFoundException, ServiceXmlDeserializationException {
        XMLEvent startEvent;
        if (!this.isStartElement()) {
            throw new ServiceXmlDeserializationException(Strings.CurrentPositionNotElementStart);
        }
        XMLEventReader eventReader = null;
        ByteArrayInputStream in = null;
        XMLEvent event = startEvent = this.presentEvent;
        StringBuilder str = new StringBuilder();
        str.append(startEvent);
        do {
            event = this.xmlReader.nextEvent();
            str.append(event);
        } while (!EwsXmlReader.checkEndElement(startEvent, event));
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            try {
                in = new ByteArrayInputStream(str.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            eventReader = inputFactory.createXMLEventReader(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return eventReader;
    }

    public void ReadToDescendant(XmlNamespace xmlNamespace, String localName) throws XMLStreamException {
        this.readToDescendant(localName, EwsUtilities.getNamespaceUri(xmlNamespace));
    }

    public boolean readToDescendant(String localName, String namespaceURI) throws XMLStreamException {
        if (!this.isStartElement()) {
            return false;
        }
        XMLEvent startEvent = this.presentEvent;
        XMLEvent event = this.presentEvent;
        do {
            QName qEName;
            if (!event.isStartElement() || !(qEName = event.asStartElement().getName()).getLocalPart().equals(localName) || !qEName.getNamespaceURI().equals(namespaceURI)) continue;
            return true;
        } while (!EwsXmlReader.checkEndElement(startEvent, event = this.xmlReader.nextEvent()));
        return false;
    }

    public boolean hasAttributes() {
        if (this.presentEvent.isStartElement()) {
            StartElement startElement = this.presentEvent.asStartElement();
            return startElement.getAttributes().hasNext();
        }
        return false;
    }

    public boolean isEmptyElement() throws XMLStreamException {
        boolean isPresentStartElement = this.presentEvent.isStartElement();
        boolean isNextEndElement = this.xmlReader.peek().isEndElement();
        return isPresentStartElement && isNextEndElement;
    }

    public String getLocalName() {
        String localName = null;
        localName = this.presentEvent.isStartElement() ? this.presentEvent.asStartElement().getName().getLocalPart() : this.presentEvent.asEndElement().getName().getLocalPart();
        return localName;
    }

    protected String getNamespacePrefix() {
        if (this.presentEvent.isStartElement()) {
            return this.presentEvent.asStartElement().getName().getPrefix();
        }
        if (this.presentEvent.isEndElement()) {
            return this.presentEvent.asEndElement().getName().getPrefix();
        }
        return null;
    }

    protected String getNamespaceUri() {
        String nameSpaceUri = null;
        nameSpaceUri = this.presentEvent.isStartElement() ? this.presentEvent.asStartElement().getName().getNamespaceURI() : this.presentEvent.asEndElement().getName().getNamespaceURI();
        return nameSpaceUri;
    }

    public XMLNodeType getNodeType() throws XMLStreamException {
        XMLEvent event = this.presentEvent;
        XMLNodeType nodeType = new XMLNodeType(event.getEventType());
        return nodeType;
    }

    protected Object getName() {
        String name = null;
        name = this.presentEvent.isStartElement() ? this.presentEvent.asStartElement().getName().toString() : this.presentEvent.asEndElement().getName().toString();
        return name;
    }

    private static boolean isNullOrEmpty(String namespacePrefix) {
        return namespacePrefix == null || namespacePrefix.isEmpty();
    }
}

