/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.InvalidOperationException;
import microsoft.exchange.webservices.data.WebCredentials;

public abstract class ExchangeCredentials {
    public static ExchangeCredentials getExchangeCredentialsFromNetworkCredential(String userName, String password, String domain) {
        return new WebCredentials(userName, password, domain);
    }

    protected static String getUriWithoutWSSecurity(URI url) {
        String absoluteUri = url.toString();
        int index = absoluteUri.indexOf("/wssecurity");
        if (index == -1) {
            return absoluteUri;
        }
        return absoluteUri.substring(0, index);
    }

    protected void preAuthenticate() {
    }

    protected void prepareWebRequest(HttpWebRequest client) throws URISyntaxException {
    }

    protected void emitExtraSoapHeaderNamespaceAliases(XMLStreamWriter writer) throws XMLStreamException {
    }

    protected void serializeExtraSoapHeaders(XMLStreamWriter writer, String webMethodName) throws XMLStreamException {
    }

    protected URI adjustUrl(URI url) throws URISyntaxException {
        return new URI(ExchangeCredentials.getUriWithoutWSSecurity(url));
    }

    protected boolean isNeedSignature() {
        return false;
    }

    protected void sign(ByteArrayOutputStream memoryStream) throws Exception {
        throw new InvalidOperationException();
    }

    protected void serializeWSSecurityHeaders(XMLStreamWriter writer) throws XMLStreamException {
    }
}

