/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.UUID;
import microsoft.exchange.webservices.data.DefaultExtendedPropertySet;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.MapiPropertyType;
import microsoft.exchange.webservices.data.MapiTypeConverter;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedPropertyDefinition
extends PropertyDefinitionBase {
    private DefaultExtendedPropertySet propertySet;
    private UUID propertySetId;
    private Integer tag;
    private String name;
    private Integer id;
    private MapiPropertyType mapiType = MapiPropertyType.String;
    private static final String FieldFormat = "%s: %s ";
    private static final String PropertySetFieldName = "PropertySet";
    private static final String PropertySetIdFieldName = "PropertySetId";
    private static final String TagFieldName = "Tag";
    private static final String NameFieldName = "Name";
    private static final String IdFieldName = "Id";
    private static final String MapiTypeFieldName = "MapiType";

    protected ExtendedPropertyDefinition() {
    }

    protected ExtendedPropertyDefinition(MapiPropertyType mapiType) {
        this();
        this.mapiType = mapiType;
    }

    public ExtendedPropertyDefinition(int tag, MapiPropertyType mapiType) {
        this(mapiType);
        if (tag < 0) {
            throw new IllegalArgumentException("Argument out of range : tag " + Strings.TagValueIsOutOfRange);
        }
        this.tag = tag;
    }

    public ExtendedPropertyDefinition(DefaultExtendedPropertySet propertySet, String name, MapiPropertyType mapiType) throws Exception {
        this(mapiType);
        EwsUtilities.validateParam(name, "name");
        this.propertySet = propertySet;
        this.name = name;
    }

    public ExtendedPropertyDefinition(DefaultExtendedPropertySet propertySet, int id, MapiPropertyType mapiType) {
        this(mapiType);
        this.propertySet = propertySet;
        this.id = id;
    }

    public ExtendedPropertyDefinition(UUID propertySetId, String name, MapiPropertyType mapiType) throws Exception {
        this(mapiType);
        EwsUtilities.validateParam(name, "name");
        this.propertySetId = propertySetId;
        this.name = name;
    }

    public ExtendedPropertyDefinition(UUID propertySetId, int id, MapiPropertyType mapiType) {
        this(mapiType);
        this.propertySetId = propertySetId;
        this.id = id;
    }

    protected static boolean isEqualTo(ExtendedPropertyDefinition extPropDef1, ExtendedPropertyDefinition extPropDef2) {
        return extPropDef1 == extPropDef2 || extPropDef1 != null && extPropDef2 != null && (extPropDef1.getId() == extPropDef2.getId() || extPropDef1.getId() != null && extPropDef1.getId().equals(extPropDef2.getId())) && extPropDef1.getMapiType() == extPropDef2.getMapiType() && (extPropDef1.getTag() == extPropDef2.getTag() || extPropDef1.getTag() != null && extPropDef1.getTag().equals(extPropDef2.getTag())) && (extPropDef1.getName() == extPropDef2.getName() || extPropDef1.getName() != null && extPropDef1.getName().equals(extPropDef2.getName())) && extPropDef1.getPropertySet() == extPropDef2.getPropertySet() && (extPropDef1.propertySetId == extPropDef2.propertySetId || extPropDef1.propertySetId != null && extPropDef1.propertySetId.equals(extPropDef2.propertySetId));
    }

    @Override
    protected String getXmlElementName() {
        return "ExtendedFieldURI";
    }

    @Override
    public ExchangeVersion getVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        if (this.propertySet != null) {
            writer.writeAttributeValue("DistinguishedPropertySetId", (Object)this.propertySet);
        }
        if (this.propertySetId != null) {
            writer.writeAttributeValue(PropertySetIdFieldName, this.propertySetId.toString());
        }
        if (this.tag != null) {
            writer.writeAttributeValue("PropertyTag", this.tag);
        }
        if (null != this.name && !this.name.isEmpty()) {
            writer.writeAttributeValue("PropertyName", this.name);
        }
        if (this.id != null) {
            writer.writeAttributeValue("PropertyId", this.id);
        }
        writer.writeAttributeValue("PropertyType", (Object)this.mapiType);
    }

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        String attributeValue = reader.readAttributeValue("DistinguishedPropertySetId");
        if (null != attributeValue && !attributeValue.isEmpty()) {
            this.propertySet = DefaultExtendedPropertySet.valueOf(attributeValue);
        }
        if (null != (attributeValue = reader.readAttributeValue(PropertySetIdFieldName)) && !attributeValue.isEmpty()) {
            this.propertySetId = UUID.fromString(attributeValue);
        }
        if (null != (attributeValue = reader.readAttributeValue("PropertyTag")) && !attributeValue.isEmpty()) {
            this.tag = Integer.getInteger(attributeValue, 16);
        }
        this.name = reader.readAttributeValue("PropertyName");
        attributeValue = reader.readAttributeValue("PropertyId");
        if (null != attributeValue && !attributeValue.isEmpty()) {
            this.id = Integer.parseInt(attributeValue);
        }
        this.mapiType = reader.readAttributeValue(MapiPropertyType.class, "PropertyType");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtendedPropertyDefinition) {
            return ExtendedPropertyDefinition.isEqualTo(this, (ExtendedPropertyDefinition)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.getPrintableName().hashCode();
    }

    @Override
    protected String getPrintableName() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.formatField(NameFieldName, this.getName()));
        sb.append(this.formatField(MapiTypeFieldName, this.getMapiType()));
        sb.append(this.formatField(IdFieldName, this.getId()));
        sb.append(this.formatField(PropertySetFieldName, this.getPropertySet()));
        sb.append(this.formatField(PropertySetIdFieldName, this.getPropertySetId()));
        sb.append(this.formatField(TagFieldName, this.getTag()));
        sb.append("}");
        return sb.toString();
    }

    protected <T> String formatField(String name, T fieldValue) {
        return fieldValue != null ? String.format(FieldFormat, name, fieldValue.toString()) : "";
    }

    public DefaultExtendedPropertySet getPropertySet() {
        return this.propertySet;
    }

    public UUID getPropertySetId() {
        return this.propertySetId;
    }

    public Integer getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public Integer getId() {
        return this.id;
    }

    public MapiPropertyType getMapiType() {
        return this.mapiType;
    }

    @Override
    public Class getType() {
        return MapiTypeConverter.getMapiTypeConverterMap().get((Object)this.getMapiType()).getType();
    }
}

