/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.List;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.IGetObjectInstanceDelegate;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetFolderResponse
extends ServiceResponse
implements IGetObjectInstanceDelegate<ServiceObject> {
    private Folder folder;
    private PropertySet propertySet;

    protected GetFolderResponse(Folder folder, PropertySet propertySet) {
        this.folder = folder;
        this.propertySet = propertySet;
        EwsUtilities.EwsAssert(this.propertySet != null, "GetFolderResponse.ctor", "PropertySet should not be null");
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        super.readElementsFromXml(reader);
        List folders = reader.readServiceObjectsCollectionFromXml("Folders", this, true, this.propertySet, false);
        this.folder = (Folder)folders.get(0);
    }

    @Override
    public ServiceObject getObjectInstanceDelegate(ExchangeService service, String xmlElementName) throws Exception {
        return this.getObjectInstance(service, xmlElementName);
    }

    private Folder getObjectInstance(ExchangeService service, String xmlElementName) throws Exception {
        if (this.getFolder() != null) {
            return this.getFolder();
        }
        return (Folder)EwsUtilities.createEwsObjectFromXmlElementName(Folder.class, service, xmlElementName);
    }

    public Folder getFolder() {
        return this.folder;
    }
}

