/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import microsoft.exchange.webservices.data.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.DeleteMode;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ExtendedProperty;
import microsoft.exchange.webservices.data.ExtendedPropertyCollection;
import microsoft.exchange.webservices.data.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.IServiceObjectChangedDelegate;
import microsoft.exchange.webservices.data.InvalidOperationException;
import microsoft.exchange.webservices.data.NotSupportedException;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.PropertyBag;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.SendCancellationsMode;
import microsoft.exchange.webservices.data.ServiceId;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.ServiceObjectPropertyException;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceObject {
    private Object lockObject = new Object();
    private ExchangeService service;
    private PropertyBag propertyBag;
    private String xmlElementName;
    private List<IServiceObjectChangedDelegate> onChange = new ArrayList<IServiceObjectChangedDelegate>();

    protected void changed() {
        for (IServiceObjectChangedDelegate change : this.onChange) {
            change.serviceObjectChanged(this);
        }
    }

    protected void throwIfThisIsNew() throws InvalidOperationException, ServiceLocalException {
        if (this.isNew()) {
            throw new InvalidOperationException(Strings.ServiceObjectDoesNotHaveId);
        }
    }

    protected void throwIfThisIsNotNew() throws InvalidOperationException, ServiceLocalException {
        if (!this.isNew()) {
            throw new InvalidOperationException(Strings.ServiceObjectAlreadyHasId);
        }
    }

    protected String getXmlElementNameOverride() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getXmlElementName() {
        if (this.isNullOrEmpty(this.xmlElementName)) {
            this.xmlElementName = this.getXmlElementNameOverride();
            if (this.isNullOrEmpty(this.xmlElementName)) {
                Object object = this.lockObject;
                synchronized (object) {
                    ServiceObjectDefinition annotation = this.getClass().getAnnotation(ServiceObjectDefinition.class);
                    if (null != annotation) {
                        this.xmlElementName = annotation.xmlElementName();
                    }
                }
            }
        }
        EwsUtilities.EwsAssert(!this.isNullOrEmpty(this.xmlElementName), "EwsObject.GetXmlElementName", String.format("The class %s does not have an associated XML element name.", this.getClass().getName()));
        return this.xmlElementName;
    }

    protected String getChangeXmlElementName() {
        return "ItemChange";
    }

    protected String getSetFieldXmlElementName() {
        return "SetItemField";
    }

    protected String getDeleteFieldXmlElementName() {
        return "DeleteItemField";
    }

    protected boolean getIsTimeZoneHeaderRequired(boolean isUpdateOperation) throws ServiceLocalException, Exception {
        return false;
    }

    protected boolean getIsCustomDateTimeScopingRequired() {
        return false;
    }

    protected PropertyBag getPropertyBag() {
        return this.propertyBag;
    }

    protected ServiceObject(ExchangeService service) throws Exception {
        EwsUtilities.validateParam(service, "service");
        EwsUtilities.validateServiceObjectVersion(this, service.getRequestedServerVersion());
        this.service = service;
        this.propertyBag = new PropertyBag(this);
    }

    public ServiceObjectSchema schema() {
        return this.getSchema();
    }

    protected abstract ServiceObjectSchema getSchema();

    protected abstract ExchangeVersion getMinimumRequiredServerVersion();

    protected void loadFromXml(EwsServiceXmlReader reader, boolean clearPropertyBag) throws Exception {
        this.getPropertyBag().loadFromXml(reader, clearPropertyBag, null, false);
    }

    protected void validate() throws Exception {
        this.getPropertyBag().validate();
    }

    protected void loadFromXml(EwsServiceXmlReader reader, boolean clearPropertyBag, PropertySet requestedPropertySet, boolean summaryPropertiesOnly) throws Exception {
        this.getPropertyBag().loadFromXml(reader, clearPropertyBag, requestedPropertySet, summaryPropertiesOnly);
    }

    protected void clearChangeLog() {
        this.getPropertyBag().clearChangeLog();
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getPropertyBag().writeToXml(writer);
    }

    protected void writeToXmlForUpdate(EwsServiceXmlWriter writer) throws Exception {
        this.getPropertyBag().writeToXmlForUpdate(writer);
    }

    protected abstract void internalLoad(PropertySet var1) throws Exception;

    protected abstract void internalDelete(DeleteMode var1, SendCancellationsMode var2, AffectedTaskOccurrence var3) throws Exception;

    public void load(PropertySet propertySet) throws Exception {
        this.internalLoad(propertySet);
    }

    public void load() throws Exception {
        this.internalLoad(PropertySet.getFirstClassProperties());
    }

    public Object getObjectFromPropertyDefinition(PropertyDefinitionBase propertyDefinition) throws Exception {
        OutParam propertyValue = new OutParam();
        PropertyDefinition propDef = (PropertyDefinition)propertyDefinition;
        if (propDef != null) {
            return this.getPropertyBag().getObjectFromPropertyDefinition(propDef);
        }
        ExtendedPropertyDefinition extendedPropDef = (ExtendedPropertyDefinition)propertyDefinition;
        if (extendedPropDef != null) {
            if (this.tryGetExtendedProperty(Object.class, extendedPropDef, propertyValue)) {
                return propertyValue;
            }
            throw new ServiceObjectPropertyException(Strings.MustLoadOrAssignPropertyBeforeAccess, propertyDefinition);
        }
        throw new NotSupportedException(String.format(Strings.OperationNotSupportedForPropertyDefinitionType, propertyDefinition.getType().getName()));
    }

    protected <T> boolean tryGetExtendedProperty(Class<T> cls, ExtendedPropertyDefinition propertyDefinition, OutParam<T> propertyValue) throws Exception {
        ExtendedPropertyCollection propertyCollection = this.getExtendedProperties();
        if (propertyCollection != null && propertyCollection.tryGetValue(cls, propertyDefinition, propertyValue)) {
            return true;
        }
        propertyValue.setParam((Object)null);
        return false;
    }

    public boolean tryGetProperty(PropertyDefinitionBase propertyDefinition, OutParam<Object> propertyValue) throws Exception {
        return this.tryGetProperty(Object.class, propertyDefinition, propertyValue);
    }

    public <T> boolean tryGetProperty(Class<T> cls, PropertyDefinitionBase propertyDefinition, OutParam<T> propertyValue) throws Exception {
        PropertyDefinition propDef = (PropertyDefinition)propertyDefinition;
        if (propDef != null) {
            return this.getPropertyBag().tryGetPropertyType(cls, propDef, propertyValue);
        }
        ExtendedPropertyDefinition extPropDef = (ExtendedPropertyDefinition)propertyDefinition;
        if (extPropDef != null) {
            return this.tryGetExtendedProperty(cls, extPropDef, propertyValue);
        }
        throw new NotSupportedException(String.format(Strings.OperationNotSupportedForPropertyDefinitionType, propertyDefinition.getType().getName()));
    }

    public Collection<PropertyDefinitionBase> getLoadedPropertyDefinitions() throws Exception {
        ArrayList<PropertyDefinitionBase> propDefs = new ArrayList<PropertyDefinitionBase>();
        for (PropertyDefinition propDef : this.getPropertyBag().getProperties().keySet()) {
            propDefs.add(propDef);
        }
        if (this.getExtendedProperties() != null) {
            for (ExtendedProperty extProp : this.getExtendedProperties()) {
                propDefs.add(extProp.getPropertyDefinition());
            }
        }
        return propDefs;
    }

    public ExchangeService getService() {
        return this.service;
    }

    protected void setService(ExchangeService service) {
        this.service = service;
    }

    protected PropertyDefinition getIdPropertyDefinition() {
        return null;
    }

    protected ServiceId getId() throws ServiceLocalException {
        PropertyDefinition idPropertyDefinition = this.getIdPropertyDefinition();
        OutParam<Object> serviceId = new OutParam<Object>();
        if (idPropertyDefinition != null) {
            this.getPropertyBag().tryGetValue(idPropertyDefinition, serviceId);
        }
        return (ServiceId)serviceId.getParam();
    }

    public boolean isNew() throws ServiceLocalException {
        ServiceId id = this.getId();
        return id == null ? true : !id.isValid();
    }

    public boolean isDirty() {
        return this.getPropertyBag().getIsDirty();
    }

    protected ExtendedPropertyCollection getExtendedProperties() throws Exception {
        return null;
    }

    private boolean isNullOrEmpty(String namespacePrefix) {
        return namespacePrefix == null || namespacePrefix.isEmpty();
    }

    public void addServiceObjectChangedEvent(IServiceObjectChangedDelegate change) {
        this.onChange.add(change);
    }

    public void removeServiceObjectChangedEvent(IServiceObjectChangedDelegate change) {
        this.onChange.remove(change);
    }

    public void clearServiceObjectChangedEvent() {
        this.onChange.clear();
    }
}

