/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FolderPermissionLevel;
import microsoft.exchange.webservices.data.FolderPermissionReadAccess;
import microsoft.exchange.webservices.data.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.PermissionScope;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.StandardUser;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UserId;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class FolderPermission
extends ComplexProperty
implements IComplexPropertyChangedDelegate {
    private static LazyMember<Map<FolderPermissionLevel, FolderPermission>> defaultPermissions = new LazyMember<Map<FolderPermissionLevel, FolderPermission>>(new ILazyMember<Map<FolderPermissionLevel, FolderPermission>>(){

        @Override
        public Map<FolderPermissionLevel, FolderPermission> createInstance() {
            HashMap<FolderPermissionLevel, FolderPermission> result = new HashMap<FolderPermissionLevel, FolderPermission>();
            FolderPermission permission = new FolderPermission();
            permission.canCreateItems = false;
            permission.canCreateSubFolders = false;
            permission.deleteItems = PermissionScope.None;
            permission.editItems = PermissionScope.None;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = false;
            permission.readItems = FolderPermissionReadAccess.None;
            result.put(FolderPermissionLevel.None, permission);
            permission = new FolderPermission();
            permission.canCreateItems = true;
            permission.canCreateSubFolders = false;
            permission.deleteItems = PermissionScope.None;
            permission.editItems = PermissionScope.None;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = true;
            permission.readItems = FolderPermissionReadAccess.None;
            result.put(FolderPermissionLevel.Contributor, permission);
            permission = new FolderPermission();
            permission.canCreateItems = false;
            permission.canCreateSubFolders = false;
            permission.deleteItems = PermissionScope.None;
            permission.editItems = PermissionScope.None;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = true;
            permission.readItems = FolderPermissionReadAccess.FullDetails;
            result.put(FolderPermissionLevel.Reviewer, permission);
            permission = new FolderPermission();
            permission.canCreateItems = true;
            permission.canCreateSubFolders = false;
            permission.deleteItems = PermissionScope.Owned;
            permission.editItems = PermissionScope.None;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = true;
            permission.readItems = FolderPermissionReadAccess.FullDetails;
            result.put(FolderPermissionLevel.NoneditingAuthor, permission);
            permission = new FolderPermission();
            permission.canCreateItems = true;
            permission.canCreateSubFolders = false;
            permission.deleteItems = PermissionScope.Owned;
            permission.editItems = PermissionScope.Owned;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = true;
            permission.readItems = FolderPermissionReadAccess.FullDetails;
            result.put(FolderPermissionLevel.Author, permission);
            permission = new FolderPermission();
            permission.canCreateItems = true;
            permission.canCreateSubFolders = true;
            permission.deleteItems = PermissionScope.Owned;
            permission.editItems = PermissionScope.Owned;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = true;
            permission.readItems = FolderPermissionReadAccess.FullDetails;
            result.put(FolderPermissionLevel.PublishingAuthor, permission);
            permission = new FolderPermission();
            permission.canCreateItems = true;
            permission.canCreateSubFolders = false;
            permission.deleteItems = PermissionScope.All;
            permission.editItems = PermissionScope.All;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = true;
            permission.readItems = FolderPermissionReadAccess.FullDetails;
            result.put(FolderPermissionLevel.Editor, permission);
            permission = new FolderPermission();
            permission.canCreateItems = true;
            permission.canCreateSubFolders = true;
            permission.deleteItems = PermissionScope.All;
            permission.editItems = PermissionScope.All;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = true;
            permission.readItems = FolderPermissionReadAccess.FullDetails;
            result.put(FolderPermissionLevel.PublishingEditor, permission);
            permission = new FolderPermission();
            permission.canCreateItems = true;
            permission.canCreateSubFolders = true;
            permission.deleteItems = PermissionScope.All;
            permission.editItems = PermissionScope.All;
            permission.isFolderContact = true;
            permission.isFolderOwner = true;
            permission.isFolderVisible = true;
            permission.readItems = FolderPermissionReadAccess.FullDetails;
            result.put(FolderPermissionLevel.Owner, permission);
            permission = new FolderPermission();
            permission.canCreateItems = false;
            permission.canCreateSubFolders = false;
            permission.deleteItems = PermissionScope.None;
            permission.editItems = PermissionScope.None;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = false;
            permission.readItems = FolderPermissionReadAccess.TimeOnly;
            result.put(FolderPermissionLevel.FreeBusyTimeOnly, permission);
            permission = new FolderPermission();
            permission.canCreateItems = false;
            permission.canCreateSubFolders = false;
            permission.deleteItems = PermissionScope.None;
            permission.editItems = PermissionScope.None;
            permission.isFolderContact = false;
            permission.isFolderOwner = false;
            permission.isFolderVisible = false;
            permission.readItems = FolderPermissionReadAccess.TimeAndSubjectAndLocation;
            result.put(FolderPermissionLevel.FreeBusyTimeAndSubjectAndLocation, permission);
            return result;
        }
    });
    private static LazyMember<List<FolderPermission>> levelVariants = new LazyMember<List<FolderPermission>>(new ILazyMember<List<FolderPermission>>(){

        @Override
        public List<FolderPermission> createInstance() {
            ArrayList<FolderPermission> results = new ArrayList<FolderPermission>();
            FolderPermission permissionNone = (FolderPermission)((Map)defaultPermissions.getMember()).get((Object)FolderPermissionLevel.None);
            FolderPermission permissionOwner = (FolderPermission)((Map)defaultPermissions.getMember()).get((Object)FolderPermissionLevel.Owner);
            try {
                FolderPermission permission = (FolderPermission)permissionNone.clone();
                permission.isFolderVisible = true;
                results.add(permission);
                permission = (FolderPermission)permissionNone.clone();
                permission.isFolderContact = true;
                results.add(permission);
                permission = (FolderPermission)permissionNone.clone();
                permission.isFolderContact = true;
                permission.isFolderVisible = true;
                results.add(permission);
                permission = (FolderPermission)permissionOwner.clone();
                permission.isFolderContact = false;
                results.add(permission);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return results;
        }
    });
    private UserId userId;
    private boolean canCreateItems;
    private boolean canCreateSubFolders;
    private boolean isFolderOwner;
    private boolean isFolderVisible;
    private boolean isFolderContact;
    private PermissionScope editItems = PermissionScope.None;
    private PermissionScope deleteItems = PermissionScope.None;
    private FolderPermissionReadAccess readItems = FolderPermissionReadAccess.None;
    private FolderPermissionLevel permissionLevel = FolderPermissionLevel.None;

    private boolean isEqualTo(FolderPermission permission) {
        return this.canCreateItems == permission.canCreateItems && this.canCreateSubFolders == permission.canCreateSubFolders && this.isFolderContact == permission.isFolderContact && this.isFolderVisible == permission.isFolderVisible && this.isFolderOwner == permission.isFolderOwner && this.editItems == permission.editItems && this.deleteItems == permission.deleteItems && this.readItems == permission.readItems;
    }

    private void AdjustPermissionLevel() {
        for (Map.Entry<FolderPermissionLevel, FolderPermission> keyValuePair : defaultPermissions.getMember().entrySet()) {
            if (!this.isEqualTo(keyValuePair.getValue())) continue;
            this.permissionLevel = keyValuePair.getKey();
            return;
        }
        this.permissionLevel = FolderPermissionLevel.Custom;
    }

    private void AssignIndividualPermissions(FolderPermission permission) {
        this.canCreateItems = permission.canCreateItems;
        this.canCreateSubFolders = permission.canCreateSubFolders;
        this.isFolderContact = permission.isFolderContact;
        this.isFolderOwner = permission.isFolderOwner;
        this.isFolderVisible = permission.isFolderVisible;
        this.editItems = permission.editItems;
        this.deleteItems = permission.deleteItems;
        this.readItems = permission.readItems;
    }

    public FolderPermission() {
        this.userId = new UserId();
    }

    public FolderPermission(UserId userId, FolderPermissionLevel permissionLevel) throws Exception {
        EwsUtilities.validateParam(userId, "userId");
        this.userId = userId;
        this.permissionLevel = permissionLevel;
    }

    public FolderPermission(String primarySmtpAddress, FolderPermissionLevel permissionLevel) {
        this.userId = new UserId(primarySmtpAddress);
        this.permissionLevel = permissionLevel;
    }

    public FolderPermission(StandardUser standardUser, FolderPermissionLevel permissionLevel) {
        this.userId = new UserId(standardUser);
        this.permissionLevel = permissionLevel;
    }

    void validate(boolean isCalendarFolder, int permissionIndex) throws ServiceValidationException, ServiceLocalException {
        if (!this.userId.isValid()) {
            throw new ServiceValidationException(String.format(Strings.FolderPermissionHasInvalidUserId, permissionIndex));
        }
        if (!isCalendarFolder) {
            if (this.readItems == FolderPermissionReadAccess.TimeAndSubjectAndLocation || this.readItems == FolderPermissionReadAccess.TimeOnly) {
                throw new ServiceLocalException(String.format(Strings.ReadAccessInvalidForNonCalendarFolder, new Object[]{this.readItems}));
            }
            if (this.permissionLevel == FolderPermissionLevel.FreeBusyTimeAndSubjectAndLocation || this.permissionLevel == FolderPermissionLevel.FreeBusyTimeOnly) {
                throw new ServiceLocalException(String.format(Strings.PermissionLevelInvalidForNonCalendarFolder, new Object[]{this.permissionLevel}));
            }
        }
    }

    public UserId getUserId() {
        return this.userId;
    }

    public void setUserId(UserId value) {
        if (this.userId != null) {
            this.userId.removeChangeEvent(this);
        }
        if (this.canSetFieldValue(this.userId, value)) {
            this.userId = value;
            this.changed();
        }
        if (this.userId != null) {
            this.userId.addOnChangeEvent(this);
        }
    }

    public void complexPropertyChanged(ComplexProperty complexProperty) {
        this.propertyChanged(complexProperty);
    }

    private void propertyChanged(ComplexProperty complexProperty) {
        this.changed();
    }

    public boolean getCanCreateItems() {
        return this.canCreateItems;
    }

    public void setCanCreateItems(boolean value) {
        if (this.canSetFieldValue(this.canCreateItems, value)) {
            this.canCreateItems = value;
            this.changed();
        }
        this.AdjustPermissionLevel();
    }

    public boolean getCanCreateSubFolders() {
        return this.canCreateSubFolders;
    }

    public void setCanCreateSubFolders(boolean value) {
        if (this.canSetFieldValue(this.canCreateSubFolders, value)) {
            this.canCreateSubFolders = value;
            this.changed();
        }
        this.AdjustPermissionLevel();
    }

    public boolean getIsFolderOwner() {
        return this.isFolderOwner;
    }

    public void setIsFolderOwner(boolean value) {
        if (this.canSetFieldValue(this.isFolderOwner, value)) {
            this.isFolderOwner = value;
            this.changed();
        }
        this.AdjustPermissionLevel();
    }

    public boolean getIsFolderVisible() {
        return this.isFolderVisible;
    }

    public void setIsFolderVisible(boolean value) {
        if (this.canSetFieldValue(this.isFolderVisible, value)) {
            this.isFolderVisible = value;
            this.changed();
        }
        this.AdjustPermissionLevel();
    }

    public boolean getIsFolderContact() {
        return this.isFolderContact;
    }

    public void setIsFolderContact(boolean value) {
        if (this.canSetFieldValue(this.isFolderContact, value)) {
            this.isFolderContact = value;
            this.changed();
        }
        this.AdjustPermissionLevel();
    }

    public PermissionScope getEditItems() {
        return this.editItems;
    }

    public void setEditItems(PermissionScope value) {
        if (this.canSetFieldValue(this.editItems, value)) {
            this.editItems = value;
            this.changed();
        }
        this.AdjustPermissionLevel();
    }

    public PermissionScope getDeleteItems() {
        return this.deleteItems;
    }

    public void setDeleteItems(PermissionScope value) {
        if (this.canSetFieldValue(this.deleteItems, value)) {
            this.deleteItems = value;
            this.changed();
        }
        this.AdjustPermissionLevel();
    }

    public FolderPermissionReadAccess getReadItems() {
        return this.readItems;
    }

    public void setReadItems(FolderPermissionReadAccess value) {
        if (this.canSetFieldValue(this.readItems, value)) {
            this.readItems = value;
            this.changed();
        }
        this.AdjustPermissionLevel();
    }

    public FolderPermissionLevel getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setPermissionLevel(FolderPermissionLevel value) throws ServiceLocalException {
        if (this.permissionLevel != value) {
            if (value == FolderPermissionLevel.Custom) {
                throw new ServiceLocalException(Strings.CannotSetPermissionLevelToCustom);
            }
            this.AssignIndividualPermissions(defaultPermissions.getMember().get((Object)value));
            if (this.canSetFieldValue(this.permissionLevel, value)) {
                this.permissionLevel = value;
                this.changed();
            }
        }
    }

    public FolderPermissionLevel getDisplayPermissionLevel() {
        if (this.permissionLevel == FolderPermissionLevel.Custom) {
            for (FolderPermission variant : levelVariants.getMember()) {
                if (!this.isEqualTo(variant)) continue;
                return variant.getPermissionLevel();
            }
        }
        return this.permissionLevel;
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("UserId")) {
            this.userId = new UserId();
            this.userId.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("CanCreateItems")) {
            this.canCreateItems = reader.readValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("CanCreateSubFolders")) {
            this.canCreateSubFolders = reader.readValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("IsFolderOwner")) {
            this.isFolderOwner = reader.readValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("IsFolderVisible")) {
            this.isFolderVisible = reader.readValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("IsFolderContact")) {
            this.isFolderContact = reader.readValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("EditItems")) {
            this.editItems = reader.readValue(PermissionScope.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("DeleteItems")) {
            this.deleteItems = reader.readValue(PermissionScope.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("ReadItems")) {
            this.readItems = reader.readValue(FolderPermissionReadAccess.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("PermissionLevel") || reader.getLocalName().equalsIgnoreCase("CalendarPermissionLevel")) {
            this.permissionLevel = reader.readValue(FolderPermissionLevel.class);
            return true;
        }
        return false;
    }

    protected void loadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        super.loadFromXml(reader, xmlNamespace, xmlElementName);
        this.AdjustPermissionLevel();
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer, boolean isCalendarFolder) throws Exception {
        if (this.userId != null) {
            this.userId.writeToXml(writer, "UserId");
        }
        if (this.permissionLevel == FolderPermissionLevel.Custom) {
            writer.writeElementValue(XmlNamespace.Types, "CanCreateItems", this.canCreateItems);
            writer.writeElementValue(XmlNamespace.Types, "CanCreateSubFolders", this.canCreateSubFolders);
            writer.writeElementValue(XmlNamespace.Types, "IsFolderOwner", this.isFolderOwner);
            writer.writeElementValue(XmlNamespace.Types, "IsFolderVisible", this.isFolderVisible);
            writer.writeElementValue(XmlNamespace.Types, "IsFolderContact", this.isFolderContact);
            writer.writeElementValue(XmlNamespace.Types, "EditItems", (Object)this.editItems);
            writer.writeElementValue(XmlNamespace.Types, "DeleteItems", (Object)this.deleteItems);
            writer.writeElementValue(XmlNamespace.Types, "ReadItems", (Object)this.readItems);
        }
        writer.writeElementValue(XmlNamespace.Types, isCalendarFolder ? "CalendarPermissionLevel" : "PermissionLevel", (Object)this.permissionLevel);
    }

    protected void writeToXml(EwsServiceXmlWriter writer, String xmlElementName, boolean isCalendarFolder) throws Exception {
        writer.writeStartElement(this.getNamespace(), xmlElementName);
        this.writeAttributesToXml(writer);
        this.writeElementsToXml(writer, isCalendarFolder);
        writer.writeEndElement();
    }
}

