/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class RulePredicateSizeRange
extends ComplexProperty {
    private Integer minimumSize;
    private Integer maximumSize;

    protected RulePredicateSizeRange() {
    }

    public Integer getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(Integer value) {
        if (this.canSetFieldValue(this.minimumSize, value)) {
            this.minimumSize = value;
            this.changed();
        }
    }

    public Integer getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Integer value) {
        if (this.canSetFieldValue(this.maximumSize, value)) {
            this.maximumSize = value;
            this.changed();
        }
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("MinimumSize")) {
            this.minimumSize = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("MaximumSize")) {
            this.maximumSize = reader.readElementValue(Integer.class);
            return true;
        }
        return false;
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        if (this.getMinimumSize() != null) {
            writer.writeElementValue(XmlNamespace.Types, "MinimumSize", this.getMinimumSize());
        }
        if (this.getMaximumSize() != null) {
            writer.writeElementValue(XmlNamespace.Types, "MaximumSize", this.getMaximumSize());
        }
    }

    protected void internalValidate() throws ServiceValidationException, Exception {
        super.internalValidate();
        if (this.minimumSize != null && this.maximumSize != null && this.minimumSize > this.maximumSize) {
            throw new ServiceValidationException("MinimumSize cannot be larger than MaximumSize.");
        }
    }
}

