/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceResponseCollection<TResponse extends ServiceResponse>
implements Iterable<TResponse> {
    private Vector<TResponse> responses = new Vector();
    private ServiceResult overallResult = ServiceResult.Success;

    protected ServiceResponseCollection() {
    }

    protected void add(TResponse response) {
        EwsUtilities.EwsAssert(response != null, "EwsResponseList.Add", "response is null");
        if (((ServiceResponse)response).getResult().ordinal() > this.overallResult.ordinal()) {
            this.overallResult = ((ServiceResponse)response).getResult();
        }
        this.responses.add(response);
    }

    public int getCount() {
        return this.responses.size();
    }

    public TResponse getResponseAtIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getCount()) {
            throw new IndexOutOfBoundsException("Index out of Range");
        }
        return (TResponse)((ServiceResponse)this.responses.get(index));
    }

    public ServiceResult getOverallResult() {
        return this.overallResult;
    }

    @Override
    public Iterator<TResponse> iterator() {
        return this.responses.iterator();
    }

    public Enumeration<TResponse> getEnumerator() {
        return this.responses.elements();
    }
}

