/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.test.mocks.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class MockServletResponse
extends HttpServletResponseWrapper {
    private PrintWriter tmpWriter;
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private ByteArrayServletOutputStream servletOutput;
    private Locale locale_;

    public MockServletResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.tmpWriter = new PrintWriter(this.output);
        this.servletOutput = new ByteArrayServletOutputStream(this.output);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.servletOutput.close();
        this.output.close();
        this.tmpWriter.close();
    }

    public String getPortletContent() {
        String s = this.output.toString();
        this.reset();
        return s;
    }

    public byte[] toByteArray() {
        return this.output.toByteArray();
    }

    public String getOutputContent() {
        return new String(this.output.toByteArray());
    }

    public void flushBuffer() throws IOException {
        this.tmpWriter.flush();
        this.servletOutput.flush();
    }

    public void reset() {
        this.output.reset();
    }

    public void close() throws IOException {
        this.tmpWriter.close();
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public void setLocale(Locale loc) {
        this.locale_ = loc;
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        public ByteArrayServletOutputStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int i) throws IOException {
            this.baos.write(i);
        }
    }
}

