/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.mojo;

import com.jayway.restassured.RestAssured;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.exoplatform.crowdin.model.CrowdinFileFactory;
import org.exoplatform.crowdin.model.CrowdinTranslation;
import org.exoplatform.crowdin.utils.CrowdinAPIHelper;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractCrowdinMojo
extends AbstractMojo {
    public static final String DEFAULT_TRANSLATIONS_REGISTRY_FILE_PATH = "translations.properties";
    protected File crowdInArchive;
    @Parameter(property="workingDir", defaultValue="${project.basedir}")
    private File workingDir;
    @Parameter(property="dryRun", defaultValue="false")
    private boolean dryRun;
    @Parameter(property="force", defaultValue="false")
    private boolean force;
    @Parameter(property="exo.crowdin.translationsArchivePath", defaultValue="${project.build.directory}/translations.zip")
    private String translationsArchivePath;
    @Parameter(property="langs", defaultValue="all")
    private List<String> languages;
    @Parameter(property="exo.crowdin.translationsRegistryFilePath")
    private String translationsRegistryFilePath;
    @Parameter(property="apply_approved_only", defaultValue="true")
    private String apply_approved_only;
    @Parameter(property="exo.crowdin.project.id", required=true)
    private String projectId;
    @Parameter(property="exo.crowdin.project.key", required=true)
    private String projectKey;
    @Parameter(property="exo.crowdin.ignore")
    private String ignore;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    private Properties properties;
    private Properties ignoredFiles;
    private CrowdinFileFactory factory;
    private CrowdinAPIHelper helper;
    private String downloadDate = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.factory = new CrowdinFileFactory(this);
        this.helper = new CrowdinAPIHelper(this);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("*** RestAssured Base URI: " + RestAssured.baseURI));
            this.getLog().debug((CharSequence)("*** RestAssured Port: " + RestAssured.port));
            this.getLog().debug((CharSequence)("*** RestAssured Base Path: " + RestAssured.basePath));
            this.getLog().debug((CharSequence)("*** RestAssured Request URI: " + RestAssured.baseURI + ":" + RestAssured.port + RestAssured.basePath));
            this.getLog().debug((CharSequence)("*** Current Working Directory: " + this.workingDir));
        }
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"*** Loading the properties file (translations.properties)...");
            }
            this.properties = this.loadProperties(new File(this.getProject().getBasedir(), DEFAULT_TRANSLATIONS_REGISTRY_FILE_PATH).getAbsolutePath());
            if (this.properties == null) {
                this.getLog().info((CharSequence)"No translations.properties file -> skipped");
                return;
            }
            if (this.ignore != null) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("*** Loading the ignored files list (" + this.ignore + ")..."));
                }
                this.ignoredFiles = this.loadProperties(this.ignore);
            }
        }
        catch (IOException e) {
            this.getLog().info((CharSequence)"No translations.properties file -> skipped");
            return;
        }
        File buildDir = new File(this.getProject().getBuild().getDirectory());
        buildDir.mkdirs();
        this.crowdInArchive = new File(this.getTranslationsArchivePath());
        this.crowdInMojoExecute();
    }

    protected Properties loadProperties(String _propertiesFile) throws IOException {
        Properties res = new Properties();
        FileInputStream in = new FileInputStream(_propertiesFile);
        res.load(in);
        ((InputStream)in).close();
        return res;
    }

    public abstract void crowdInMojoExecute() throws MojoExecutionException, MojoFailureException;

    public File getWorkingDir() {
        if (!this.workingDir.exists()) {
            this.workingDir.mkdirs();
        }
        return this.workingDir;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isForce() {
        return this.force;
    }

    public CrowdinAPIHelper getHelper() {
        return this.helper;
    }

    public CrowdinFileFactory getFactory() {
        return this.factory;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getTranslationsArchivePath() {
        return this.translationsArchivePath;
    }

    public void setTranslationsArchivePath(String translationsArchivePath) {
        this.translationsArchivePath = translationsArchivePath;
    }

    public String getTranslationsRegistryFilePath() {
        if (StringUtils.isEmpty((String)this.translationsRegistryFilePath)) {
            return DEFAULT_TRANSLATIONS_REGISTRY_FILE_PATH;
        }
        return this.translationsRegistryFilePath;
    }

    public void setTranslationsRegistryFilePath(String translationsRegistryFilePath) {
        this.translationsRegistryFilePath = translationsRegistryFilePath;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getApplyApprovedOnlyOption() {
        if ("true".equals(this.apply_approved_only)) {
            return "1";
        }
        return "0";
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public BuildPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected void initDir(String _filePath) {
        _filePath = _filePath.substring(0, _filePath.lastIndexOf(47));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("*** Check if directories exist: " + _filePath));
        }
        String[] path = _filePath.split("/");
        StringBuffer pathFromBeginning = new StringBuffer();
        for (String string : path) {
            pathFromBeginning.append(string);
            try {
                if (!this.getHelper().elementExists(pathFromBeginning.toString())) {
                    String result;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("*** Create directory: " + pathFromBeginning.toString()));
                    }
                    if ((result = this.getHelper().addDirectory(pathFromBeginning.toString())).contains("success")) {
                        this.getLog().info((CharSequence)("Directory '" + pathFromBeginning.toString() + "' created succesfully."));
                    } else {
                        this.getLog().warn((CharSequence)("Cannot create directory '" + _filePath + "'. Reason:\n" + result));
                    }
                }
            }
            catch (MojoExecutionException e) {
                this.getLog().error((CharSequence)("Error while creating directory '" + _filePath + "'. Exception:\n" + e.getMessage()));
            }
            pathFromBeginning.append("/");
        }
    }

    protected boolean isAllPropertyFilesExisted() {
        boolean existed = true;
        this.getLog().info((CharSequence)"Checking property files... ");
        Properties projectTranslationsProperties = this.getProperties();
        Set<Object> files = projectTranslationsProperties.keySet();
        for (Object file : files) {
            String filePath;
            File f;
            if (file.equals("baseDir") || (f = new File(filePath = this.getWorkingDir() + File.separator + projectTranslationsProperties.getProperty(file.toString()))).exists()) continue;
            existed = false;
            this.getLog().warn((CharSequence)("File not found: " + filePath));
        }
        this.getLog().info((CharSequence)"Checking done.");
        return existed;
    }

    /*
     * WARNING - void declaration
     */
    protected void initTranslations(CrowdinFile _master) {
        File dir = _master.getFile().getParentFile();
        String masterFileName = _master.getFile().getName();
        if (_master.isShouldBeCleaned()) {
            _master.getFile().delete();
        }
        List<Object> files = new ArrayList();
        List<String> languagesToProcess = this.getLanguages();
        if (dir.getPath().contains("android") || dir.getPath().contains("ios")) {
            if (languagesToProcess.contains("en")) {
                languagesToProcess.remove("en");
            }
            for (int i = 0; i < languagesToProcess.size(); ++i) {
                void var7_9;
                String localizable;
                String string = "";
                if (dir.getPath().contains("android")) {
                    localizable = CrowdinTranslation.encodeAndroidLocale(languagesToProcess.get(i));
                    String string2 = dir.getPath().replaceAll("values", "values-" + localizable);
                } else if (dir.getPath().contains("ios")) {
                    localizable = CrowdinTranslation.encodeIOSLocale(languagesToProcess.get(i));
                    String string3 = dir.getPath().replaceAll("en.lproj", localizable + ".lproj");
                }
                File fileToAdd = new File((String)var7_9 + File.separator + masterFileName);
                if (!fileToAdd.exists()) continue;
                files.add(fileToAdd);
            }
        } else {
            File[] filesArray = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (dir.getPath().contains("gadget") && !dir.getPath().contains("GadgetPortlet")) {
                        return true;
                    }
                    if (dir.getPath().contains("workflow") && name.indexOf(".xml") > 0) {
                        return false;
                    }
                    if (dir.getPath().contains("web/portal") && (name.equals("expression_en.xml") || name.equals("expression_it.xml") || name.equals("services_en.xml") || name.equals("services_it.xml"))) {
                        return false;
                    }
                    if (AbstractCrowdinMojo.this.ignoredFiles != null) {
                        String filePath = dir.getPath() + "/" + name;
                        for (Object key : AbstractCrowdinMojo.this.ignoredFiles.keySet()) {
                            if (filePath.indexOf((String)key) < 0) continue;
                            return false;
                        }
                    }
                    return AbstractCrowdinMojo.this.getFactory().isTranslation(name);
                }
            });
            files = Arrays.asList(filesArray);
        }
        for (File file : files) {
            String mName;
            String transName = file.getName();
            Matcher matcher = this.getFactory().matchTranslation(masterFileName);
            String masterName = matcher.matches() ? matcher.group(1) : masterFileName.substring(0, masterFileName.lastIndexOf(46));
            String tName = transName.substring(0, transName.lastIndexOf(46));
            if (!tName.equalsIgnoreCase(mName = masterFileName.substring(0, masterFileName.lastIndexOf(46))) && (transName.indexOf(masterName) == 0 && transName.indexOf(masterName + "-") < 0 || file.getPath().contains("gadget"))) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("*** Initializing: " + transName));
                }
                this.prepareAndUploadTranslation(transName, _master, file);
                continue;
            }
            if (!dir.getPath().contains("android") && !dir.getPath().contains("ios")) continue;
            this.prepareAndUploadTranslation(transName, _master, file);
        }
    }

    private void prepareAndUploadTranslation(String transName, CrowdinFile _master, File file) {
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("*** Upload translation: " + transName + "\n\t***** for master: " + _master.getName()));
            }
            CrowdinTranslation cTran = this.getFactory().prepareCrowdinTranslation(_master, file);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"=============================================================================");
                this.getLog().debug((CharSequence)this.printFileContent(cTran.getFile()));
                this.getLog().debug((CharSequence)"=============================================================================");
            }
            if (!this.getLanguages().contains(cTran.getLang())) {
                this.getLog().warn((CharSequence)("Language " + cTran.getLang() + " is not configured to be processed"));
                if (cTran.isShouldBeCleaned()) {
                    cTran.getFile().delete();
                }
                return;
            }
            String result = this.getHelper().uploadTranslation(cTran);
            this.getLog().info((CharSequence)("*** Upload translation: " + transName + "\n\t***** for master: " + _master.getName()));
            if (result.contains("success")) {
                this.getLog().info((CharSequence)("Translation '" + transName + "' added succesfully."));
            } else {
                this.getLog().warn((CharSequence)("Cannot upload translation '" + file.getPath() + " with lang '" + cTran.getLang() + "'. Reason:\n" + result));
            }
            if (cTran.isShouldBeCleaned()) {
                cTran.getFile().delete();
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Error while adding translation '" + file.getPath() + "'. Exception:\n" + e.getMessage()));
        }
    }

    protected String printFileContent(File file) {
        try {
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            char[] characters = new char[(int)file.length()];
            r.read(characters);
            return new String(characters);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Unable to print file content", (Throwable)e);
            return null;
        }
    }

    protected void execGit(File workingDirectory, String params) throws MojoExecutionException, MojoFailureException {
        this.execGit(workingDirectory, params, MojoExecutor.element((String)"successCode", (String)"0"));
    }

    protected void execGit(File workingDirectory, String params, MojoExecutor.Element ... successCodes) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Running : git " + params));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"exec-maven-plugin"), (String)MojoExecutor.version((String)"1.2.1")), (String)MojoExecutor.goal((String)"exec"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"executable"), (String)"/bin/sh"), MojoExecutor.element((String)MojoExecutor.name((String)"commandlineArgs"), (String)("-c \"(cd " + workingDirectory.getAbsolutePath() + " && exec git " + params + ")\"")), MojoExecutor.element((String)MojoExecutor.name((String)"workingDirectory"), (String)workingDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"successCodes"), (MojoExecutor.Element[])successCodes)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.getProject(), (MavenSession)this.getMavenSession(), (BuildPluginManager)this.getPluginManager()));
    }
}

