/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.mojo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.exoplatform.crowdin.model.CrowdinFileFactory;
import org.exoplatform.crowdin.model.CrowdinTranslation;
import org.exoplatform.crowdin.mojo.AbstractCrowdinMojo;

@Mojo(name="restore-translation")
public class RestoreTranslationMojo
extends AbstractCrowdinMojo {
    private static String ZIP_DIR;
    private static String ZIP_FILE;
    @Parameter(property="prepare", defaultValue="false")
    private boolean isPrepare;
    @Parameter(property="continue", defaultValue="false")
    private boolean isContinue;
    @Parameter(property="action", defaultValue="uploadTranslations")
    private String action;

    @Override
    public void crowdInMojoExecute() throws MojoExecutionException, MojoFailureException {
        try {
            File zip = new File("crowdin-zip/all.zip");
            if (!zip.exists()) {
                this.getLog().warn((CharSequence)"Crowdin translation zip (../crowdin-zip/all.zip) not found. Nothing to do");
                return;
            }
            ZIP_FILE = zip.getAbsolutePath();
            ZIP_DIR = ZIP_FILE.substring(0, ZIP_FILE.lastIndexOf(".zip")) + "/";
            if (!this.isContinue) {
                this.deleteDir(new File(ZIP_DIR));
                this.extractZip();
                this.getLog().info((CharSequence)"Crowdin translation folder (../crowdin-zip/all/) is ready.");
                if (this.isPrepare) {
                    this.getLog().info((CharSequence)"Please make the necessary modification then continue by running with '-Dcontinue=true'");
                }
            } else if (!new File(ZIP_DIR).exists()) {
                this.getLog().warn((CharSequence)"Crowdin translation folder (../crowdin-zip/all/) not found. Nothing to do");
                return;
            }
            if (!this.isPrepare) {
                File[] list;
                if ("createProject".equals(this.action)) {
                    this.getLog().info((CharSequence)"*** Creating Crowdin project's directory structure...");
                    this.dir2crowdin(ZIP_DIR + "en/");
                    return;
                }
                this.getLog().info((CharSequence)"*** Uploading translations...");
                for (File file : list = new File(ZIP_DIR).listFiles()) {
                    if (!file.isDirectory()) continue;
                    String lang = file.getAbsolutePath().replace(ZIP_DIR, "");
                    this.getLog().info((CharSequence)("*** Uploading " + lang + "..."));
                    this.trans2crowdin(ZIP_DIR + "/" + lang + "/", lang);
                }
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Exception when running restore-translation: " + e.getMessage()), (Throwable)e);
        }
    }

    private void dir2crowdin(String dirPath) throws Exception {
        File[] list;
        File root = new File(dirPath);
        for (File file : list = root.listFiles()) {
            String crowdinPath = file.getAbsolutePath().replace(ZIP_DIR + "en/", "");
            if (file.isDirectory()) {
                String ret = this.getHelper().addDirectory(crowdinPath);
                if (ret.contains("success")) {
                    this.getLog().info((CharSequence)("Creating folder: " + crowdinPath + " [successed]"));
                } else {
                    this.getLog().warn((CharSequence)("Creating folder: " + crowdinPath + " [FAILED]"));
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)ret);
                    }
                }
                this.dir2crowdin(file.getAbsolutePath());
                continue;
            }
            CrowdinFile cf = this.getFactory().prepareCrowdinFile(file.getAbsolutePath(), crowdinPath.substring(crowdinPath.lastIndexOf(File.separatorChar)), dirPath.replace(ZIP_DIR + "en/", ""));
            String ret = this.getHelper().addFile(cf);
            if (ret.contains("success")) {
                this.getLog().info((CharSequence)("Adding file:   " + crowdinPath + " [successed]"));
                continue;
            }
            this.getLog().warn((CharSequence)("Adding file:   " + crowdinPath + " [FAILED]"));
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)ret);
        }
    }

    private void trans2crowdin(String dirPath, String lang) throws Exception {
        File[] list;
        File root = new File(dirPath);
        for (File file : list = root.listFiles()) {
            String crowdinPath = file.getAbsolutePath().replace(ZIP_DIR + lang + "/", "");
            if (file.isDirectory()) {
                this.trans2crowdin(file.getAbsolutePath(), lang);
                continue;
            }
            CrowdinFile master = this.getFactory().prepareCrowdinFile(file.getAbsolutePath(), crowdinPath.substring(crowdinPath.lastIndexOf(File.separatorChar)), dirPath.replace(ZIP_DIR + lang + "/", ""));
            CrowdinTranslation cTran = new CrowdinTranslation(file, crowdinPath.substring(crowdinPath.lastIndexOf(File.separatorChar)), master.getType(), master.getProject(), lang, master, false);
            String ret = this.getHelper().uploadTranslation(cTran, false);
            if (ret.contains("success")) {
                this.getLog().info((CharSequence)("Uploading translation: " + crowdinPath + " [successed]"));
                continue;
            }
            this.getLog().warn((CharSequence)("Uploading translation: " + crowdinPath + " [FAILED]"));
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)ret);
        }
    }

    private void extractZip() throws Exception {
        byte[] buf = new byte[1024];
        ZipInputStream zipinputstream = null;
        zipinputstream = new ZipInputStream(new FileInputStream(ZIP_FILE));
        ZipEntry zipentry = zipinputstream.getNextEntry();
        while (zipentry != null) {
            int n;
            if (zipentry.isDirectory()) {
                zipentry = zipinputstream.getNextEntry();
                continue;
            }
            String tmp = zipentry.getName();
            tmp = CrowdinFileFactory.encodeMinusCharacterInPath(tmp, false);
            tmp = tmp.replace('/', File.separatorChar);
            tmp = tmp.replace('\\', File.separatorChar);
            String[] path = tmp.split(File.separator);
            Properties currentProj = this.getProperties();
            if (currentProj == null) {
                zipentry = zipinputstream.getNextEntry();
                continue;
            }
            String zipentryName = ZIP_DIR + zipentry.getName();
            File newFile = new File(zipentryName.substring(0, zipentryName.lastIndexOf(File.separatorChar)));
            newFile.mkdirs();
            FileOutputStream fileoutputstream = new FileOutputStream(zipentryName);
            while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                fileoutputstream.write(buf, 0, n);
            }
            fileoutputstream.close();
            this.deleteFirstLine(zipentryName);
            zipinputstream.closeEntry();
            zipentry = zipinputstream.getNextEntry();
        }
        zipinputstream.close();
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private void deleteFirstLine(String filePath) throws Exception {
        String temp;
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), "UTF-8"));
        in.readLine();
        while ((temp = in.readLine()) != null) {
            sb.append(temp).append("\n");
        }
        in.close();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filePath)), "UTF-8"));
        out.write(sb.toString());
        out.close();
    }
}

