/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.mojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.exoplatform.crowdin.model.CrowdinFileFactory;
import org.exoplatform.crowdin.model.CrowdinTranslation;
import org.exoplatform.crowdin.mojo.AbstractCrowdinMojo;
import org.exoplatform.crowdin.utils.FileUtils;
import org.exoplatform.crowdin.utils.IOSResouceBundleFileUtils;
import org.exoplatform.crowdin.utils.PropsToXML;
import org.exoplatform.crowdin.utils.XMLResourceBundleUtils;

@Mojo(name="update-sources")
public class UpdateSourcesMojo
extends AbstractCrowdinMojo {
    @Override
    public void crowdInMojoExecute() throws MojoExecutionException, MojoFailureException {
        List<Object> languagesToProcess = new ArrayList();
        languagesToProcess = this.getLanguages().contains("all") ? this.getLanguagesListFromCrowdInArchive(this.crowdInArchive) : this.getLanguages();
        if (languagesToProcess == null || languagesToProcess.isEmpty()) {
            this.getLog().info((CharSequence)"No language to process");
        }
        String currentDate = new SimpleDateFormat("yyyyMMdd-HHmmss").format(Calendar.getInstance().getTime());
        for (String string : languagesToProcess) {
            this.getLog().info((CharSequence)("Updates for locale " + string));
            this.applyTranslations(this.getWorkingDir(), this.crowdInArchive.getPath(), string);
            try {
                File localVersionRepository = this.getWorkingDir();
                this.getLog().info((CharSequence)"Extract/Apply/Commit/Push changes");
                this.getLog().info((CharSequence)"Check changes...");
                File statusFile = new File(this.getProject().getBuild().getDirectory(), "translations-" + string + ".status");
                this.execGit(localVersionRepository, "status -s > " + statusFile.getAbsolutePath());
                this.getLog().info((CharSequence)"Done.");
                BufferedReader br = new BufferedReader(new FileReader(statusFile));
                if (br.readLine() == null) {
                    this.getLog().info((CharSequence)("No change for locale " + string + " from crowdin extract done on " + currentDate));
                    continue;
                }
                this.execGit(localVersionRepository, "add .");
                this.getLog().info((CharSequence)"Commit changes...");
                this.execGit(localVersionRepository, "commit -a -m '" + string + " injection on " + currentDate + "'");
                this.getLog().info((CharSequence)"Done.");
                if (this.isDryRun()) continue;
                this.getLog().info((CharSequence)"Pushing changes...");
                this.execGit(localVersionRepository, "push origin HEAD");
                this.getLog().info((CharSequence)"Done.");
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error while updating project", e);
            }
        }
    }

    private List<String> getLanguagesListFromCrowdInArchive(File zip) {
        ArrayList<String> languagesToProcess = new ArrayList<String>();
        try {
            ZipInputStream zipinputstream = new ZipInputStream(new FileInputStream(zip));
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                if (zipentry.isDirectory()) {
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                String zipentryName = zipentry.getName();
                zipentryName = CrowdinFileFactory.encodeMinusCharacterInPath(zipentryName, false);
                zipentryName = zipentryName.replace('/', File.separatorChar);
                String[] path = (zipentryName = zipentryName.replace('\\', File.separatorChar)).split(File.separator);
                if (!languagesToProcess.contains(path[0])) {
                    languagesToProcess.add(path[0]);
                }
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Update aborted !", (Throwable)e);
        }
        return languagesToProcess;
    }

    private void applyTranslations(File _destFolder, String _zipFile, String locale) throws MojoExecutionException {
        ZipInputStream zipinputstream = null;
        try {
            zipinputstream = new ZipInputStream(new FileInputStream(_zipFile));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Cannot found translations archive file at " + _zipFile + " - Update Aborted.", (Exception)e);
        }
        try {
            Properties currentProj = this.getProperties();
            if (currentProj == null) {
                return;
            }
            locale = CrowdinTranslation.getPlatformLangFromCrowdinLang(locale);
            String baseDir = currentProj.getProperty("baseDir");
            byte[] buf = new byte[1024];
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                if (zipentry.isDirectory()) {
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                String zipentryName = zipentry.getName();
                this.getLog().debug((CharSequence)("Processing : " + zipentryName));
                zipentryName = CrowdinFileFactory.encodeMinusCharacterInPath(zipentryName, false);
                zipentryName = zipentryName.replace('/', File.separatorChar);
                zipentryName = zipentryName.replace('\\', File.separatorChar);
                String[] path = zipentryName.split(File.separator);
                String lang = CrowdinTranslation.getPlatformLangFromCrowdinLang(path[0]);
                String fileName = "";
                String cp = "";
                String proj = "";
                for (int i = 1; i < path.length; ++i) {
                    cp = cp + path[i] + File.separator;
                    if (i != path.length - 1) continue;
                    proj = path[i];
                }
                this.getLog().debug((CharSequence)("cp : " + cp));
                if (!lang.equalsIgnoreCase(locale)) {
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                if (StringUtils.isEmpty((String)baseDir) || !cp.equals(baseDir)) {
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                try {
                    String localizable;
                    boolean isXML;
                    String localizable2;
                    String key = zipentryName.substring(zipentryName.indexOf(cp) + cp.length());
                    String value = currentProj.getProperty(key);
                    if (value == null) {
                        zipentry = zipinputstream.getNextEntry();
                        continue;
                    }
                    if (zipentryName.contains("android")) {
                        if (!locale.contains("en")) {
                            localizable2 = CrowdinTranslation.encodeAndroidLocale(locale);
                            value = value.replace("res/values/", "res/values-" + localizable2 + "/");
                        }
                    } else if (zipentryName.contains("ios") && !locale.contains("en")) {
                        localizable2 = CrowdinTranslation.encodeIOSLocale(locale);
                        value = value.replace("en.lproj", localizable2 + ".lproj");
                    }
                    zipentryName = zipentryName.substring(0, zipentryName.indexOf(proj) + proj.length());
                    lang = CrowdinTranslation.encodeLanguageName(lang, false);
                    fileName = value.substring(value.lastIndexOf(File.separatorChar) + 1);
                    this.getLog().info((CharSequence)("Updating " + zipentryName + " - " + value.substring(0, value.lastIndexOf(File.separatorChar) + 1) + fileName));
                    String name = fileName.substring(0, fileName.lastIndexOf("."));
                    String extension = fileName.substring(fileName.lastIndexOf("."));
                    if (name.lastIndexOf("_en") > 0) {
                        name = name.substring(0, name.lastIndexOf("_en"));
                    }
                    fileName = key.contains("gadget") || value.contains("gadget") ? ("default".equalsIgnoreCase(name) ? lang + extension : (name.contains("_ALL") ? lang + "_ALL" + extension : name + "_" + lang + extension)) : (zipentryName.contains("android") ? name + ".xml" : (zipentryName.contains("ios") ? name + extension : name + "_" + lang + extension));
                    String parentDir = _destFolder + File.separator + value.substring(0, value.lastIndexOf(File.separatorChar) + 1);
                    this.getLog().debug((CharSequence)("parentDir : " + parentDir));
                    parentDir = parentDir.replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    String entryName = parentDir + fileName;
                    CrowdinFile.Type resourceBundleType = key.indexOf("gadget") >= 0 ? CrowdinFile.Type.GADGET : CrowdinFile.Type.PORTLET;
                    File newFile = new File(entryName.substring(0, entryName.lastIndexOf(File.separatorChar)));
                    newFile.mkdirs();
                    boolean bl = isXML = entryName.indexOf(".xml") > 0;
                    if (isXML) {
                        if (zipentryName.contains("mobile") && zipentryName.contains("android")) {
                            int n;
                            String resourceTranslationFilePath = parentDir + name + extension;
                            localizable = CrowdinTranslation.encodeAndroidLocale(locale);
                            String masterFilePath = resourceTranslationFilePath.replaceAll("res/values-" + localizable, "res/values");
                            FileOutputStream fileoutputstream = new FileOutputStream(resourceTranslationFilePath + ".ziptempo");
                            while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                                fileoutputstream.write(buf, 0, n);
                            }
                            fileoutputstream.close();
                            String crowdinFilePath = resourceTranslationFilePath + ".ziptempo";
                            FileInputStream input = new FileInputStream(crowdinFilePath);
                            XMLResourceBundleUtils.setLog(this.getLog());
                            XMLResourceBundleUtils.injectTranslation(input, resourceTranslationFilePath, masterFilePath);
                            try {
                                File file = new File(crowdinFilePath);
                                if (file.delete()) {
                                    if (this.getLog().isDebugEnabled()) {
                                        this.getLog().debug((CharSequence)(file.getName() + " is deleted!"));
                                    }
                                } else if (this.getLog().isDebugEnabled()) {
                                    this.getLog().debug((CharSequence)"Delete operation is failed.");
                                }
                            }
                            catch (Exception e) {
                                this.getLog().error((Throwable)e);
                            }
                        } else {
                            int n;
                            if (!zipentryName.contains("mobile")) {
                                entryName = entryName.replaceAll(".xml", ".properties");
                            }
                            FileOutputStream fileoutputstream = new FileOutputStream(entryName);
                            while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                                fileoutputstream.write(buf, 0, n);
                            }
                            fileoutputstream.close();
                            File propertiesFile = new File(entryName);
                            if (!zipentryName.contains("mobile")) {
                                PropsToXML.execShellCommand("native2ascii -encoding UTF8 " + propertiesFile.getPath() + " " + propertiesFile.getPath());
                            }
                            PropsToXML.parse(propertiesFile.getPath(), resourceBundleType);
                            propertiesFile.delete();
                        }
                    } else if (zipentryName.contains("ios")) {
                        int n;
                        String localFile = parentDir + name + extension;
                        localizable = CrowdinTranslation.encodeIOSLocale(locale);
                        String masterFile = localFile.replace(localizable + ".lproj", "en.lproj");
                        String resourceTranslationFilePath = localFile;
                        FileOutputStream fileoutputstream = new FileOutputStream(resourceTranslationFilePath + ".ziptempo");
                        while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                            fileoutputstream.write(buf, 0, n);
                        }
                        fileoutputstream.close();
                        String crowdinFilePath = resourceTranslationFilePath + ".ziptempo";
                        String resourceMasterFilePath = masterFile;
                        IOSResouceBundleFileUtils.setLog(this.getLog());
                        IOSResouceBundleFileUtils.injectTranslation(crowdinFilePath, resourceMasterFilePath, resourceTranslationFilePath);
                    } else {
                        String masterFile = parentDir + name + extension;
                        if (!new File(masterFile).exists()) {
                            masterFile = parentDir + name + "_en" + extension;
                        }
                        if (!new File(masterFile).exists()) {
                            throw new FileNotFoundException("Cannot create or update " + entryName + " as the master file " + name + extension + " (or " + name + "_en" + extension + ") does not exist!");
                        }
                        PropertiesConfiguration config = new PropertiesConfiguration(masterFile);
                        PropertiesConfiguration.setDefaultListDelimiter((char)'=');
                        config.setEncoding("UTF-8");
                        Properties propsCrowdin = new Properties();
                        propsCrowdin.load(zipinputstream);
                        Properties props = new Properties();
                        props.load(new FileInputStream(new File(masterFile)));
                        Enumeration<?> e = props.propertyNames();
                        while (e.hasMoreElements()) {
                            String propKey = (String)e.nextElement();
                            String crowdinValue = propsCrowdin.getProperty(propKey);
                            if (null == crowdinValue || crowdinValue.length() <= 0) continue;
                            config.setProperty(propKey, (Object)crowdinValue);
                        }
                        if ("en".equals(lang)) {
                            config.save(masterFile);
                            FileUtils.replaceCharactersInFile(masterFile, "config/special_character_processing.properties", "UpdateSourceSpecialCharacters");
                            if (new File(entryName).exists()) {
                                config.save(entryName);
                                FileUtils.replaceCharactersInFile(entryName, "config/special_character_processing.properties", "UpdateSourceSpecialCharacters");
                            }
                        } else {
                            config.save(entryName);
                            FileUtils.replaceCharactersInFile(entryName, "config/special_character_processing.properties", "UpdateSourceSpecialCharacters");
                        }
                    }
                    zipinputstream.closeEntry();
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Error while applying change for " + zipentryName + " - " + fileName + " : " + e.getMessage()));
                }
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Update aborted !", (Throwable)e);
        }
    }
}

