/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.utils;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.path.xml.XmlPath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.exoplatform.crowdin.model.CrowdinTranslation;
import org.exoplatform.crowdin.mojo.AbstractCrowdinMojo;

public class CrowdinAPIHelper {
    private String projectId;
    private String projectKey;
    private AbstractCrowdinMojo currentMojo;

    public CrowdinAPIHelper(AbstractCrowdinMojo _mojo) {
        this.projectId = _mojo.getProjectId();
        this.projectKey = _mojo.getProjectKey();
        RestAssured.baseURI = "https://api.crowdin.com";
        RestAssured.port = 80;
        RestAssured.basePath = "/api/project/" + this.projectId;
        this.currentMojo = _mojo;
    }

    public String addDirectory(String _dirName) throws MojoExecutionException {
        if (this.currentMojo.isDryRun()) {
            this.currentMojo.getLog().info((CharSequence)("Adding directory '" + _dirName + "' in Dry Run mode..."));
            if (this.currentMojo.getLog().isDebugEnabled()) {
                this.currentMojo.getLog().debug((CharSequence)("*** Real mode would execute:\ngiven().multiPart(\"name\", " + _dirName + ").post(\"/add-directory?key=" + this.projectKey + ").andReturn().asString();"));
            }
            return "<dryRun success/>";
        }
        return RestAssured.given().multiPart("name", _dirName).post("/add-directory?key=" + this.projectKey, new Object[0]).andReturn().asString();
    }

    public String addFile(CrowdinFile _file) throws MojoExecutionException {
        if (this.currentMojo.isDryRun()) {
            this.currentMojo.getLog().info((CharSequence)("Adding file '" + _file.getFile().getName() + "' in Dry Run mode..."));
            if (this.currentMojo.getLog().isDebugEnabled()) {
                this.currentMojo.getLog().debug((CharSequence)("*** Real mode would execute:\ngiven().multiPart(\"type\", " + _file.getType() + ").multiPart(\"files[\"" + _file.getCrowdinPath() + "\"]\", " + _file.getFile().getName() + ").post(\"/add-file?key=" + this.projectKey + ").andReturn().asString();"));
            }
            return "<dryRun success/>";
        }
        if (_file.getProject().contains("android")) {
            return RestAssured.given().multiPart("type", "android").multiPart("files[" + _file.getCrowdinPath() + "]", _file.getFile()).post("/add-file?key=" + this.projectKey, new Object[0]).andReturn().asString();
        }
        if (_file.getProject().contains("ios")) {
            return RestAssured.given().multiPart("type", "macosx").multiPart("files[" + _file.getCrowdinPath() + "]", _file.getFile()).post("/add-file?key=" + this.projectKey, new Object[0]).andReturn().asString();
        }
        return RestAssured.given().multiPart("type", _file.getType()).multiPart("files[" + _file.getCrowdinPath() + "]", _file.getFile()).post("/add-file?key=" + this.projectKey, new Object[0]).andReturn().asString();
    }

    public String deleteFile(CrowdinFile _file) throws MojoExecutionException {
        if (this.currentMojo.isDryRun()) {
            this.currentMojo.getLog().info((CharSequence)("Deleting file '" + _file.getFile().getName() + "' in Dry Run mode..."));
            if (this.currentMojo.getLog().isDebugEnabled()) {
                this.currentMojo.getLog().debug((CharSequence)("*** Real mode would execute:\ngiven().multiPart(\"file\", " + _file.getCrowdinPath() + ").post(\"/delete-file?key=" + this.projectKey + ").andReturn().asString();"));
            }
            return "<dryRun success/>";
        }
        return RestAssured.given().multiPart("file", _file.getCrowdinPath()).post("/delete-file?key=" + this.projectKey, new Object[0]).andReturn().asString();
    }

    public boolean elementExists(String _eltPath) throws MojoExecutionException {
        String fileName;
        if (this.currentMojo.isDryRun()) {
            return false;
        }
        String infos = this.getProjectInfo();
        String[] pathElement = _eltPath.split("/");
        StringBuffer xmlPathStr = new StringBuffer("info");
        for (String elt : pathElement) {
            xmlPathStr.append(".files.item.find {it.name == '" + elt + "'}");
        }
        if (this.currentMojo.getLog().isDebugEnabled()) {
            this.currentMojo.getLog().debug((CharSequence)("*** XMLPath: " + xmlPathStr.toString()));
        }
        return (fileName = XmlPath.from((String)infos).get(xmlPathStr.toString()).toString()).length() > 0;
    }

    public String updateFile(CrowdinFile _file) throws MojoExecutionException {
        if (this.currentMojo.isDryRun()) {
            this.currentMojo.getLog().info((CharSequence)("Updating file '" + _file.getFile().getName() + "' in Dry Run mode..."));
            if (this.currentMojo.getLog().isDebugEnabled()) {
                this.currentMojo.getLog().debug((CharSequence)("*** Real mode would execute:\ngiven().multiPart(\"files[\"" + _file.getCrowdinPath() + "\"]\", " + _file.getFile().getName() + ").multiPart(\"update_option\", \"update_as_unapproved\").post(\"/update-file?key=" + this.projectKey + ").andReturn().asString();"));
            }
            return "<dryRun success/>";
        }
        return RestAssured.given().multiPart("files[" + _file.getCrowdinPath() + "]", _file.getFile()).multiPart("update_option", "update_as_unapproved").post("/update-file?key=" + this.projectKey, new Object[0]).andReturn().asString();
    }

    public String uploadTranslation(CrowdinTranslation _file, boolean autoApprovedImported) throws MojoExecutionException {
        String autoApprovedImportedParam;
        String string = autoApprovedImportedParam = autoApprovedImported ? "1" : "0";
        if (this.currentMojo.isDryRun()) {
            this.currentMojo.getLog().info((CharSequence)("Uploading translation '" + _file.getFile().getName() + "' in Dry Run mode..."));
            if (this.currentMojo.getLog().isDebugEnabled()) {
                this.currentMojo.getLog().debug((CharSequence)("*** Real mode would execute:\ngiven().multiPart(\"language\", " + _file.getLang() + ").multiPart(\"auto_approve_imported\", " + autoApprovedImportedParam + ").multiPart(\"import_duplicates\", " + autoApprovedImportedParam + ").multiPart(\"import_eq_suggestions\", " + autoApprovedImportedParam + ").multiPart(\"files[\"" + _file.getMaster().getCrowdinPath() + "\"]\", " + _file.getFile().getName() + ").post(\"/upload-translation?key=" + this.projectKey + ").andReturn().asString();"));
            }
            return "<dryRun success/>";
        }
        return RestAssured.given().multiPart("language", _file.getLang()).multiPart("auto_approve_imported", autoApprovedImportedParam).multiPart("import_duplicates", autoApprovedImportedParam).multiPart("import_eq_suggestions", autoApprovedImportedParam).multiPart("files[" + _file.getMaster().getCrowdinPath() + "]", _file.getFile()).post("/upload-translation?key=" + this.projectKey, new Object[0]).andReturn().asString();
    }

    public String getProjectInfo() throws MojoExecutionException {
        return RestAssured.given().post("/info?key=" + this.projectKey, new Object[0]).andReturn().asString();
    }

    public void downloadTranslations(File translationsFile) throws MojoExecutionException, FileNotFoundException, IOException {
        this.currentMojo.getLog().info((CharSequence)"Building Crowdin fresh package ...");
        RestAssured.given().post("/export?key=" + this.projectKey, new Object[0]).andReturn().asString();
        this.currentMojo.getLog().info((CharSequence)"Building Crowdin fresh package done");
        this.currentMojo.getLog().info((CharSequence)"Let's download it ...");
        try {
            FileOutputStream fos = new FileOutputStream(translationsFile);
            fos.write(RestAssured.given().post("/download/all.zip?key=" + this.projectKey, new Object[0]).andReturn().asByteArray());
            fos.close();
        }
        catch (FileNotFoundException e) {
            translationsFile = null;
            throw e;
        }
        catch (IOException e) {
            translationsFile = null;
            throw e;
        }
    }

    public String setApprovedOnlyOption() throws MojoExecutionException {
        return RestAssured.given().multiPart("export_approved_only", this.currentMojo.getApplyApprovedOnlyOption()).post("/edit-project?key=" + this.projectKey, new Object[0]).andReturn().asString();
    }

    public String getTranslationStatus() throws MojoExecutionException {
        return RestAssured.given().post("/status?key=" + this.projectKey, new Object[0]).andReturn().asString();
    }
}

