/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ShellScriptUtils {
    public static String makeFileFromResource(String resname) throws IOException {
        int n;
        InputStream is = ShellScriptUtils.class.getClassLoader().getResourceAsStream(resname);
        if (is == null) {
            throw new IOException("Unable to load resource:" + resname);
        }
        File tmpfile = File.createTempFile("xec", ".sh");
        String tmpfilename = tmpfile.getAbsolutePath();
        BufferedInputStream bis = new BufferedInputStream(is, 1024);
        FileOutputStream os = new FileOutputStream(tmpfile);
        BufferedOutputStream bos = new BufferedOutputStream(os, 1024);
        byte[] buffer = new byte[1024];
        while ((n = bis.read(buffer)) > 0) {
            bos.write(buffer, 0, n);
        }
        bos.close();
        bis.close();
        return tmpfilename;
    }

    public static int execShellscript(String pathname) throws IOException {
        String tmpfilename = ShellScriptUtils.makeFileFromResource(pathname);
        String command = "sh " + tmpfilename;
        Process p = Runtime.getRuntime().exec(command);
        int r = -1;
        try {
            r = p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new File(tmpfilename).delete();
        return r;
    }

    public static int execShellscript(String pathname, String fileArgument) throws IOException {
        String tmpfilename = ShellScriptUtils.makeFileFromResource(pathname);
        String command = "chmod 600 " + fileArgument;
        Process p = Runtime.getRuntime().exec(command);
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        command = "sh " + tmpfilename + " " + fileArgument;
        System.out.println("\n\n\n\n" + command + "\n\n\n\n");
        p = Runtime.getRuntime().exec(command);
        int r = -1;
        try {
            r = p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new File(tmpfilename).delete();
        return r;
    }
}

