/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class FileUtils {
    static Log log;

    public static void setLog(Log varLog) {
        log = varLog;
    }

    public static Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }
        return log;
    }

    public static boolean replaceStringInFile(String filePath, String regex, String replacement) {
        try {
            File file = new File(filePath);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            StringBuffer oldtext = new StringBuffer("");
            while ((line = reader.readLine()) != null) {
                oldtext.append(line + System.getProperty("line.separator"));
            }
            reader.close();
            String newtext = oldtext.toString().replaceAll(regex, replacement);
            FileWriter writer = new FileWriter(filePath);
            writer.write(newtext);
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean replaceCharactersInFile(String filePath, String propertiesFilePath, String replaceListConfigkey) {
        Properties configProp = new Properties();
        InputStream in = FileUtils.class.getClassLoader().getResourceAsStream(propertiesFilePath);
        try {
            configProp.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            String[] replaceListArr;
            File file = new File(filePath);
            if (!file.exists()) {
                FileUtils.getLog().info((CharSequence)("File " + file + " is not existed."));
                return false;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            StringBuffer oldtext = new StringBuffer("");
            while ((line = reader.readLine()) != null) {
                oldtext.append(line + System.getProperty("line.separator"));
            }
            reader.close();
            String newtext = oldtext.toString();
            String replaceListConfig = configProp.getProperty(replaceListConfigkey);
            for (String obj : replaceListArr = replaceListConfig.split("__AND__")) {
                String value;
                String[] keyValue = obj.replaceAll("\\[", "").replaceAll("\\]", "").split("BY");
                String key = keyValue[0];
                String string = value = keyValue.length > 1 ? keyValue[1] : "";
                if (value == null || value.length() == 0) {
                    value = "";
                }
                newtext = newtext.replaceAll(key, value);
            }
            FileWriter writer = new FileWriter(filePath);
            writer.write(newtext);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void replaceCharacters(String filePath, String oldValue, String newValue) {
        File file = new File(filePath);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            Object oldtext = "";
            while ((line = reader.readLine()) != null) {
                oldtext = (String)oldtext + line + System.getProperty("line.separator");
            }
            reader.close();
            String newtext = ((String)oldtext).replaceAll(oldValue, newValue);
            FileWriter writer = new FileWriter(filePath);
            writer.write(newtext);
            writer.close();
        }
        catch (FileNotFoundException e) {
            log.error((CharSequence)e.getMessage());
        }
        catch (IOException e) {
            log.error((CharSequence)e.getMessage());
        }
    }
}

