/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.model;

import java.io.File;
import org.exoplatform.crowdin.model.CrowdinFile;

public class CrowdinTranslation
extends CrowdinFile {
    private String lang;
    private CrowdinFile master;

    public CrowdinTranslation(File _file, String _name, String _type, String _project, String _lang, CrowdinFile _master, boolean _shouldBeCleaned) {
        super(_file, _name, _type, _project, _shouldBeCleaned);
        this.lang = CrowdinTranslation.getCrowdinLangFromPlatformLang(_lang);
        this.lang = CrowdinTranslation.encodeLanguageName(this.lang, true);
        this.master = _master;
    }

    public String getLang() {
        return this.lang;
    }

    public CrowdinFile getMaster() {
        return this.master;
    }

    public static String encodeLanguageName(String lang, boolean isEncode) {
        if (isEncode) {
            return lang == null || lang.isEmpty() ? lang : lang.replace("_", "-");
        }
        return lang == null || lang.isEmpty() ? lang : lang.replace("-", "_");
    }

    public static String getCrowdinLangFromPlatformLang(String lang) {
        String language = lang;
        if ("es".equals(language)) {
            language = "es-ES";
        } else if ("vn".equals(language)) {
            language = "vi";
        } else if ("in".equals(language)) {
            language = "id";
        }
        return language;
    }

    public static String encodeAndroidLocale(String locale) {
        if (locale.contains("-")) {
            locale = locale.replaceAll("-", "-r");
            return locale;
        }
        return locale;
    }

    public static String encodeIOSLocale(String locale) {
        return CrowdinTranslation.encodeLanguageName(locale, false);
    }
}

