/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLResourceBundleUtils {
    static Log log;

    public static void setLog(Log varLog) {
        log = varLog;
    }

    public static Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }
        return log;
    }

    public static Map<String, List<String>> readXMLToMap(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("No null input stream allowed");
        }
        return XMLResourceBundleUtils.readXMLToMap(new InputSource(in));
    }

    public static Map<String, List<String>> readXMLToMap(Reader in) {
        if (in == null) {
            throw new IllegalArgumentException("No null reader allowed");
        }
        return XMLResourceBundleUtils.readXMLToMap(new InputSource(in));
    }

    public static Map<String, List<String>> readXMLToMap(InputSource in) {
        if (in == null) {
            throw new IllegalArgumentException("No null input source allowed");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        HashMap<String, List<String>> bundle = new HashMap<String, List<String>>();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Element bundleElt = document.getDocumentElement();
            LinkedList<String> path = new LinkedList<String>();
            path.addLast("//" + document.getDocumentElement().getNodeName());
            if (XMLResourceBundleUtils.getLog().isDebugEnabled()) {
                XMLResourceBundleUtils.getLog().debug((CharSequence)("Start traverse XML doc with root Node: " + document.getDocumentElement().getNodeName()));
            }
            XMLResourceBundleUtils.collect(path, bundleElt, bundle);
            if (XMLResourceBundleUtils.getLog().isDebugEnabled()) {
                XMLResourceBundleUtils.getLog().debug((CharSequence)("End traverse XML doc with root Node: " + document.getDocumentElement().getNodeName()));
            }
        }
        catch (SAXException e) {
            XMLResourceBundleUtils.getLog().error((Throwable)e);
        }
        catch (IOException e) {
            XMLResourceBundleUtils.getLog().error((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            XMLResourceBundleUtils.getLog().error((Throwable)e);
        }
        return bundle;
    }

    private static void collect(LinkedList<String> path, Element currentElt, Map<String, List<String>> bundle) {
        CharSequence name;
        NodeList children = currentElt.getChildNodes();
        boolean text = true;
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            text = false;
            Element childElt = (Element)child;
            name = new StringBuffer();
            ((StringBuffer)name).append(childElt.getTagName());
            NamedNodeMap atts = child.getAttributes();
            if (atts != null && atts.getLength() > 0) {
                ((StringBuffer)name).append("[");
                for (int j = 0; j < atts.getLength(); ++j) {
                    ((StringBuffer)name).append("@" + atts.item(j).getNodeName());
                    ((StringBuffer)name).append("='" + atts.item(j).getNodeValue() + "'");
                    if (j >= atts.getLength() - 1) continue;
                    ((StringBuffer)name).append(" and ");
                }
                ((StringBuffer)name).append("]");
            }
            if (XMLResourceBundleUtils.getLog().isDebugEnabled()) {
                XMLResourceBundleUtils.getLog().debug((CharSequence)("Current Node: " + ((StringBuffer)name).toString()));
            }
            path.addLast(((StringBuffer)name).toString());
            XMLResourceBundleUtils.collect(path, childElt, bundle);
            path.removeLast();
        }
        if (text && path.size() > 0) {
            String valueStr = currentElt.getTextContent();
            StringBuffer sb = new StringBuffer();
            Iterator i = path.iterator();
            while (i.hasNext()) {
                name = (String)i.next();
                sb.append((String)name);
                if (!i.hasNext()) continue;
                sb.append('/');
            }
            String key = sb.toString();
            if (XMLResourceBundleUtils.getLog().isDebugEnabled()) {
                XMLResourceBundleUtils.getLog().debug((CharSequence)("Current path: " + key));
            }
            if (bundle.containsKey(key)) {
                bundle.get(key).add(valueStr);
            } else {
                LinkedList<String> value = new LinkedList<String>();
                value.add(valueStr);
                bundle.put(key, value);
            }
        }
    }

    public static String saveMapToXMLFile(String xmlTranslationResouceFilePath, String xmlMasterResourceFilePath, Map<String, List<String>> crowdinMapData) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document masterResourceDoc = docBuilder.parse(xmlMasterResourceFilePath);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            for (Map.Entry<String, List<String>> mapEntry : crowdinMapData.entrySet()) {
                List<String> listData = mapEntry.getValue();
                String nodeData = "";
                if (mapEntry != null && listData.size() > 0) {
                    nodeData = listData.get(0);
                }
                if (XMLResourceBundleUtils.getLog().isDebugEnabled()) {
                    XMLResourceBundleUtils.getLog().debug((CharSequence)("The key is: " + mapEntry.getKey() + ",value is :" + nodeData));
                }
                Node node = null;
                try {
                    node = (Node)xpath.evaluate(mapEntry.getKey(), masterResourceDoc, XPathConstants.NODE);
                }
                catch (XPathExpressionException e) {
                    continue;
                }
                if (node == null) continue;
                node.setTextContent(null != nodeData ? nodeData : "");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "utf-8");
            DOMSource source = new DOMSource(masterResourceDoc);
            StreamResult result = new StreamResult(new File(xmlTranslationResouceFilePath));
            transformer.transform(source, result);
            return xmlTranslationResouceFilePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String injectTranslation(InputSource crowdinFile, String resourceTranslationFilePath, String resourceMasterFilePath) {
        HashMap<String, List<String>> crowdinDataMap = new HashMap();
        try {
            crowdinDataMap = XMLResourceBundleUtils.readXMLToMap(crowdinFile);
            resourceTranslationFilePath = XMLResourceBundleUtils.saveMapToXMLFile(resourceTranslationFilePath, resourceMasterFilePath, crowdinDataMap);
            return resourceTranslationFilePath;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String injectTranslation(InputStream crowdinFile, String resourceTranslationFilePath, String resourceMasterFilePath) {
        if (crowdinFile == null) {
            throw new IllegalArgumentException("No null input stream allowed");
        }
        return XMLResourceBundleUtils.injectTranslation(new InputSource(crowdinFile), resourceTranslationFilePath, resourceMasterFilePath);
    }

    public static String injectTranslation(Reader crowdinFile, String resourceTranslationFilePath, String resourceMasterFilePath) {
        if (crowdinFile == null) {
            throw new IllegalArgumentException("No null input stream allowed");
        }
        return XMLResourceBundleUtils.injectTranslation(new InputSource(crowdinFile), resourceTranslationFilePath, resourceMasterFilePath);
    }
}

