/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLToProps {
    public static final String COLON_IN_KEY = "__COLON__";

    public static boolean parse(String inputFilePath, CrowdinFile.Type type) throws Exception {
        File inputFile = new File(inputFilePath);
        if (!inputFile.exists() || !inputFile.isFile()) {
            return false;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        FileInputStream fis = new FileInputStream(inputFile);
        Document document = builder.parse(new InputSource(fis));
        Element bundleElt = document.getDocumentElement();
        StringBuffer bundle = new StringBuffer();
        XMLToProps.collect(new LinkedList<String>(), bundleElt, bundle, type);
        String outputFile = inputFilePath.replaceAll("\\.xml", ".properties");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
        out.append(bundle.toString());
        ((Writer)out).flush();
        ((Writer)out).close();
        return true;
    }

    private static void collect(LinkedList<String> path, Element currentElt, StringBuffer bundle, CrowdinFile.Type type) {
        String name;
        NodeList children = currentElt.getChildNodes();
        boolean text = true;
        for (int i = 0; i <= children.getLength() - 1; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                text = false;
                Element childElt = (Element)child;
                name = childElt.getTagName();
                path.addLast(name);
                XMLToProps.collect(path, childElt, bundle, type);
                path.removeLast();
                continue;
            }
            if (child.getNodeType() != 8) continue;
            String comment = child.getTextContent();
            if ((comment = XMLToProps.makeComment(comment)) == null) continue;
            bundle.append(comment).append("\n");
        }
        if (text && path.size() > 0) {
            String value = currentElt.getTextContent();
            StringBuffer sb = new StringBuffer();
            if (CrowdinFile.Type.PORTLET.equals((Object)type)) {
                Iterator i = path.iterator();
                while (i.hasNext()) {
                    name = (String)i.next();
                    sb.append(name);
                    if (!i.hasNext()) continue;
                    sb.append('.');
                }
            } else {
                sb.append(currentElt.getAttributes().getNamedItem("name").getNodeValue());
                value = value.trim();
            }
            String key = sb.toString();
            key = key.replace(":", COLON_IN_KEY);
            bundle.append(key).append("=").append(value.replaceAll("\n", " ")).append("\n");
        }
    }

    private static String makeComment(String comment) {
        if (comment != null) {
            String[] lines = (comment = comment.trim()).split("\n");
            if (lines.length <= 0) {
                if (!comment.startsWith("#")) {
                    return "#" + comment;
                }
                return comment;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = lines[i].trim();
                if (!lines[i].startsWith("#")) {
                    sb.append("#").append(lines[i]);
                } else {
                    sb.append(lines[i]);
                }
                if (i >= lines.length - 1) continue;
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }
}

