#!/bin/bash
#
# $Id: setup-eppsp.sh 8959 2010-10-22 11:10:53Z hgomez $
#
# Copyright (C) 2003-2010 eXo Platform SAS.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see<http://www.gnu.org/licenses/>.#
#
#
# Purpose : Setup a JBoss EPP single or clustering environnement for QA teams with/without WCM
#

echo CARGOSH-EPPSP-SETUP cargosh-binaries 0.3

#
# Default vars
#
NUM_INSTANCES=1

CLEARDATA=false
MYSQL=false
WCM=false
VERBOSE=false
RUNEXEC=false
CLUSTERING=false
DB_LOGIN=root
DB_PASSWORD=
MIN_IN_POOL=
MAX_IN_POOL=
DISABLE_AUTO_CLOSE=false
LIGHT_PROFIL=false
RESETMASTER=false
MAX_HTTPAJP_CONNS=
SETUP_NAME=eppsp
JBOSS_DISTR_NAME=jboss-epp
JBOSS_DISTR_VERSION=Unknown
DB_HOST=localhost


#
# help / usage about program
#
usage()
{
cat << EOF
usage: $0 options

This script setup JBoss EPP single or clustering for QA teams.

OPTIONS:
   -h      Show this message
   -u      activate clustering (default: false)
   -i      instances number (default: 1)
   -n      number of instances (default: 1)
   -m      select mysql (default: hsql)
   -c      clear gatein data directory
   -l      db login (default: $DB_LOGIN)
   -p      db password (default: $DB_PASSWORD)
   -b      JBoss Distribution name (default: $JBOSS_DISTR_NAME)
   -e      JBoss Distribution version (default: $JBOSS_DISTR_VERSION)
   -a      deploy extensions (all zips/jars/wars in $REF_BINARIES_DIR/extensions dir)
   -x      execute instance(s) after install
   -d      db host (default: $DB_HOST)
   -v      Verbose
   -z      reset master JBoss installation
   -s      setup name (default: $SETUP_NAME)
   -I      min entries in DataSources pool (default: keep distribution default)
   -A      max entries in DataSources pool (default: keep distribution default)
   -H      max HTTP/AJP connections (default: keep distribution default)
   -C      disable JBoss datasource autoclose feature (default: false)
   -L      light JBoss AS profil, remove non usefull features (default: do not touch)

EOF
}

#
# Decode command line parameters
#
init()
{
    cygwin=false;
    linux=false;
    darwin=false;
    case "`uname`" in
        CYGWIN*) cygwin=true;;
        Linux*) linux=true;;
        Darwin*) darwin=true;;
    esac

    #
    # without parameters, provide help
    #
    if [ $# = 0 ]; then
      usage
      exit 1;
    fi

    while getopts "n:b:e:l:p:d:ahmi:cvus:A:I:CLzR:U:P:H:" OPTION
    do
         case $OPTION in
             h)
                 usage
                 exit 1
                 ;;
             b)
                 JBOSS_DISTR_NAME=$OPTARG
                 ;;
             e)
                 JBOSS_DISTR_VERSION=$OPTARG
                 ;;
             n)
                 NUM_INSTANCES=$OPTARG
                 INSTANCE_NUMBER=""
                 ;;
             i)
                 INSTANCE_NUMBER=$OPTARG
                 NUM_INSTANCES=""
                 ;;
             m)
                 MYSQL=true
                 ;;
             u)
                 CLUSTERING=true
                 ;;
             s)
                 SETUP_NAME=$OPTARG
                 ;;
             c)
                 CLEARDATA=true
                 ;;
             l)
                 DB_LOGIN=$OPTARG
                 ;;
             p)
                 DB_PASSWORD=$OPTARG
                 ;;
             a)
                 DEPLOY_EXTENSIONS=true;
                 ;;
             d)
                 DB_HOST=$OPTARG
                 ;;
             v)
                 VERBOSE=true
                 ;;
             I)
                 MIN_IN_POOL=$OPTARG
                 ;;
             A)
                 MAX_IN_POOL=$OPTARG
                 ;;
             C)
                 DISABLE_AUTO_CLOSE=true
                 ;;
             L)
                 LIGHT_PROFIL=true
                 ;;
             H)
                 MAX_HTTPAJP_CONNS=$OPTARG
                 ;;
             z)
                 RESETMASTER=true
                 ;;
             ?)
                 usage
                 exit
                 ;;
         esac
    done
}

#
# Prepare dirs
#
prepare()
{
    INSTALL_DIR=`pwd`/target/install

    if [ ! -z "$HUDSON_HOME" ]; then

        if [ -d $HUDSON_HOME ]; then
            INSTALL_DIR=$HUDSON_HOME/$SETUP_NAME
        fi

    fi

    if [ ! -z "$EXO_INSTALL_HOME" ]; then

        if [ -d $EXO_INSTALL_HOME ]; then
            INSTALL_DIR=$EXO_INSTALL_HOME
        fi

    fi

    echo "using $INSTALL_DIR to setup eppsp"

# directory where all jars/wars are stored (if not defined outside, set to ./addons)
    if [ -z "$REF_BINARIES_DIR" ]; then
        REF_BINARIES_DIR=`pwd`/target/binaries
    fi

# define jboss.server.data.dir since gatein.data.dir=${jboss.server.data.dir}/gatein, (if not defined outside)
    if [ -z "$GATEIN_DATA_DIR" ]; then
        GATEIN_DATA_DIR=$INSTALL_DIR/jboss-data/gatein-data
    fi

# directory where JBossAS from distro will be unzipped
    if [ -z "$JBOSS_MASTER_BASE" ]; then
        JBOSS_MASTER_BASE=$INSTALL_DIR/$JBOSS_DISTR_NAME-master
    fi

# directory where JBossAS will be installed
    if [ -z "$JBOSS_BASE" ]; then
        JBOSS_BASE=$INSTALL_DIR/$JBOSS_DISTR_NAME
    fi

    mkdir -p $REF_BINARIES_DIR
}

#
# DS Patch for MySql
#
patch_ds_mysql()
{
    DS_FILE=$1
    MODEL=$2

    # HSQLDB -> MySQL
    sed -i -e "s|org.hsqldb.jdbcDriver|com.mysql.jdbc.Driver|g" $DS_FILE

    # Login/Password
    sed -i -e "s|<user-name>sa</user-name>|<user-name>$DB_LOGIN</user-name>|g" $DS_FILE
    sed -i -e "s|<password></password>|<password>$DB_PASSWORD</password>|g" $DS_FILE

    sed -i -e "s|jdbc:hsqldb:\${jboss.server.data.dir}\${/}gatein\${/}hypersonic\${/}gatein-idm_$MODEL-localDB|jdbc:mysql://$DB_HOST/$SETUP_NAME-idm_$MODEL|g" $DS_FILE
    sed -i -e "s|jdbc:hsqldb:\${jboss.server.data.dir}\${/}gatein\${/}hypersonic\${/}gatein-jcr_$MODEL-localDB|jdbc:mysql://$DB_HOST/$SETUP_NAME-jcr_$MODEL|g" $DS_FILE
}

#
# setup common parts
#
setup_common()
{
# JBoss Master is BASE + SUFFIX
    JBOSS_MASTER=$JBOSS_MASTER_BASE-$JBOSS_DISTR_VERSION

    if $RESETMASTER; then
        echo "(-z) removing $JBOSS_DISTR_NAME master installation"
        rm -rf $JBOSS_MASTER
    fi

    #
    # jboss-epp distribution
    #
    if [ ! -d $JBOSS_MASTER ]; then

        #
        # jboss-epp distribution
        #
        if [ ! -f $REF_BINARIES_DIR/$JBOSS_DISTR_NAME-$JBOSS_DISTR_VERSION.zip ]; then
            echo "Missing JBoss binaries in $REF_BINARIES_DIR/$JBOSS_DISTR_NAME-$JBOSS_DISTR_VERSION.zip"
        else
            unzip -o -t $REF_BINARIES_DIR/$JBOSS_DISTR_NAME-$JBOSS_DISTR_VERSION.zip >/dev/null
            if [ $? != "0" ]; then
                echo "couldn't unzip $JBOSS_DISTR_NAME-$JBOSS_DISTR_VERSION.zip, aborting"
                exit -1
            fi
        fi

        echo "unzipping $REF_BINARIES_DIR/$JBOSS_DISTR_NAME-$JBOSS_DISTR_VERSION.zip under $JBOSS_MASTER..."
        mkdir -p $JBOSS_MASTER
        pushd $JBOSS_MASTER
        unzip -o $REF_BINARIES_DIR/$JBOSS_DISTR_NAME-$JBOSS_DISTR_VERSION.zip */jboss-as/* >/dev/null
        if [ $? != "0" ]; then
            echo "couldn't unzip $REF_BINARIES_DIR/$JBOSS_DISTR_NAME-$JBOSS_DISTR_VERSION.zip, aborting"
            exit -1
        fi
        # move every thing under jboss-as into master
        mv $JBOSS_DISTR_NAME-*/jboss-as/* .
        # remove jboss-ep-***
        rm -rf $JBOSS_DISTR_NAME-*

        popd

    fi

    # Gatein data

    if $CLEARDATA; then
        echo "clearing gatein contents"

        if [ -d $GATEIN_DATA_DIR ]; then
            echo "clearing gatein datadir"
            rm -rf $GATEIN_DATA_DIR
        fi

        #
        # Handle OS/X - Linux mysql location
        #
        if [ -x /usr/local/mysql/bin/mysqladmin ]; then
            MYSQLADMIN=/usr/local/mysql/bin/mysqladmin
        fi

        if [ -x /Applications/MAMP/Library/bin/mysqladmin ]; then
            MYSQLADMIN=/Applications/MAMP/Library/bin/mysqladmin
        fi

        if [ -x /usr/bin/mysqladmin ]; then
            MYSQLADMIN=/usr/bin/mysqladmin
        fi

        if $MYSQL; then
            echo "clearing MySQL DataBases"

            $MYSQLADMIN drop $SETUP_NAME-idm_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
            $MYSQLADMIN drop $SETUP_NAME-jcr_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

            #TODO database to create in parameter
            if $DEPLOY_EXTENSIONS; then

                $MYSQLADMIN drop $SETUP_NAME-idm_ecmdemo -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
                $MYSQLADMIN drop $SETUP_NAME-jcr_ecmdemo -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

            fi

           echo "creating MySQL Databases"

            $MYSQLADMIN create $SETUP_NAME-idm_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
            $MYSQLADMIN create $SETUP_NAME-jcr_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

            #TODO database to create in parameter
            if $DEPLOY_EXTENSIONS; then

                $MYSQLADMIN create $SETUP_NAME-idm_ecmdemo -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
                $MYSQLADMIN create $SETUP_NAME-jcr_ecmdemo -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

            fi

        fi

    fi

    # create gatein data directory
    mkdir -p $GATEIN_DATA_DIR


    # edit all/conf/gatein/configuration.properties

    if [ ! -d $JBOSS_BASE/bin ]; then

        if [ -d $JBOSS_BASE ]; then
            echo "incomplete copy of JBoss installed under $JBOSS_BASE, autocleaning"
            rm -rf $JBOSS_BASE
        fi

        echo "copying JBoss master from $JBOSS_MASTER to $JBOSS_BASE"
        cp -rf $JBOSS_MASTER $JBOSS_BASE

    fi
}

check_running_instance() {
    INST_ID=$1
    JBOSSAS_INST_BASE=$JBOSS_BASE/server/all$INST_ID

    JBOSS_LOG=$JBOSS_BASE/server/all$INST_ID/log/jboss.log
    JBOSS_PID=$JBOSS_BASE/server/all$INST_ID/log/jboss.pid

    if [ -f $JBOSS_PID ]; then

        read KPID <  $JBOSS_PID

        if [ ! -z "$KPID" ]; then

            if [ "$(ps -p $KPID | grep -c $KPID)" -eq "1" ]; then
                echo "WARNING, running instance detected stoping it"

                # send kill to process
                kill $KPID

                count="0"
                # wait it to finish
                until [ "$(ps -p $KPID | grep -c $KPID)" -eq "0" ] || \
                        [ "$count" -gt "$SHUTDOWN_WAIT" ]; do
                    if [ "$SHUTDOWN_VERBOSE" = "true" ]; then
                        echo "waiting for processes $KPID to exit"
                    fi
                    sleep 1
                    let count="${count}+1"
                done

                # If process still active after SHUTDOWN_WAIT seconds, brutal kill ;(
                if [ "$count" -gt "$SHUTDOWN_WAIT" ]; then
                    if [ "$SHUTDOWN_VERBOSE" = "true" ]; then
                        echo "killing processes which didn't stop after $SHUTDOWN_WAIT seconds"
                    fi
                    kill -9 $KPID
                fi

                # remove process id
                rm -f  $JBOSS_PID

            fi
        fi
    fi

}


setup_instance() {

    INST_ID=$1

    check_running_instance $INST_ID

    echo "setup JBoss instance #$INST_ID"
    #
    # Prepare gatein
    # pwd=base
    #
    JBOSS_INST_BASE=$JBOSS_BASE/server/all$INST_ID

    # Remove previous stuff from instance
    echo "cleaning previous instance..."
    rm -rf $JBOSS_INST_BASE

    echo "copying all profile..."
    mkdir -p $JBOSS_INST_BASE
    cp -rf $JBOSS_BASE/server/all/* $JBOSS_INST_BASE

    if $LIGHT_PROFIL; then

        echo "light profil asked, removing unnecessary features for all profil"

        rm -rf $JBOSS_INST_BASE/deploy/admin-console.war
        rm -rf $JBOSS_INST_BASE/deploy/httpha-invoker.sar
        rm -f  $JBOSS_INST_BASE/deploy/iiop-service.xml
        rm -f  $JBOSS_INST_BASE/deploy/jms-ra.rar
        rm -f  $JBOSS_INST_BASE/deploy/jmx-invoker-service.xml
        rm -f  $JBOSS_INST_BASE/deploy/jsr88-service.xml
        rm -rf $JBOSS_INST_BASE/deploy/juddi-service.sar
        rm -f  $JBOSS_INST_BASE/deploy/legacy-invokers-service.xml
        rm -f  $JBOSS_INST_BASE/deploy/mail-ra.xml
        rm -f  $JBOSS_INST_BASE/deploy/mail-service.xml
        rm -rf $JBOSS_INST_BASE/deploy/management
        rm -rf $JBOSS_INST_BASE/deploy/messaging
        rm -f  $JBOSS_INST_BASE/deploy/monitoring-service.xml
        rm -f  $JBOSS_INST_BASE/deploy/quartz-ra.rar
        rm -f  $JBOSS_INST_BASE/deploy/schedule-manager-service.xml
        rm -f  $JBOSS_INST_BASE/deploy/scheduler-service.xml
        rm -rf $JBOSS_INST_BASE/deploy/snmp-adaptor.sar
        rm -rf $JBOSS_INST_BASE/deploy/xnio-provider.jar
        rm -f  $JBOSS_INST_BASE/farm/cluster-examples-service.xml
        rm -rf $JBOSS_INST_BASE/deployers/bsh.deployer
        rm -f  $JBOSS_INST_BASE/deployers/hibernate-deployer-jboss-beans.xml
        rm -f  $JBOSS_INST_BASE/deployers/jsr77-deployers-jboss-beans.xml
        rm -f  $JBOSS_INST_BASE/deployers/messaging-definitions-jboss-beans.xml
        rm -rf $JBOSS_INST_BASE/deployers/seam.deployer
        rm -rf $JBOSS_INST_BASE/deployers/xnio.deployer

    fi


    echo "deploying gatein..."
    cp -rf $JBOSS_BASE/server/default/deploy/*gatein* $JBOSS_INST_BASE/deploy

    echo "deploying jbossweb deployer..."
    cp -rf $JBOSS_BASE/server/default/deployers/jbossweb.deployer/web.xml $JBOSS_INST_BASE/deployers/jbossweb.deployer/

    echo "removing gatein samples..."
    rm -rf $JBOSS_INST_BASE/deploy/gatein-sample*

    echo "installing gatein conf..."
    cp -rf $JBOSS_BASE/server/default/conf/gatein $JBOSS_INST_BASE/conf/

    # Julien suggestion (remove messaging/jms support)
    # echo "remove messaging support JMS"
    # rm -rf $JBOSS_BASE/server/all/deploy/messaging

    # Inject Extensions on JBoss instance (if asked)
    if $DEPLOY_EXTENSIONS; then
      echo "installing Extensions for JBOSS..."
      #unzip extensions
      find $REF_BINARIES_DIR/extensions -name *.zip -exec unzip -o {} -d $REF_BINARIES_DIR/extensions \;
      find $REF_BINARIES_DIR/extensions/* -name *.ear -type f -exec cp {} $JBOSS_INST_BASE/deploy/ \;
      find $REF_BINARIES_DIR/extensions/* -name *-ds.xml -type f -exec cp {} $JBOSS_INST_BASE/deploy/ \;
    fi

    echo "updating third party libs..."

    # update datasource names
    if $DEPLOY_EXTENSIONS; then

        sed -i -e "s|gatein.jcr.datasource.name=java:jdbcjcr|gatein.jcr.datasource.name=java:exo-jcr|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties
        sed -i -e "s|gatein.idm.datasource.name=java:jdbcidm|gatein.idm.datasource.name=java:exo-idm|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties

        # Set min/max in pool
        if [ ! -z "$MIN_IN_POOL" ]; then
            sed -i -e "s|<min-pool-size>5</min-pool-size>|<min-pool-size>$MIN_IN_POOL</min-pool-size>|g" $JBOSS_INST_BASE/deploy/gatein-ds.xml
            sed -i -e "s|<min-pool-size>5</min-pool-size>|<min-pool-size>$MIN_IN_POOL</min-pool-size>|g" $JBOSS_INST_BASE/deploy/wcm-ds.xml
        fi

        if [ ! -z "$MAX_IN_POOL" ]; then
            sed -i -e "s|<max-pool-size>20</max-pool-size>|<max-pool-size>$MAX_IN_POOL</max-pool-size>|g" $JBOSS_INST_BASE/deploy/gatein-ds.xml
            sed -i -e "s|<max-pool-size>20</max-pool-size>|<max-pool-size>$MAX_IN_POOL</max-pool-size>|g" $JBOSS_INST_BASE/deploy/wcm-ds.xml
        fi

    fi

    # MySQL JDBC driver (if asked)
    if $MYSQL; then
        echo "installing mysql libs..."
        rm -f $JBOSS_INST_BASE/lib/mysql-connector-java*.jar
        cp $REF_BINARIES_DIR/mysql-connector-java-*.jar $JBOSS_INST_BASE/lib/

        # Update SQL Driver is MySQL
        sed -i -e "s|org.hsqldb.jdbcDriver|com.mysql.jdbc.Driver|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties
        # Update Datasources
        sed -i -e "s|gatein.jcr.datasource.url=jdbc:hsqldb:file:\${gatein.db.data.dir}/data/jdbcjcr_\${name}|gatein.jcr.datasource.url=jdbc:mysql://$DB_HOST/jcr_portal|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties
        sed -i -e "s|gatein.idm.datasource.url=jdbc:hsqldb:file:\${gatein.db.data.dir}/data/jdbcidm_\${name}|gatein.idm.datasource.url=jdbc:mysql://$DB_HOST/idm_portal|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties
        # Update user
        sed -i -e "s|gatein.jcr.datasource.username=sa|gatein.jcr.datasource.username=$DB_LOGIN|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties
        sed -i -e "s|gatein.idm.datasource.username=sa|gatein.idm.datasource.username=$DB_LOGIN|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties
        # Update password
        sed -i -e "s|gatein.jcr.datasource.password=|gatein.jcr.datasource.password=$DB_PASSWORD|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties
        sed -i -e "s|gatein.idm.datasource.password=|gatein.idm.datasource.password=$DB_PASSWORD|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties

        if $DEPLOY_EXTENSIONS; then
            patch_ds_mysql $JBOSS_INST_BASE/deploy/gatein-ds.xml portal
            patch_ds_mysql $JBOSS_INST_BASE/deploy/wcm-ds.xml ecmdemo
        fi

    fi

    # Patch log4j to avoid unnecessary message from JGroups
    sed -i -e "s|<!-- Clustering logging -->|<!-- Limit the JSR77 categories --><category name=\"exo.jcr\"><priority value=\"INFO\"/></category>\
                                        <!-- Limit the JSR-168 and JSR-286 categories --><category name=\"org.exoplatform.services\"><priority value=\"INFO\"/></category>\
                                        <!-- Avoid unfamiliar UDP datagrams warning from JGroups --><category name=\"org.jgroups.protocols.UDP\"><priority value=\"ERROR\"/></category>\
                                        <!-- Clustering logging -->|g" $JBOSS_INST_BASE/conf/jboss-log4j.xml

    # Patch server.xml to support load-balancing with mod_jk (jvmRoute)
    sed -i -e "s|<Engine name=\"jboss.web\" defaultHost=\"localhost\">|<Engine name=\"jboss.web\" defaultHost=\"localhost\" jvmRoute=\"jb$INST_ID\">|g" $JBOSS_INST_BASE/deploy/jbossweb.sar/server.xml

    # Setup AJP/HTTP connections
    if [ ! -z "$MAX_HTTPAJP_CONNS" ]; then
        sed -i -e "s|redirectPort=|maxThreads=\"$MAX_HTTPAJP_CONNS\" redirectPort=|g" $JBOSS_INST_BASE/deploy/jbossweb.sar/server.xml
    fi

    if $CLUSTERING; then
        # Setup gatein shared datas directory
        sed -i -e "s|\${jboss.server.data.dir}/gatein|$GATEIN_DATA_DIR|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties
        # Set jcr configuration for clustering
        sed -i -e "s|gatein.jcr.config.type=local|gatein.jcr.config.type=cluster|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties

        # Update ChangeFilterClass
        sed -i -e "s|gatein.jcr.index.changefilterclass=org.exoplatform.services.jcr.impl.core.query.DefaultChangesFilter|gatein.jcr.index.changefilterclass=org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexChangesFilter|g" $JBOSS_INST_BASE/conf/gatein/configuration.properties

        # uncommand SSO in clustering mode
        sed -i -e "s|<Valve className=\"org.jboss.web.tomcat.service.sso.ClusteredSingleSignOn\" />|--><Valve className=\"org.jboss.web.tomcat.service.sso.ClusteredSingleSignOn\" /><!--|g" $JBOSS_INST_BASE/deploy/jbossweb.sar/server.xml
    fi

    # Eventually disable unclosed connection tracking done by JBOss AS

    if $DISABLE_AUTO_CLOSE; then
        sed -i -e "s|<property name=\"debug\">false</property>|<property name=\"debug\">true</property>|g" $JBOSS_INST_BASE/deploy/jca-jboss-beans.xml
    fi

    # fix sed -e under OS/X
    rm -f $JBOSS_INST_BASE/conf/gatein/configuration.properties-e
    rm -f $JBOSS_INST_BASE/conf/jboss-log4j.xml-e
    rm -f $JBOSS_INST_BASE/deploy/jbossweb.sar/server.xml-e
    rm -f $JBOSS_INST_BASE/deploy/gatein-ds.xml-e
    rm -f $JBOSS_INST_BASE/deploy/wcm-ds.xml-e
    rm -f $JBOSS_INST_BASE/deploy/gatein.ear/02portal.war/WEB-INF/conf/portal/portal-configuration.xml-e

}

#
# MAIN HERE
#

init $@
prepare
setup_common

# instance or instances ?
if [ ! -z "$INSTANCE_NUMBER" ]; then

    setup_instance $INSTANCE_NUMBER

else


    for GINST in `eval echo {1..$NUM_INSTANCES}`; do

        setup_instance $GINST

    done

fi


