package org.exoplatform.wallet.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.2.0.
 */
public class ERTToken extends Contract {
    private static final String BINARY = "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";

    public static final String FUNC_VERSION = "version";

    public static final String FUNC_PAUSED = "paused";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_GETDATAADDRESS = "getDataAddress";

    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    @Deprecated
    protected ERTToken(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTToken(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTToken(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTToken(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<BigInteger> version() {
        final Function function = new Function(FUNC_VERSION, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> paused() {
        final Function function = new Function(FUNC_PAUSED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<String> owner() {
        final Function function = new Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> getDataAddress(BigInteger _version) {
        final Function function = new Function(FUNC_GETDATAADDRESS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint16(_version)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> implementationAddress() {
        final Function function = new Function(FUNC_IMPLEMENTATIONADDRESS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> transferOwnership(String _newOwner) {
        final Function function = new Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TransferOwnershipEventResponse>() {
            @Override
            public TransferOwnershipEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFEROWNERSHIP_EVENT));
        return transferOwnershipEventFlowable(filter);
    }

    @Deprecated
    public static ERTToken load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTToken(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTToken load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTToken(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTToken load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTToken(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTToken load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTToken(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<ERTToken> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _implementationAddress, String _dataAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_implementationAddress), 
                new org.web3j.abi.datatypes.Address(_dataAddress)));
        return deployRemoteCall(ERTToken.class, web3j, credentials, contractGasProvider, BINARY, encodedConstructor);
    }

    public static RemoteCall<ERTToken> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _implementationAddress, String _dataAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_implementationAddress), 
                new org.web3j.abi.datatypes.Address(_dataAddress)));
        return deployRemoteCall(ERTToken.class, web3j, transactionManager, contractGasProvider, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERTToken> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _implementationAddress, String _dataAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_implementationAddress), 
                new org.web3j.abi.datatypes.Address(_dataAddress)));
        return deployRemoteCall(ERTToken.class, web3j, credentials, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERTToken> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _implementationAddress, String _dataAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_implementationAddress), 
                new org.web3j.abi.datatypes.Address(_dataAddress)));
        return deployRemoteCall(ERTToken.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    public static class TransferOwnershipEventResponse {
        public Log log;

        public String newOwner;
    }
}
