import * as Compiler from "../../compiler";
import * as Ast from "../../ast";
import * as AbiData from "../types";
import * as Contexts from "../../contexts/types";
import * as Pointer from "../../pointer";
import { DecodingMode } from "../../types";
import { ImmutableReferences } from "@truffle/contract-schema/spec";
import * as Format from "../../format";
export interface ContractAllocationInfo {
    abi?: AbiData.Abi;
    contractNode: Ast.AstNode;
    deployedContext?: Contexts.DecoderContext;
    constructorContext?: Contexts.DecoderContext;
    immutableReferences?: ImmutableReferences;
    compiler: Compiler.CompilerVersion;
    compilationId?: string;
}
export interface AbiSizeInfo {
    size: number;
    dynamic: boolean;
}
export interface AbiAllocations {
    [id: string]: AbiAllocation | null;
}
export interface AbiAllocation {
    length: number;
    dynamic: boolean;
    members: AbiMemberAllocation[];
}
export interface AbiMemberAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.GenericAbiPointer;
}
export interface CalldataAllocations {
    constructorAllocations: CalldataConstructorAllocations;
    functionAllocations: CalldataFunctionAllocations;
}
export interface CalldataConstructorAllocations {
    [contextHash: string]: CalldataAndReturndataAllocation;
}
export interface CalldataFunctionAllocations {
    [contextHash: string]: {
        [selector: string]: CalldataAndReturndataAllocation;
    };
}
export interface CalldataAndReturndataAllocation {
    input: CalldataAllocation;
    output: ReturndataAllocation;
}
export interface CalldataAllocation {
    abi: AbiData.FunctionAbiEntry | AbiData.ConstructorAbiEntry;
    offset: number;
    arguments: CalldataArgumentAllocation[];
    allocationMode: DecodingMode;
}
export interface CalldataArgumentAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.CalldataPointer;
}
export interface EventAllocations {
    [topics: number]: {
        bySelector: {
            [selector: string]: {
                [contractKind: string]: {
                    [contextHash: string]: EventAllocation[];
                };
            };
        };
        anonymous: {
            [contractKind: string]: {
                [contextHash: string]: EventAllocation[];
            };
        };
    };
}
export interface EventAllocation {
    abi: AbiData.EventAbiEntry;
    contextHash: string;
    definedIn?: Format.Types.ContractType;
    anonymous: boolean;
    arguments: EventArgumentAllocation[];
    allocationMode: DecodingMode;
}
export interface EventArgumentAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.EventDataPointer | Pointer.EventTopicPointer;
}
declare type ReturndataKind = "return" | "revert" | "failure" | "selfdestruct" | "bytecode";
export interface ReturndataAllocation {
    selector: Uint8Array;
    arguments: ReturndataArgumentAllocation[];
    allocationMode: DecodingMode;
    kind: ReturndataKind;
}
export interface ReturndataArgumentAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.ReturndataPointer;
}
export interface EventAllocationTemporary {
    selector: string;
    anonymous: boolean;
    topics: number;
    allocation: EventAllocation | undefined;
}
export interface CalldataAllocationTemporary {
    constructorAllocation?: CalldataAndReturndataAllocation;
    functionAllocations: {
        [selector: string]: CalldataAndReturndataAllocation;
    };
}
export {};
