"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const import_1 = require("../../contexts/import");
//creates a type object for the contract the function was defined in
function functionTableEntryToType(functionEntry) {
    return {
        typeClass: "contract",
        kind: "native",
        id: import_1.makeTypeId(functionEntry.contractId, functionEntry.compilationId),
        typeName: functionEntry.contractName,
        contractKind: functionEntry.contractKind,
        payable: functionEntry.contractPayable
    };
}
exports.functionTableEntryToType = functionTableEntryToType;
//# sourceMappingURL=index.js.map