"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const web3_shim_1 = require("./web3-shim");
class Web3InterfaceAdapter {
    constructor(options) {
        this.web3 = new web3_shim_1.Web3Shim(options);
    }
    getNetworkId() {
        return this.web3.eth.net.getId();
    }
    getBlock(block) {
        return this.web3.eth.getBlock(block);
    }
    setProvider(provider) {
        return this.web3.setProvider(provider);
    }
    getTransaction(tx) {
        return this.web3.eth.getTransaction(tx);
    }
    getTransactionReceipt(tx) {
        return this.web3.eth.getTransactionReceipt(tx);
    }
    getBalance(address) {
        return this.web3.eth.getBalance(address);
    }
}
exports.Web3InterfaceAdapter = Web3InterfaceAdapter;
//# sourceMappingURL=web3-interface-adapter.js.map