/*
 * Decompiled with CFR 0.152.
 */
package org.consento.syncrandombytes;

import android.util.Base64;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

class SyncRandomBytesModule
extends ReactContextBaseJavaModule {
    private static final String SEED_KEY = "seed";

    public SyncRandomBytesModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return "SyncRandomBytes";
    }

    @ReactMethod
    public void randomBytes(int size, Callback success) {
        success.invoke(new Object[]{null, this.getRandomBytes(size)});
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put(SEED_KEY, this.getRandomBytes(4096));
        return constants;
    }

    private String getRandomBytes(int size) {
        SecureRandom sr = new SecureRandom();
        byte[] output = new byte[size];
        sr.nextBytes(output);
        return Base64.encodeToString((byte[])output, (int)2);
    }
}

