"use strict";
import { Coder } from "./abstract-coder";
export class NullCoder extends Coder {
    constructor(localName) {
        super("null", "", localName, false);
    }
    encode(writer, value) {
        if (value != null) {
            this._throwError("not null", value);
        }
        return writer.writeBytes([]);
    }
    decode(reader) {
        reader.readBytes(0);
        return reader.coerce(this.name, null);
    }
}
//# sourceMappingURL=null.js.map