import { Action, PreloadedState, Reducer, Store, StoreEnhancer } from 'redux';
export declare const ActionTypes: {
    readonly PERFORM_ACTION: "PERFORM_ACTION";
    readonly RESET: "RESET";
    readonly ROLLBACK: "ROLLBACK";
    readonly COMMIT: "COMMIT";
    readonly SWEEP: "SWEEP";
    readonly TOGGLE_ACTION: "TOGGLE_ACTION";
    readonly SET_ACTIONS_ACTIVE: "SET_ACTIONS_ACTIVE";
    readonly JUMP_TO_STATE: "JUMP_TO_STATE";
    readonly JUMP_TO_ACTION: "JUMP_TO_ACTION";
    readonly REORDER_ACTION: "REORDER_ACTION";
    readonly IMPORT_STATE: "IMPORT_STATE";
    readonly LOCK_CHANGES: "LOCK_CHANGES";
    readonly PAUSE_RECORDING: "PAUSE_RECORDING";
};
export interface PerformAction<A extends Action<unknown>> {
    type: typeof ActionTypes.PERFORM_ACTION;
    action: A;
    timestamp: number;
    stack: string | undefined;
}
interface ResetAction {
    type: typeof ActionTypes.RESET;
    timestamp: number;
}
interface RollbackAction {
    type: typeof ActionTypes.ROLLBACK;
    timestamp: number;
}
interface CommitAction {
    type: typeof ActionTypes.COMMIT;
    timestamp: number;
}
interface SweepAction {
    type: typeof ActionTypes.SWEEP;
}
interface ToggleAction {
    type: typeof ActionTypes.TOGGLE_ACTION;
    id: number;
}
interface SetActionsActiveAction {
    type: typeof ActionTypes.SET_ACTIONS_ACTIVE;
    start: number;
    end: number;
    active: boolean;
}
interface ReorderAction {
    type: typeof ActionTypes.REORDER_ACTION;
    actionId: number;
    beforeActionId: number;
}
interface JumpToStateAction {
    type: typeof ActionTypes.JUMP_TO_STATE;
    index: number;
}
interface JumpToActionAction {
    type: typeof ActionTypes.JUMP_TO_ACTION;
    actionId: number;
}
interface ImportStateAction<S, A extends Action<unknown>, MonitorState> {
    type: typeof ActionTypes.IMPORT_STATE;
    nextLiftedState: LiftedState<S, A, MonitorState> | readonly A[];
    preloadedState?: S;
    noRecompute: boolean | undefined;
}
interface LockChangesAction {
    type: typeof ActionTypes.LOCK_CHANGES;
    status: boolean;
}
interface PauseRecordingAction {
    type: typeof ActionTypes.PAUSE_RECORDING;
    status: boolean;
}
export declare type LiftedAction<S, A extends Action<unknown>, MonitorState> = PerformAction<A> | ResetAction | RollbackAction | CommitAction | SweepAction | ToggleAction | SetActionsActiveAction | ReorderAction | JumpToStateAction | JumpToActionAction | ImportStateAction<S, A, MonitorState> | LockChangesAction | PauseRecordingAction;
/**
 * Action creators to change the History state.
 */
export declare const ActionCreators: {
    performAction<A extends Action<unknown>>(action: A, trace?: boolean | ((action: A) => string | undefined) | undefined, traceLimit?: number | undefined, toExcludeFromTrace?: Function | undefined): {
        type: "PERFORM_ACTION";
        action: A;
        timestamp: number;
        stack: string | undefined;
    };
    reset(): ResetAction;
    rollback(): RollbackAction;
    commit(): CommitAction;
    sweep(): SweepAction;
    toggleAction(id: number): ToggleAction;
    setActionsActive(start: number, end: number, active?: boolean): SetActionsActiveAction;
    reorderAction(actionId: number, beforeActionId: number): ReorderAction;
    jumpToState(index: number): JumpToStateAction;
    jumpToAction(actionId: number): JumpToActionAction;
    importState<S, A_1 extends Action<unknown>, MonitorState = null>(nextLiftedState: LiftedState<S, A_1, MonitorState> | readonly A_1[], noRecompute?: boolean | undefined): ImportStateAction<S, A_1, MonitorState>;
    lockChanges(status: boolean): LockChangesAction;
    pauseRecording(status: boolean): PauseRecordingAction;
};
export declare const INIT_ACTION: {
    type: string;
};
/**
 * Lifts an app's action into an action on the lifted store.
 */
export declare function liftAction<A extends Action<unknown>>(action: A, trace?: ((action: A) => string | undefined) | boolean, traceLimit?: number, toExcludeFromTrace?: Function): {
    type: "PERFORM_ACTION";
    action: A;
    timestamp: number;
    stack: string | undefined;
};
export interface LiftedState<S, A extends Action<unknown>, MonitorState> {
    monitorState: MonitorState;
    nextActionId: number;
    actionsById: {
        [actionId: number]: PerformAction<A>;
    };
    stagedActionIds: number[];
    skippedActionIds: number[];
    committedState: S;
    currentStateIndex: number;
    computedStates: {
        state: S;
        error?: string;
    }[];
    isLocked: boolean;
    isPaused: boolean;
}
/**
 * Creates a history state reducer from an app's reducer.
 */
export declare function liftReducerWith<S, A extends Action<unknown>, MonitorState, MonitorAction extends Action<unknown>>(reducer: Reducer<S, A>, initialCommittedState: PreloadedState<S> | undefined, monitorReducer: Reducer<MonitorState, MonitorAction>, options: Options<S, A, MonitorState, MonitorAction>): Reducer<LiftedState<S, A, MonitorState>, LiftedAction<S, A, MonitorState>>;
/**
 * Provides an app's view into the state of the lifted store.
 */
export declare function unliftState<S, A extends Action<unknown>, MonitorState, NextStateExt>(liftedState: LiftedState<S, A, MonitorState> & NextStateExt): S & NextStateExt;
export declare type LiftedReducer<S, A extends Action<unknown>, MonitorState> = Reducer<LiftedState<S, A, MonitorState>, LiftedAction<S, A, MonitorState>>;
export declare type LiftedStore<S, A extends Action<unknown>, MonitorState> = Store<LiftedState<S, A, MonitorState>, LiftedAction<S, A, MonitorState>>;
export declare type InstrumentExt<S, A extends Action<unknown>, MonitorState> = {
    liftedStore: LiftedStore<S, A, MonitorState>;
};
export declare type EnhancedStore<S, A extends Action<unknown>, MonitorState> = Store<S, A> & InstrumentExt<S, A, MonitorState>;
/**
 * Provides an app's view into the lifted store.
 */
export declare function unliftStore<S, A extends Action<unknown>, MonitorState, MonitorAction extends Action<unknown>, NextExt, NextStateExt>(liftedStore: Store<LiftedState<S, A, MonitorState> & NextStateExt, LiftedAction<S, A, MonitorState>> & NextExt, liftReducer: (r: Reducer<S, A>) => LiftedReducer<S, A, MonitorState>, options: Options<S, A, MonitorState, MonitorAction>): Store<S & NextStateExt, A> & NextExt & {
    liftedStore: Store<LiftedState<S, A, MonitorState> & NextStateExt, LiftedAction<S, A, MonitorState>>;
};
export interface Options<S, A extends Action<unknown>, MonitorState, MonitorAction extends Action<unknown>> {
    maxAge?: number | ((currentLiftedAction: LiftedAction<S, A, MonitorState>, previousLiftedState: LiftedState<S, A, MonitorState> | undefined) => number);
    shouldCatchErrors?: boolean;
    shouldRecordChanges?: boolean;
    pauseActionType?: unknown;
    shouldStartLocked?: boolean;
    shouldHotReload?: boolean;
    trace?: boolean | ((action: A) => string | undefined);
    traceLimit?: number;
    shouldIncludeCallstack?: boolean;
}
/**
 * Redux instrumentation store enhancer.
 */
export default function instrument<OptionsS, OptionsA extends Action<unknown>, MonitorState = null, MonitorAction extends Action<unknown> = never>(monitorReducer?: Reducer<MonitorState, MonitorAction>, options?: Options<OptionsS, OptionsA, MonitorState, MonitorAction>): StoreEnhancer<InstrumentExt<any, any, MonitorState>>;
export {};
