<img src="https://user-images.githubusercontent.com/211411/34776833-6f1ef4da-f618-11e7-8b13-f0697901d6a8.png" height="100" />

[Github](https://github.com/LedgerHQ/ledgerjs/),
[Ledger Devs Slack](https://ledger-dev.slack.com/)

## @ledgerhq/hw-transport

`@ledgerhq/hw-transport` implements the generic interface of a Ledger Hardware Wallet transport.

## API

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

#### Table of Contents

-   [Subscription](#subscription)
    -   [Properties](#properties)
-   [Device](#device)
-   [DescriptorEvent](#descriptorevent)
    -   [Properties](#properties-1)
-   [Observer](#observer)
-   [Transport](#transport)
    -   [exchange](#exchange)
        -   [Parameters](#parameters)
    -   [setScrambleKey](#setscramblekey)
        -   [Parameters](#parameters-1)
    -   [close](#close)
    -   [on](#on)
        -   [Parameters](#parameters-2)
    -   [off](#off)
        -   [Parameters](#parameters-3)
    -   [setDebugMode](#setdebugmode)
    -   [setExchangeTimeout](#setexchangetimeout)
        -   [Parameters](#parameters-4)
    -   [setExchangeUnresponsiveTimeout](#setexchangeunresponsivetimeout)
        -   [Parameters](#parameters-5)
    -   [send](#send)
        -   [Parameters](#parameters-6)
    -   [isSupported](#issupported)
    -   [list](#list)
        -   [Examples](#examples)
    -   [listen](#listen)
        -   [Parameters](#parameters-7)
        -   [Examples](#examples-1)
    -   [open](#open)
        -   [Parameters](#parameters-8)
        -   [Examples](#examples-2)
    -   [create](#create)
        -   [Parameters](#parameters-9)
        -   [Examples](#examples-3)

### Subscription

#### Properties

-   `unsubscribe` **function (): void** 

### Device

Type: [Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)

### DescriptorEvent

type: add or remove event
descriptor: a parameter that can be passed to open(descriptor)
deviceModel: device info on the model (is it a nano s, nano x, ...)
device: transport specific device info

#### Properties

-   `type` **(`"add"` \| `"remove"`)** 
-   `descriptor` **Descriptor** 
-   `deviceModel` **DeviceModel??** 
-   `device` **[Device](#device)?** 

### Observer

Type: $ReadOnly&lt;{next: function (event: Ev): any, error: function (e: any): any, complete: function (): any}>

### Transport

Transport defines the generic interface to share between node/u2f impl
A **Descriptor** is a parametric type that is up to be determined for the implementation.
it can be for instance an ID, an file path, a URL,...

#### exchange

low level api to communicate with the device
This method is for implementations to implement but should not be directly called.
Instead, the recommanded way is to use send() method

##### Parameters

-   `_apdu` **[Buffer](https://nodejs.org/api/buffer.html)** 
-   `apdu`  the data to send

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Buffer](https://nodejs.org/api/buffer.html)>** a Promise of response data

#### setScrambleKey

set the "scramble key" for the next exchanges with the device.
Each App can have a different scramble key and they internally will set it at instanciation.

##### Parameters

-   `_key` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** 
-   `key`  the scramble key

#### close

close the exchange with the device.

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** a Promise that ends when the transport is closed.

#### on

Listen to an event on an instance of transport.
Transport implementation can have specific events. Here is the common events:

-   `"disconnect"` : triggered if Transport is disconnected

##### Parameters

-   `eventName` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** 
-   `cb` **[Function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function)** 

#### off

Stop listening to an event on an instance of transport.

##### Parameters

-   `eventName` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** 
-   `cb` **[Function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function)** 

#### setDebugMode

Enable or not logs of the binary exchange

#### setExchangeTimeout

Set a timeout (in milliseconds) for the exchange call. Only some transport might implement it. (e.g. U2F)

##### Parameters

-   `exchangeTimeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 

#### setExchangeUnresponsiveTimeout

Define the delay before emitting "unresponsive" on an exchange that does not respond

##### Parameters

-   `unresponsiveTimeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 

#### send

wrapper on top of exchange to simplify work of the implementation.

##### Parameters

-   `cla` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `ins` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `p1` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `p2` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `data` **[Buffer](https://nodejs.org/api/buffer.html)**  (optional, default `Buffer.alloc(0)`)
-   `statusList` **[Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)>** is a list of accepted status code (shorts). [0x9000] by default (optional, default `[StatusCodes.OK]`)

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Buffer](https://nodejs.org/api/buffer.html)>** a Promise of response buffer

#### isSupported

Statically check if a transport is supported on the user's platform/browser.

Type: function (): [Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)>

#### list

List once all available descriptors. For a better granularity, checkout `listen()`.

Type: function (): [Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;Descriptor>>

##### Examples

```javascript
TransportFoo.list().then(descriptors => ...)
```

Returns **any** a promise of descriptors

#### listen

Listen all device events for a given Transport. The method takes an Obverver of DescriptorEvent and returns a Subscription (according to Observable paradigm <https://github.com/tc39/proposal-observable> )
a DescriptorEvent is a `{ descriptor, type }` object. type can be `"add"` or `"remove"` and descriptor is a value you can pass to `open(descriptor)`.
each listen() call will first emit all potential device already connected and then will emit events can come over times,
for instance if you plug a USB device after listen() or a bluetooth device become discoverable.

Type: function (observer: [Observer](#observer)&lt;[DescriptorEvent](#descriptorevent)&lt;Descriptor>>): [Subscription](#subscription)

##### Parameters

-   `observer`  is an object with a next, error and complete function (compatible with observer pattern)

##### Examples

```javascript
const sub = TransportFoo.listen({
next: e => {
if (e.type==="add") {
sub.unsubscribe();
const transport = await TransportFoo.open(e.descriptor);
...
}
},
error: error => {},
complete: () => {}
})
```

Returns **any** a Subscription object on which you can `.unsubscribe()` to stop listening descriptors.

#### open

attempt to create a Transport instance with potentially a descriptor.

Type: function (descriptor: Descriptor, timeout: [number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)): [Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Transport](#transport)&lt;Descriptor>>

##### Parameters

-   `descriptor`  : the descriptor to open the transport with.
-   `timeout`  : an optional timeout

##### Examples

```javascript
TransportFoo.open(descriptor).then(transport => ...)
```

Returns **any** a Promise of Transport instance

#### create

create() allows to open the first descriptor available or
throw if there is none or if timeout is reached.
This is a light helper, alternative to using listen() and open() (that you may need for any more advanced usecase)

##### Parameters

-   `openTimeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)**  (optional, default `3000`)
-   `listenTimeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)?** 

##### Examples

```javascript
TransportFoo.create().then(transport => ...)
```

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Transport](#transport)&lt;Descriptor>>** 
