"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Web3InterfaceAdapter = void 0;
const shim_1 = require("../../shim");
class Web3InterfaceAdapter {
    constructor({ provider, networkType } = {}) {
        this.web3 = new shim_1.Web3Shim({ provider, networkType });
    }
    getNetworkId() {
        return this.web3.eth.net.getId();
    }
    getBlock(block) {
        return this.web3.eth.getBlock(block);
    }
    getTransaction(tx) {
        return this.web3.eth.getTransaction(tx);
    }
    getTransactionReceipt(tx) {
        return this.web3.eth.getTransactionReceipt(tx);
    }
    getBalance(address) {
        return this.web3.eth.getBalance(address);
    }
    getCode(address) {
        return this.web3.eth.getCode(address);
    }
    getAccounts() {
        return this.web3.eth.getAccounts();
    }
    estimateGas(transactionConfig) {
        return this.web3.eth.estimateGas(transactionConfig);
    }
    getBlockNumber() {
        return this.web3.eth.getBlockNumber();
    }
}
exports.Web3InterfaceAdapter = Web3InterfaceAdapter;
//# sourceMappingURL=index.js.map