var StaticContentHandler = require('./handlers/StaticContentHandler.js');

var HandlerFactory = function(rootContext) {
	var handlerTypes = {
		"static": StaticContentHandler
	};

	this.registerHandlerType = function(resourceType, handlerType) {
		handlerTypes[resourceType] = handlerType;
	};

	this.create = function(descriptor) {
		return new handlerTypes[descriptor.type](rootContext, descriptor);
	};
};

module.exports = HandlerFactory;