"use strict";
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __asyncDelegator = (this && this.__asyncDelegator) || function (o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
};
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.targetPath = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = require("path");
function targetPath(options) {
    return __asyncGenerator(this, arguments, function* targetPath_1() {
        const { path } = options;
        const stats = yield __await(fs_1.default.promises.stat(path));
        if (stats.isFile()) {
            return yield __await({
                source: yield __await(yield* __asyncDelegator(__asyncValues(pathContent(options))))
            });
        }
        else if (stats.isDirectory()) {
            return yield __await({
                source: yield __await(yield* __asyncDelegator(__asyncValues(pathContainer(options))))
            });
        }
    });
}
exports.targetPath = targetPath;
function pathContent(options) {
    return __asyncGenerator(this, arguments, function* pathContent_1() {
        const { path, verbose, controls } = options;
        const { step } = controls;
        const task = verbose
            ? yield __await(yield* __asyncDelegator(__asyncValues(step({ message: `Opening ./${path}...` }))))
            : controls;
        const content = fs_1.default.createReadStream(path);
        if (verbose) {
            yield __await(yield* __asyncDelegator(__asyncValues(task.succeed())));
        }
        return yield __await(content);
    });
}
function pathContainer(options) {
    return __asyncGenerator(this, arguments, function* pathContainer_1() {
        const { path, verbose, controls } = options;
        const { step } = controls;
        const task = verbose
            ? yield __await(yield* __asyncDelegator(__asyncValues(step({ message: `Reading directory ${path}...` }))))
            : controls;
        const directory = yield __await(fs_1.default.promises.readdir(path));
        const entries = [];
        for (const childPath of directory) {
            const entry = yield __await(yield* __asyncDelegator(__asyncValues(pathEntry(Object.assign(Object.assign({}, options), { controls: task, path: childPath, parent: path })))));
            entries.push(entry);
        }
        if (verbose) {
            yield __await(yield* __asyncDelegator(__asyncValues(task.succeed())));
        }
        return yield __await({
            entries
        });
    });
}
function pathEntry(options) {
    return __asyncGenerator(this, arguments, function* pathEntry_1() {
        const { path, parent } = options;
        const stats = yield __await(fs_1.default.promises.stat(path_1.join(parent, path)));
        if (stats.isFile()) {
            return yield __await({
                path,
                source: yield __await(yield* __asyncDelegator(__asyncValues(pathContent(Object.assign(Object.assign({}, options), { path: path_1.join(parent, path) })))))
            });
        }
        if (stats.isDirectory()) {
            return yield __await({
                path,
                source: yield __await(yield* __asyncDelegator(__asyncValues(pathContainer(Object.assign(Object.assign({}, options), { path: path_1.join(parent, path) })))))
            });
        }
    });
}
//# sourceMappingURL=fs.js.map