import { Arbitrary } from './definition/Arbitrary';
/**
 * Constraints to be applied on {@link lorem}
 * @remarks Since 2.5.0
 * @public
 */
export interface LoremConstraints {
    /**
     * Maximal number of entities:
     * - maximal number of words in case mode is 'words'
     * - maximal number of sentences in case mode is 'sentences'
     *
     * @defaultValue 5
     *
     * @remarks Since 2.5.0
     */
    maxCount?: number;
    /**
     * Type of strings that should be produced by {@link lorem}:
     * - words: multiple words
     * - sentences: multiple sentences
     *
     * @defaultValue 'words'
     *
     * @remarks Since 2.5.0
     */
    mode?: 'words' | 'sentences';
}
/**
 * For lorem ipsum strings of words
 * @remarks Since 0.0.1
 * @public
 */
declare function lorem(): Arbitrary<string>;
/**
 * For lorem ipsum string of words with maximal number of words
 *
 * @param maxWordsCount - Upper bound of the number of words allowed
 *
 * @deprecated
 * Superceded by `fc.lorem({maxCount})` - see {@link https://github.com/dubzzz/fast-check/issues/992 | #992}.
 * Ease the migration with {@link https://github.com/dubzzz/fast-check/tree/main/codemods/unify-signatures | our codemod script}.
 *
 * @remarks Since 0.0.1
 * @public
 */
declare function lorem(maxWordsCount: number): Arbitrary<string>;
/**
 * For lorem ipsum string of words or sentences with maximal number of words or sentences
 *
 * @param maxWordsCount - Upper bound of the number of words/sentences allowed
 * @param sentencesMode - If enabled, multiple sentences might be generated
 *
 * @deprecated
 * Superceded by `fc.lorem({maxCount, mode})` - see {@link https://github.com/dubzzz/fast-check/issues/992 | #992}.
 * Ease the migration with {@link https://github.com/dubzzz/fast-check/tree/main/codemods/unify-signatures | our codemod script}.
 *
 * @remarks Since 0.0.1
 * @public
 */
declare function lorem(maxWordsCount: number, sentencesMode: boolean): Arbitrary<string>;
/**
 * For lorem ipsum string of words or sentences with maximal number of words or sentences
 *
 * @param constraints - Constraints to be applied onto the generated value
 *
 * @remarks Since 2.5.0
 * @public
 */
declare function lorem(constraints: LoremConstraints): Arbitrary<string>;
export { lorem };
