export = ipfsClient;
/**
 * @param {import("./lib/core").ClientOptions} options
 */
declare function ipfsClient(options?: import("./lib/core").ClientOptions): {
    add: (input: import("ipfs-core-types/src/files").ToEntry, options?: (import("ipfs-core-types/src/root").AddAllOptions & HttpOptions) | undefined) => Promise<import("ipfs-core-types/src/files").UnixFSEntry>;
    addAll: (source: import("ipfs-core-types/src/files").ImportSource, options?: (import("ipfs-core-types/src/root").AddAllOptions & HttpOptions) | undefined) => AsyncIterable<import("ipfs-core-types/src/files").UnixFSEntry>;
    bitswap: {
        wantlist: (options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("cids")[]>;
        wantlistForPeer: (peerId: string | import("cids") | Uint8Array | import("peer-id"), options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("cids")[]>;
        stat: (options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/bitswap/stat").BitswapStats>;
        unwant: (cid: import("cids") | import("cids")[], options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<void>;
    };
    block: {
        get: (cid: string | import("cids") | Uint8Array, options?: (import("ipfs-core/src/components/block/get").GetOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core-types/src/block-service").Block>;
        stat: (cid: import("cids"), options?: (import("ipfs-core/src/components/block/stat").StatOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/block/stat").Stat>;
        put: (data: Uint8Array | import("ipfs-core-types/src/block-service").Block, options?: (import("ipfs-core/src/components/block/put").PutOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core-types/src/block-service").Block>;
        rm: (cid: import("cids") | import("cids")[], options?: (import("ipfs-core/src/components/block/rm").RmOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => AsyncIterable<import("ipfs-core/src/components/block/rm").RmSucceess | import("ipfs-core/src/components/block/rm").RmFailure>;
    };
    bootstrap: {
        add: (addr: import("multiaddr"), options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/bootstrap/utils").Peers>;
        clear: (options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/bootstrap/utils").Peers>;
        rm: (addr: import("multiaddr"), options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/bootstrap/utils").Peers>;
        reset: (options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/bootstrap/utils").Peers>;
        list: (options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/bootstrap/utils").Peers>;
    };
    cat: (path: import("ipfs-core-types/src/root").IPFSPath, options?: (import("ipfs-core-types/src/root").CatOptions & HttpOptions) | undefined) => AsyncIterable<Uint8Array>;
    commands: (options?: {}) => Promise<any>;
    config: {
        getAll: import("./interface").APIWithExtraOptions<(options?: import("ipfs-core-types").AbortOptions | undefined) => Promise<import("ipfs-core/src/components/config").IPFSConfig>, HttpOptions>;
        get: import("./interface").APIWithExtraOptions<(key: string, options?: import("ipfs-core-types").AbortOptions | undefined) => Promise<import("ipfs-core-types/src/basic").ToJSON>, HttpOptions>;
        set: import("./interface").APIWithExtraOptions<(key: string, value: import("ipfs-core-types/src/basic").ToJSON, options?: import("ipfs-core-types").AbortOptions | undefined) => Promise<void>, HttpOptions>;
        replace: import("./interface").APIWithExtraOptions<(value: import("ipfs-core/src/components/config").IPFSConfig, options?: import("ipfs-core-types").AbortOptions | undefined) => Promise<void>, HttpOptions>;
        profiles: {
            apply: (profile: any, options?: {}) => Promise<{
                original: any;
                updated: any;
            }>;
            list: (options?: {}) => Promise<any>;
        };
    };
    dag: {
        get: import("./interface").APIWithExtraOptions<(ipfsPath: import("ipfs-core-types/src/root").IPFSPath, options?: (import("ipfs-core/src/components/dag/get").GetOptions & import("ipfs-core-types").AbortOptions) | undefined) => Promise<import("ipfs-core/src/components/dag/get").DagEntry>, HttpOptions>;
        put: import("./interface").APIWithExtraOptions<(dagNode: any, options?: (import("ipfs-core/src/components/dag/put").WithCID & import("ipfs-core/src/components/dag/put").OtherPutOptions & import("ipfs-core-types").AbortOptions) | (import("ipfs-core/src/components/dag/put").WithCIDOptions & import("ipfs-core/src/components/dag/put").OtherPutOptions & import("ipfs-core-types").AbortOptions) | undefined) => Promise<import("cids")>, HttpOptions>;
        resolve: import("./interface").APIWithExtraOptions<(ipfsPath: import("ipfs-core-types/src/root").IPFSPath, options?: (import("ipfs-core/src/components/dag/resolve").ResolveOptions & import("ipfs-core-types").AbortOptions) | undefined) => Promise<import("ipfs-core/src/components/dag/resolve").ResolveResult>, HttpOptions>;
    };
    dht: {
        get: (key: string | Uint8Array, options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<Uint8Array>;
        put: (key: Uint8Array, value: Uint8Array, options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => AsyncIterable<import("ipfs-core/src/components/dht").QueryEvent>;
        findProvs: (cid: import("cids"), options?: (import("ipfs-core/src/components/dht").FindProvsOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => AsyncIterable<import("ipfs-core/src/components/dht").PeerInfo>;
        findPeer: (peerId: import("cids") | import("peer-id"), options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<{
            id: string;
            addrs: import("multiaddr")[];
        }>;
        provide: (cids: import("cids") | import("cids")[], options?: (import("ipfs-core/src/components/dht").ProvideOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => AsyncIterable<import("ipfs-core/src/components/dht").QueryEvent>;
        query: (peerId: string | import("peer-id"), options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => AsyncIterable<{
            id: import("cids");
            addrs: import("multiaddr")[];
        }>;
    };
    diag: {
        net: (options?: {}) => Promise<any>;
        sys: (options?: {}) => Promise<any>;
        cmds: (options?: {}) => Promise<any>;
    };
    dns: import("./interface").APIWithExtraOptions<(domain: string, options?: (import("ipfs-core/src/components/dns").DNSSettings & import("ipfs-core-types").AbortOptions) | undefined) => Promise<string>, HttpOptions>;
    files: {
        chmod: (path: string, mode: string | number, options?: (import("ipfs-core/src/components/files/chmod").ChmodOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<void>;
        cp: (...args: [a1: import("ipfs-core-types/src/root").IPFSPath, options?: (import("ipfs-core/src/components/files/cp").CpOptions & HttpOptions) | undefined] | [a1: import("ipfs-core-types/src/root").IPFSPath, a2: import("ipfs-core-types/src/root").IPFSPath, options?: (import("ipfs-core/src/components/files/cp").CpOptions & HttpOptions) | undefined] | [a1: import("ipfs-core-types/src/root").IPFSPath, a2: import("ipfs-core-types/src/root").IPFSPath, a3: import("ipfs-core-types/src/root").IPFSPath, options?: (import("ipfs-core/src/components/files/cp").CpOptions & HttpOptions) | undefined]) => Promise<void>;
        flush: (path: string, options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("cids")>;
        ls: (path: string, options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => AsyncIterable<import("ipfs-core/src/components/files/ls").UnixFSEntry>;
        mkdir: (path: string, options?: (import("ipfs-core/src/components/files/mkdir").MkdirOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<void>;
        mv: (...args: [a1: string, a2: string, options?: (import("ipfs-core/src/components/files/mv").MvOptions & HttpOptions) | undefined] | [a1: string, a2: string, a3: string, options?: (import("ipfs-core/src/components/files/mv").MvOptions & HttpOptions) | undefined]) => Promise<void>;
        read: (path: import("ipfs-core-types/src/root").IPFSPath, options?: (import("ipfs-core/src/components/files/read").ReadOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => AsyncIterable<Uint8Array>;
        rm: (...args: [a1: string, options?: (import("ipfs-core/src/components/files/rm").RmOptions & HttpOptions) | undefined] | [a1: string, a2: string, options?: (import("ipfs-core/src/components/files/rm").RmOptions & HttpOptions) | undefined] | [a1: string, a2: string, a3: string, options?: (import("ipfs-core/src/components/files/rm").RmOptions & HttpOptions) | undefined]) => Promise<void>;
        stat: (path: string, options?: (import("ipfs-core/src/components/files/stat").StatOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/files/stat").Stat>;
        touch: (path: string, options?: (import("ipfs-core/src/components/files/touch").TouchOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<void>;
        write: (path: string, input: string | Uint8Array | AsyncIterable<Uint8Array> | Blob, options?: (import("ipfs-core/src/components/files/write").WriteOptions & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<void>;
    };
    get: (path: import("ipfs-core-types/src/root").IPFSPath, options?: (import("ipfs-core-types/src/root").GetOptions & HttpOptions) | undefined) => AsyncIterable<import("ipfs-core-types/src/files").IPFSEntry>;
    getEndpointConfig: () => {
        host: string;
        port: string;
        protocol: string;
        pathname: string;
        'api-path': string;
    };
    id: (options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/id").ID>;
    key: {
        gen: (name: any, options?: {}) => Promise<any>;
        list: (options?: {}) => Promise<any>;
        rename: (oldName: any, newName: any, options?: {}) => Promise<any>;
        rm: (name: any, options?: {}) => Promise<any>;
        import: (name: any, pem: any, password: any, options?: {}) => Promise<any>;
    };
    log: {
        tail: (options?: {}) => AsyncGenerator<any, void, any>;
        ls: (options?: {}) => Promise<any>;
        level: (subsystem: any, level: any, options?: {}) => Promise<any>;
    };
    ls: (path: any, options?: {}) => AsyncGenerator<{
        name: any;
        path: string;
        size: any;
        cid: import("cids");
        type: string;
        depth: any;
    }, void, undefined>;
    mount: (options?: {}) => Promise<any>;
    name: {
        publish: (path: any, options?: {}) => Promise<any>;
        resolve: (path: any, options?: {}) => AsyncGenerator<any, void, unknown>;
        pubsub: {
            cancel: (name: any, options?: {}) => Promise<any>;
            state: (options?: {}) => Promise<any>;
            subs: (options?: {}) => Promise<any>;
        };
    };
    object: {
        data: (cid: any, options?: {}) => Promise<Uint8Array>;
        get: (cid: any, options?: {}) => Promise<any>;
        links: (cid: any, options?: {}) => Promise<any>;
        new: (options?: {}) => Promise<import("cids")>;
        patch: {
            addLink: (cid: any, dLink: any, options?: {}) => Promise<import("cids")>;
            appendData: (cid: any, data: any, options?: {}) => Promise<import("cids")>;
            rmLink: (cid: any, dLink: any, options?: {}) => Promise<import("cids")>;
            setData: (cid: any, data: any, options?: {}) => Promise<import("cids")>;
        };
        put: (obj: any, options?: {}) => Promise<import("cids")>;
        stat: (cid: any, options?: {}) => Promise<any>;
    };
    pin: {
        add: (path: any, options?: {}) => Promise<void | import("cids")>;
        addAll: (source: any, options?: {}) => AsyncGenerator<import("cids"), void, unknown>;
        ls: (options?: {}) => AsyncGenerator<{
            type: any;
            cid: import("cids");
        }, void, unknown>;
        rm: (path: any, options?: {}) => Promise<any>;
        rmAll: (source: any, options?: {}) => AsyncGenerator<any, void, any>;
    };
    ping: (peerId: any, options?: {}) => AsyncGenerator<any, void, any>;
    pubsub: {
        ls: (options?: {}) => Promise<any>;
        peers: (topic: any, options?: {}) => Promise<any>;
        publish: (topic: any, data: any, options?: {}) => Promise<void>;
        subscribe: (topic: any, handler: any, options?: {}) => Promise<any>;
        unsubscribe: (topic: any, handler: any) => Promise<any>;
    };
    refs: {
        (args: any, options?: {}): AsyncGenerator<any, void, any>;
        local: (options?: {}) => AsyncGenerator<any, void, any>;
    };
    repo: {
        gc: (options?: {}) => AsyncGenerator<any, void, any>;
        stat: (options?: {}) => Promise<{
            numObjects: import("bignumber.js").default;
            repoSize: import("bignumber.js").default;
            repoPath: any;
            version: any;
            storageMax: import("bignumber.js").default;
        }>;
        version: (options?: {}) => Promise<any>;
    };
    resolve: (path: string, options?: (import("ipfs-core/src/components/resolve").ResolveSettings & import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<string>;
    stats: {
        bitswap: (options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/bitswap/stat").BitswapStats>;
        bw: (options?: {}) => AsyncGenerator<any, void, any>;
        repo: (options?: {}) => Promise<{
            numObjects: import("bignumber.js").default;
            repoSize: import("bignumber.js").default;
            repoPath: any;
            version: any;
            storageMax: import("bignumber.js").default;
        }>;
    };
    stop: (options?: {}) => Promise<void>;
    shutdown: (options?: {}) => Promise<void>;
    swarm: {
        addrs: (options?: {}) => Promise<{
            id: string;
            addrs: any;
        }[]>;
        connect: (addrs: any, options?: {}) => Promise<any>;
        disconnect: (addrs: any, options?: {}) => Promise<any>;
        localAddrs: (options?: {}) => Promise<any>;
        peers: (options?: {}) => Promise<any>;
    };
    version: (options?: (import("ipfs-core-types").AbortOptions & HttpOptions) | undefined) => Promise<import("ipfs-core/src/components/version").Version>;
};
declare namespace ipfsClient {
    export { HttpOptions, AbortOptions, Implements, ImplementsMethod, APIWithExtraOptions };
}
type HttpOptions = {
    /**
     * - An object or [Headers](https://developer.mozilla.org/en-US/docs/Web/API/Headers) instance that can be used to set custom HTTP headers. Note that this option can also be [configured globally](#custom-headers) via the constructor options.
     */
    headers?: Headers | Record<string, string> | undefined;
    /**
     * - An object or [`URLSearchParams`](https://developer.mozilla.org/en-US/docs/Web/API/URLSearchParams) instance that can be used to add additional query parameters to the query string sent with each request.
     */
    searchParams?: Record<string, string> | URLSearchParams | undefined;
};
/**
 * }
 */
type AbortOptions = import("ipfs-core-types").AbortOptions;
/**
 * This is an utility type that can be used to derive type of the HTTP Client
 * API from the Core API. It takes type of the API factory (from ipfs-core),
 * derives API from it's return type and extends it last `options` parameter
 * with `HttpOptions`.
 *
 * This can be used to avoid (re)typing API interface when implementing it in
 * http client e.g you can annotate `ipfs.addAll` implementation with
 *
 * `@type {Implements<typeof import('ipfs-core/src/components/add-all')>}`
 *
 * **Caution**: This supports APIs with up to four parameters and last optional
 * `options` parameter, anything else will result to `never` type.
 */
type Implements<APIFactory extends (config: any) => any> = (...args: Parameters<ReturnType<APIFactory>> extends never[] ? [] : Parameters<ReturnType<APIFactory>> extends [options?: infer Options | undefined, ...end: never[]] ? [options?: (Options & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1: infer A1, options?: infer Options_1 | undefined, ...end: never[]] ? [a1: A1, options?: (Options_1 & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1?: infer A1_1 | undefined, options?: infer Options_2 | undefined, ...end: never[]] ? [a1?: A1_1 | undefined, options?: (Options_2 & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1: infer A1_2, a2: infer A2, options?: infer Options_3 | undefined, ...end: never[]] ? [a1: A1_2, a2: A2, options?: (Options_3 & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1: infer A1_3, a2?: infer A2_1 | undefined, options?: infer Options_4 | undefined, ...end: never[]] ? [a1: A1_3, a2?: A2_1 | undefined, options?: (Options_4 & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1?: infer A1_4 | undefined, a2?: infer A2_2 | undefined, options?: infer Options_5 | undefined, ...end: never[]] ? [a1?: A1_4 | undefined, a2?: A2_2 | undefined, options?: (Options_5 & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1: infer A1_5, a2: infer A2_3, a3: infer A3, options?: infer Options_6 | undefined, ...end: never[]] ? [a1: A1_5, a2: A2_3, a3: A3, options?: (Options_6 & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1: infer A1_6, a2: infer A2_4, a3?: infer A3_1 | undefined, options?: infer Options_7 | undefined, ...end: never[]] ? [a1: A1_6, a2: A2_4, a3?: A3_1 | undefined, options?: (Options_7 & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1: infer A1_7, a2?: infer A2_5 | undefined, a3?: infer A3_2 | undefined, options?: infer Options_8 | undefined, ...end: never[]] ? [a1: A1_7, a2?: A2_5 | undefined, a3?: A3_2 | undefined, options?: (Options_8 & HttpOptions) | undefined] : Parameters<ReturnType<APIFactory>> extends [a1?: infer A1_8 | undefined, a2?: infer A2_6 | undefined, a3?: infer A3_3 | undefined, options?: infer Options_9 | undefined, ...end: never[]] ? [a1?: A1_8 | undefined, a2?: A2_6 | undefined, a3?: A3_3 | undefined, options?: (Options_9 & HttpOptions) | undefined] : never) => ReturnType<ReturnType<APIFactory>>;
type ImplementsMethod<Key, APIFactory extends (config: any) => any> = ReturnType<APIFactory>[Key] extends (...args: any[]) => any ? import("./interface").APIWithExtraOptions<ReturnType<APIFactory>[Key], HttpOptions> : never;
type APIWithExtraOptions<API, Extra> = (...args: Parameters<API> extends never[] ? [] : Parameters<API> extends [options?: infer Options | undefined, ...end: never[]] ? [options?: (Options & Extra) | undefined] : Parameters<API> extends [a1: infer A1, options?: infer Options_1 | undefined, ...end: never[]] ? [a1: A1, options?: (Options_1 & Extra) | undefined] : Parameters<API> extends [a1?: infer A1_1 | undefined, options?: infer Options_2 | undefined, ...end: never[]] ? [a1?: A1_1 | undefined, options?: (Options_2 & Extra) | undefined] : Parameters<API> extends [a1: infer A1_2, a2: infer A2, options?: infer Options_3 | undefined, ...end: never[]] ? [a1: A1_2, a2: A2, options?: (Options_3 & Extra) | undefined] : Parameters<API> extends [a1: infer A1_3, a2?: infer A2_1 | undefined, options?: infer Options_4 | undefined, ...end: never[]] ? [a1: A1_3, a2?: A2_1 | undefined, options?: (Options_4 & Extra) | undefined] : Parameters<API> extends [a1?: infer A1_4 | undefined, a2?: infer A2_2 | undefined, options?: infer Options_5 | undefined, ...end: never[]] ? [a1?: A1_4 | undefined, a2?: A2_2 | undefined, options?: (Options_5 & Extra) | undefined] : Parameters<API> extends [a1: infer A1_5, a2: infer A2_3, a3: infer A3, options?: infer Options_6 | undefined, ...end: never[]] ? [a1: A1_5, a2: A2_3, a3: A3, options?: (Options_6 & Extra) | undefined] : Parameters<API> extends [a1: infer A1_6, a2: infer A2_4, a3?: infer A3_1 | undefined, options?: infer Options_7 | undefined, ...end: never[]] ? [a1: A1_6, a2: A2_4, a3?: A3_1 | undefined, options?: (Options_7 & Extra) | undefined] : Parameters<API> extends [a1: infer A1_7, a2?: infer A2_5 | undefined, a3?: infer A3_2 | undefined, options?: infer Options_8 | undefined, ...end: never[]] ? [a1: A1_7, a2?: A2_5 | undefined, a3?: A3_2 | undefined, options?: (Options_8 & Extra) | undefined] : Parameters<API> extends [a1?: infer A1_8 | undefined, a2?: infer A2_6 | undefined, a3?: infer A3_3 | undefined, options?: infer Options_9 | undefined, ...end: never[]] ? [a1?: A1_8 | undefined, a2?: A2_6 | undefined, a3?: A3_3 | undefined, options?: (Options_9 & Extra) | undefined] : never) => ReturnType<API>;
//# sourceMappingURL=index.d.ts.map