var EventEmitter = require('events').EventEmitter,
	util = require('util');

var logger = {
	info: function(msg) {
		console.log(msg);
	},
	warn: function(msg) {
		console.log(msg.yellow);
	},
	error: function(msg) {
		console.log(msg.red);
	}
};

var loggerManager = new EventEmitter();
loggerManager.set = function(lgr) {
	logger = lgr;
	this.emit('updated', logger);
};
loggerManager.get = function() {
	return logger;
};

module.exports = loggerManager;