/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.skin.ResourceResolver;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.services.deployment.ContentInitializerService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.skin.WCMSkinResourceResolver;
import org.picocontainer.Startable;

public class XSkinService
implements Startable {
    private static String SHARED_CSS_QUERY = "select * from exo:cssFile where jcr:path like '{path}/%' and exo:active='true' and exo:sharedCSS='true' order by exo:priority DESC ".intern();
    public static final String SKIN_PATH_REGEXP = "/portal/css/jcr/(.*)/(.*)/(.*).css".intern();
    private static final String SKIN_PATH_PATTERN = "/portal/css/jcr/(.*)/(.*)/Stylesheet.css".intern();
    private static Log log = ExoLogger.getLogger((String)"wcm:XSkinService");
    private WebSchemaConfigService schemaConfigService;
    private WCMConfigurationService configurationService;
    private SkinService skinService;

    public XSkinService(SkinService skinService, WebSchemaConfigService schemaConfigService, WCMConfigurationService configurationService, ContentInitializerService initializerService) {
        this.skinService = skinService;
        this.skinService.addResourceResolver((ResourceResolver)new WCMSkinResourceResolver(this.skinService));
        this.configurationService = configurationService;
        this.schemaConfigService = schemaConfigService;
    }

    public String getActiveStylesheet(Node home) throws Exception {
        String cssQuery = "select * from exo:cssFile where jcr:path like '" + home.getPath() + "/%' and exo:active='true'order by exo:priority DESC ";
        return this.getCSSDataBySQLQuery(home.getSession(), cssQuery, null);
    }

    public void updatePortalSkinOnModify(Node cssFile, Node portal) throws Exception {
        String modifiedCSS = cssFile.getNode("jcr:content").getProperty("jcr:data").getString();
        String repository = ((ManageableRepository)portal.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portal.getName())) {
            this.addSharedPortalSkin(portal, SHARED_CSS_QUERY, cssFile.getPath(), modifiedCSS, true);
        } else {
            this.addPortalSkin(portal, SHARED_CSS_QUERY, cssFile.getPath(), modifiedCSS, true);
        }
    }

    public void updatePortalSkinOnRemove(Node cssFile, Node portal) throws Exception {
        String repository = ((ManageableRepository)portal.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portal.getName())) {
            this.addSharedPortalSkin(portal, SHARED_CSS_QUERY, cssFile.getPath(), null, true);
        } else {
            this.addPortalSkin(portal, SHARED_CSS_QUERY, cssFile.getPath(), null, true);
        }
    }

    private void addPortalSkin(Node portal, String preStatement, String exceptedPath, String appendedCSS, boolean allowEmptyCSS) throws Exception {
        Node cssFolder = this.getPortalCSSFolder(portal);
        String statement = StringUtils.replaceOnce((String)preStatement, (String)"{path}", (String)cssFolder.getPath());
        String cssData = this.getCSSDataBySQLQuery(portal.getSession(), statement, exceptedPath);
        if (appendedCSS != null) {
            cssData = cssData == null ? appendedCSS : cssData.concat(appendedCSS);
        }
        if (!(allowEmptyCSS || cssData != null && cssData.length() != 0)) {
            return;
        }
        String skinPath = StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"(.*)", (String)portal.getName());
        for (String skinName : this.skinService.getAvailableSkinNames()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
            this.skinService.addSkin(portal.getName(), skinName, skinPath, cssData);
        }
    }

    private void addSharedPortalSkin(Node portal, String preStatement, String exceptedPath, String appendedCSS, boolean allowEmptyCSS) throws Exception {
        Node cssFolder = this.getPortalCSSFolder(portal);
        String statement = StringUtils.replaceOnce((String)preStatement, (String)"{path}", (String)cssFolder.getPath());
        String cssData = this.getCSSDataBySQLQuery(portal.getSession(), statement, exceptedPath);
        if (appendedCSS != null) {
            cssData = cssData == null ? appendedCSS : cssData.concat(appendedCSS);
        }
        if (!(allowEmptyCSS || cssData != null && cssData.length() != 0)) {
            return;
        }
        String skinPath = StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"(.*)", (String)portal.getName());
        for (String skinName : this.skinService.getAvailableSkinNames()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
            this.skinService.addPortalSkin(portal.getName(), skinName, skinPath, cssData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCSSDataBySQLQuery(Session session, String statement, String exceptedPath) throws Exception {
        Session querySession = null;
        QueryManager queryManager = null;
        try {
            if (session.isLive()) {
                queryManager = session.getWorkspace().getQueryManager();
            } else {
                Repository repository = session.getRepository();
                querySession = repository.login(session.getWorkspace().getName());
                queryManager = querySession.getWorkspace().getQueryManager();
            }
            Query query = queryManager.createQuery(statement, "sql");
            QueryResult queryResult = query.execute();
            StringBuffer buffer = new StringBuffer();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                Node jcrContent;
                String mimeType;
                Node cssFile = iterator.nextNode();
                if (cssFile.getPath().equals(exceptedPath) || !"text/css".equals(mimeType = (jcrContent = cssFile.getNode("jcr:content")).getProperty("jcr:mimeType").getString())) continue;
                String css = jcrContent.getProperty("jcr:data").getString();
                buffer.append(css);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (querySession != null) {
                querySession.logout();
            }
        }
    }

    private Node getPortalCSSFolder(Node portal) throws Exception {
        PortalFolderSchemaHandler schemaHandler = this.schemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
        return schemaHandler.getCSSFolder(portal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        log.info((Object)"Start WCMSkinService...");
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            LivePortalManagerService livePortalManagerService = (LivePortalManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LivePortalManagerService.class);
            Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
            this.addSharedPortalSkin(sharedPortal, SHARED_CSS_QUERY, null, null, false);
            List<Node> livePortals = livePortalManagerService.getLivePortals(sessionProvider);
            for (Node portal : livePortals) {
                this.addPortalSkin(portal, SHARED_CSS_QUERY, null, null, false);
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Exception when start XSkinService", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

