/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webos.toolbar;

import java.util.Collection;
import java.util.Collections;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.webos.toolbar.UIUserToolbarDesktopPortlet;
import org.exoplatform.webos.webui.page.UIDesktopPage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/webui/component/UIUserToolBarDesktopPortlet.gtmpl", events={@EventConfig(name="AddDefaultDashboard", listeners={AddDashboardActionListener.class}), @EventConfig(listeners={CreateWebOSActionListener.class}), @EventConfig(listeners={NavigationChangeActionListener.class})})
public class UIUserToolbarDesktopPortlet
extends UIPortletApplication {
    public static String DEFAULT_TAB_NAME = "Tab_Default";
    private UserNodeFilterConfig toolbarFilterConfig;

    public UIUserToolbarDesktopPortlet() throws Exception {
        UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
        builder.withAuthorizationCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL}).withTemporalCheck();
        this.toolbarFilterConfig = builder.build();
    }

    public UserNavigation getCurrentUserNavigation() throws Exception {
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return this.getNavigation(SiteKey.user((String)rcontext.getRemoteUser()));
    }

    private UserNavigation getNavigation(SiteKey userKey) {
        UserPortal userPortal = this.getUserPortal();
        return userPortal.getNavigation(userKey);
    }

    private UserPortal getUserPortal() {
        UIPortalApplication uiPortalApplication = Util.getUIPortalApplication();
        return uiPortalApplication.getUserPortalConfig().getUserPortal();
    }

    private UserNode getSelectedNode() throws Exception {
        return Util.getUIPortal().getSelectedUserNode();
    }

    private boolean isWebOSNode(UserNode userNode) throws Exception {
        if (userNode == null) {
            return false;
        }
        String pageRef = userNode.getPageRef();
        if (pageRef == null) {
            return false;
        }
        DataStorage ds = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Page page = ds.getPage(pageRef);
        return page == null || UIDesktopPage.DESKTOP_FACTORY_ID.equals(page.getFactoryId());
    }

    private boolean hasDashboardNode() throws Exception {
        Collection nodes = this.getUserNodes(this.getCurrentUserNavigation());
        return nodes.size() >= 1 && (nodes.size() != 1 || !this.isWebOSNode((UserNode)nodes.iterator().next()));
    }

    private boolean isWebOSCreated() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        DataStorage storage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Page page = storage.getPage(PortalConfig.USER_TYPE + "::" + context.getRemoteUser() + "::" + "webos");
        return page != null;
    }

    private UserNode getFirstNonWebOSNode(Collection<UserNode> nodes) throws Exception {
        for (UserNode node : nodes) {
            if (this.isWebOSNode(node)) continue;
            return node;
        }
        throw new NullPointerException("There is no dashboard node. The dashboard node existing should be checked before");
    }

    public Collection<UserNode> getUserNodes(UserNavigation nav) {
        UserPortal userPortall = this.getUserPortal();
        if (nav != null) {
            try {
                UserNode rootNode = userPortall.getNode(nav, Scope.CHILDREN, this.toolbarFilterConfig, null);
                return rootNode.getChildren();
            }
            catch (Exception exp) {
                log.warn((Object)(nav.getKey().getName() + " has been deleted"));
            }
        }
        return Collections.emptyList();
    }

    static /* synthetic */ boolean access$000(UIUserToolbarDesktopPortlet x0) throws Exception {
        return x0.hasDashboardNode();
    }

    static /* synthetic */ UserNode access$100(UIUserToolbarDesktopPortlet x0, Collection x1) throws Exception {
        return x0.getFirstNonWebOSNode(x1);
    }

    static /* synthetic */ UserPortal access$200(UIUserToolbarDesktopPortlet x0) {
        return x0.getUserPortal();
    }

    static /* synthetic */ UserNodeFilterConfig access$300(UIUserToolbarDesktopPortlet x0) {
        return x0.toolbarFilterConfig;
    }
}

