/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webos.toolbar;

import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webos.webui.page.UIDesktopPage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/webui/component/UIWebOSAdminToolbarPortlet.gtmpl")
public class UIWebOSAdminToolbarPortlet
extends UIPortletApplication {
    public UserNavigation getSelectedNavigation() throws Exception {
        return Util.getUIPortal().getUserNavigation();
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        if (!this.isOnDesktop() && (this.hasEditPermissionOnNavigation() || this.hasEditPermissionOnPage() || this.hasEditPermissionOnPortal())) {
            super.processRender(app, context);
        }
    }

    private boolean isOnDesktop() {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApp.getChildById("UIWorkingWorkspace");
        UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
        UIPage uiPage = (UIPage)pageBody.getUIComponent();
        return uiPage != null && UIDesktopPage.DESKTOP_FACTORY_ID.equals(uiPage.getFactoryId());
    }

    private boolean hasEditPermissionOnNavigation() throws Exception {
        UserNavigation selectedNavigation = this.getSelectedNavigation();
        if (selectedNavigation == null) {
            return false;
        }
        return selectedNavigation.isModifiable();
    }

    private boolean hasEditPermissionOnPortal() throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        return userACL.hasEditPermissionOnPortal(currentUIPortal.getOwnerType(), currentUIPortal.getOwner(), currentUIPortal.getEditPermission());
    }

    private boolean hasEditPermissionOnPage() throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApp.getChildById("UIWorkingWorkspace");
        UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
        UIPage uiPage = (UIPage)pageBody.getUIComponent();
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        if (uiPage != null) {
            return userACL.hasEditPermissionOnPage(uiPage.getOwnerType(), uiPage.getOwnerId(), uiPage.getEditPermission());
        }
        UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
        UserNode currentNode = currentUIPortal.getSelectedUserNode();
        String pageReference = currentNode.getPageRef();
        if (pageReference == null) {
            return false;
        }
        DataStorage dataStorage = (DataStorage)portalApp.getApplicationComponent(DataStorage.class);
        Page page = dataStorage.getPage(pageReference);
        return page != null && userACL.hasEditPermission(page);
    }
}

